package persistenceexample2.datafactory;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;

/**
 * Create class descriptors
 * The PackagePersistenceMaster instance provides descriptive information on Entity instances 
 * to be persisted. A application using perstistence has to implement PackagePersistenceMaster 
 * for the Entity instances it persists.
 * Entity instances are distinguished by the classtype.
 * 
 * In this example we declare a "license" and a "car" Entity. The multiplicityType is set to
 * single - license number and the car type have a 1:1 relation ship.
 * 
 * The "car" entity has attributes "make", "model", "enginetype", "cylinder", "valvespercylinder"
 * 
 */

class ExamplePackagePersistenceMaster implements PackagePersistenceMaster, EntityFactory {

	static DescriptorRuntime PDR = DescriptorRuntime.getInstance();

	static String[] CLASSTYPES = new String[] { Car.CLASSTYPE, License.CLASSTYPE };
	static AttributeDescriptor[] CAR_ATTRIBS;
	static AttributeDescriptor[] NO_ATTRIBS = new AttributeDescriptor[] {
	};
	static ClassDescriptor P_CLASS_LICENSE;
	static ClassDescriptor P_CLASS_CAR;

	static {
		try {
			CAR_ATTRIBS =
				new AttributeDescriptor[] {
					PDR.createAttributeDescriptor("make", AttributeType.STRING, 1, 20),
					PDR.createAttributeDescriptor("model", AttributeType.STRING, 1, 20),
					PDR.createAttributeDescriptor("enginetype", AttributeType.STRING, 1, 20),
					PDR.createAttributeDescriptor("cylinders", AttributeType.INTEGER, 1, 20),
					PDR.createAttributeDescriptor("valvespercylinder", AttributeType.INTEGER, 1, 20),
					};
			P_CLASS_CAR = PDR.createClassDescriptor(Car.CLASSTYPE, CAR_ATTRIBS, new LinkDescriptor[] { PDR.createLinkDescriptor("license", License.CLASSTYPE, MultiplicityType.SINGLE, true)});
			P_CLASS_LICENSE = PDR.createClassDescriptor(License.CLASSTYPE, NO_ATTRIBS, new LinkDescriptor[] { PDR.createLinkDescriptor("car", Car.CLASSTYPE, MultiplicityType.SINGLE, true)});
		} catch (Throwable t) {
			t.printStackTrace();
			System.exit(-1);
		}
	}

	ExamplePackagePersistenceMaster() {
	}

	public String getPackageName() {
		return null;
	}

	public String[] getClasstypes() {
		return CLASSTYPES;
	}

	public PersistableEntity createEntity(PersistenceContainer obj) {
		if (Car.CLASSTYPE.equals(obj.getClasstype())) {
			return new Car(obj);
		} else {
			return new License(obj);
		}
	}
	
	public ClassDescriptor getClassDescriptor(String classtype) {
		if (Car.CLASSTYPE.equals(classtype)) {
			return P_CLASS_CAR;
		} else {
			return P_CLASS_LICENSE;
		}
	}

	public PackagePersistenceMaster getPersistenceMaster() {
		return this;
	}

}