package persistenceexample4.page;

import java.awt.CardLayout;
import java.awt.Panel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

import persistenceexample4.Constants;
import persistenceexample4.PersistenceExample;
import persistenceexample4.actionHandler.PageActionHandler;
import persistenceexample4.dataHandler.BasicDataHandler;

import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.page.AbstractMEPage;
import com.sap.ip.me.mdk.api.awt.gui.page.ActionHandler;
import com.sap.ip.me.mdk.api.awt.gui.page.BasicPage;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.panel.FooterPanel;
import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * CenterPage is a customized implementation for the panel that is displayed in the middle of the MI AWT screen.
 * The initializePage() method loads the view that is an implementation of BasicPage.
 * The customizing also includes the eventhandlig methods for navigation, like moving up and down in a list
 */
public class CenterPage extends ControllerPage implements Constants {

	boolean listall;
	private int filter_index;
	private int sort_index;
	private boolean sort_ascending;
	private String clickedEntry;

	private static final int SPACER = 1;
	private BasicDataHandler dataHandler = null;
	private ActionHandler actionHandler = null;
	private static String _syncType = null;

	private AbstractMEPage _currentPage = null;
	private NavHelper _navHelper = null;
	private Vector _carListFull = null;
	private Vector _carListEntry = null;
	private CardLayout cardLayout = null;
	private Panel cardPanel = null;
	// Update FooterPanel
	private PersistenceExample _persistenceExample = null;
	private FooterPanel _footerPanel = null;
	// Character Navigation
	private static String[] charsNav = null;
	private static String[] specialChar = null;
	private static String[] filter_string = new String[1];

	/**
	 * Constructur CenterPage. - The center page can display data in list form or detail data
	 * @param  all - ?
	 */
	public CenterPage(int index, int sortIndex, boolean sort_type, String obj, PersistenceExample pE, FooterPanel fP) {
		super();
		double size[][] = { { 2, TableLayout.FILL, 2 }, {
				SPACER, TableLayout.FILL }
		};
		setLayout(new TableLayout(size));

		filter_index = index;
		sort_index = sortIndex;
		sort_ascending = sort_type;
		filter_string[0] = obj;
		_persistenceExample = pE;
		_footerPanel = fP;
		createCharNavigation();
		setAttribute(ATTR_CUR_NAV_CHAR, "All");

		cardLayout = new CardLayout();
		cardPanel = new Panel(cardLayout);
		add(cardPanel, "1,1");
		dataHandler = BasicDataHandler.instance(filter_index, sort_index, sort_ascending, filter_string);
		_navHelper = new NavHelper();
		actionHandler = new PageActionHandler(this);

		initializePage();
	}
	/**
	 * Methode getActionHandler()
	 * @return ActionHandler
	 */
	public ActionHandler getActionHandler() {
		return actionHandler;
	}
	/**
	 * Methode getSyncType()
	 * @return String
	 */
	public String getSyncType() {
		return _syncType;
	}
	//	public ContactDataHandler getDataHandler() {
	//		return dataHandler;
	//  }
	/**
	 * Methode initializePage()I
	 * Initialize DetailList and activate DetailList
	 */
	public void initializePage() {
		Utilities.setListCount(ROWS_PER_LONGPAGE);
		instantiatePage(TP_DETAILLIST);
		activatePage(TP_DETAILLIST);
		this.showList(true);
	}
	/**
	 * eventhandler methods
	 */
	/**
	 * Methode createCharNaivigation()
	 * Create chars for navigation between differnt character groups.
	 */
	public void createCharNavigation() {
		// Navigation characters
		charsNav = new String[7];
		// All characters from one navigation character groupe
		specialChar = new String[4];

		// Navigation characters
		charsNav[0] = "All";
		charsNav[1] = "A-D";
		charsNav[2] = "E-H";
		charsNav[3] = "I-M";
		charsNav[4] = "N-Q";
		charsNav[5] = "R-U";
		charsNav[6] = "V-Z";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute(ATTR_CHARS_NAV, charsNav);
		// All characters from one navigation character groupe
		specialChar[0] = "A";
		specialChar[1] = "B";
		specialChar[2] = "C";
		specialChar[3] = "D";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("A-D", specialChar);
		specialChar = new String[4];
		specialChar[0] = "E";
		specialChar[1] = "F";
		specialChar[2] = "G";
		specialChar[3] = "H";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("E-H", specialChar);
		specialChar = new String[5];
		specialChar[0] = "I";
		specialChar[1] = "J";
		specialChar[2] = "K";
		specialChar[3] = "L";
		specialChar[4] = "M";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("I-M", specialChar);
		specialChar = new String[5];
		specialChar[0] = "N";
		specialChar[1] = "O";
		specialChar[2] = "P";
		specialChar[3] = "Q";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("N-Q", specialChar);
		specialChar = new String[4];
		specialChar[0] = "R";
		specialChar[1] = "S";
		specialChar[2] = "T";
		specialChar[3] = "U";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("R-U", specialChar);
		specialChar = new String[5];
		specialChar[0] = "V";
		specialChar[1] = "W";
		specialChar[2] = "X";
		specialChar[3] = "Y";
		specialChar[4] = "Z";
		// Store this in a HashMap (AbstractMEPage)
		setAttribute("V-Z", specialChar);
	}
	/**
	 * Methode showCharacterList()
	 * Search datas from clicked character group
	 */
	public void showCharacterList() {
		// Set page number back to 1 to get all records of the character list right from the beginning
		Utilities.setDesiredPage(1);

		// inizialisiert filter index for display a character list
		BasicDataHandler.instance(Constants.I_MAKE, sort_index, sort_ascending, (String[]) this.getAttribute((String) getAttribute(ATTR_CUR_NAV_CHAR)));

		// fill data with the right entities (set filter_index and filter_string)
		Utilities.set_recCount(dataHandler.getDataCount());
		Vector data = dataHandler.getDataArray(Utilities.getStartIndex(), Utilities.getListCount());
		//Utilities.set_recCount(BasicDataHandler.instance(filter_index, sort_index, sort_ascending, filter_string, listall).getDataCount());
		//Vector data = dataHandler.getDataArray(Utilities.getStartIndex(), Utilities.getListCount());

		// Set the counts for footer navigation to switch to nextPage.
		NavHelper.PG_RECCOUNT = dataHandler.getDataCount();
		NavHelper.PG_CURPAGE = Utilities.getCurrentPageNumber();
		NavHelper.PG_PAGECOUNT = Utilities.getPageCount();
		NavHelper.PG_TOPPREV = Utilities.isTopPrevPagesAvailable();
		NavHelper.PG_NEXTLAST = Utilities.isNextLastPageAvailable();

		//Data from character list
		//			AbstractMEPage tPage =(AbstractMEPage) attributeTable.get(TP_CHARACTERLIST);
		AbstractMEPage tPage = (AbstractMEPage) attributeTable.get(TP_DETAILLIST);
		tPage.setAttribute(BasicPage.ATTR_OBJECTLIST, data);
		tPage.setAttribute(BasicPage.ATTR_NAVHELPER, _navHelper);

		updateFooterPanel("" + NavHelper.PG_RECCOUNT + "/" + dataHandler.getDataCount());

	}
	public void gotoFirstPage() {
		Utilities.setTopPageIndex();
		showList(true);
	}
	public void gotoPrevPage() {
		Utilities.setPrevPageIndex();
		showList(true);
	}
	public void gotoNextPage() {
		Utilities.setNextPageIndex();
		showList(true);
	}
	public void gotoLastPage() {
		Utilities.set_recCount(dataHandler.getDataCount());
		Utilities.setLastPageIndex();
		showList(true);
	}
	public void getDesiredPage() {
		_navHelper = (NavHelper) _currentPage.getObject();
		Utilities.setDesiredPage(NavHelper.PG_CURPAGE);
		showList(true);
	}
	public void showHome() {
		NavHelper.PG_RECCOUNT = dataHandler.getDataCount();
		updateFooterPanel("" + NavHelper.PG_RECCOUNT + "/" + dataHandler.getDataCount());
	}
	// handling show car detail - the name of clicked entry is stored in the ATTR_HANDLERARG
	public void showCarDetails() {
		clickedEntry = (String) getAttribute(ATTR_HANDLERARG);
		_carListEntry = dataHandler.getEntry(clickedEntry, 0);
		getDetail();
		updateFooterPanel("" + NavHelper.PG_CURENTRY + "/" + dataHandler.getDataCount());
	}

	private void getDetail() {
		_carListFull = dataHandler.getCurrentSubArray();

		NavHelper.PG_RECCOUNT = dataHandler.getDataCount();
		NavHelper.PG_CURENTRY = dataHandler.getCurrentEntry();
		NavHelper.PG_CURPAGE = Utilities.getCurrentPageNumber();
		NavHelper.PG_PAGECOUNT = Utilities.getPageCount();
		NavHelper.PG_TOPPREV = Utilities.isTopPrevPagesAvailable();
		NavHelper.PG_NEXTLAST = Utilities.isNextLastPageAvailable();

		AbstractMEPage tPage = (AbstractMEPage) attributeTable.get(TP_CARDETAIL);
		tPage.setAttribute(BasicPage.ATTR_CUROBJECT, _carListEntry);
		tPage.setAttribute(BasicPage.ATTR_OBJECTLIST, _carListFull);
		tPage.setAttribute(BasicPage.ATTR_NAVHELPER, _navHelper);
	}

	// Eventhandler to add a car - display page to enter the car details
	public void showCarCreate() {
		AbstractMEPage tPage = (AbstractMEPage) attributeTable.get(TP_CARCREATE);
		_carListEntry = new Vector();
		updateFooterPanel("Add Car");
		tPage.setAttribute(BasicPage.ATTR_CUROBJECT, _carListEntry);
//		_carListEntry = dataHandler.getEntry(clickedEntry, 0);
//		getDetail();
	}
	//	Eventhandler to add a car - this event is caused, when the user clicks on the save button
	//  on the "add a car" page.
	public void addCar() {
		_carListFull = (Vector) _currentPage.getObject();
		int i = 0;
		// add to persistence;
		dataHandler.addEntry(_carListFull.elementAt(1).toString(), _carListFull.elementAt(2).toString(), _carListFull.elementAt(4).toString(), _carListFull.elementAt(5).toString(), _carListFull.elementAt(6).toString(), _carListFull.elementAt(3).toString());
		setAttribute(ATTR_CUR_NAV_CHAR, "All");
		showList(true);
	}
	//	Eventhandler to delete a car - this event is caused, when the user clicks on the delete button
	//  on the car detail page.
	public void deleteCar() {
		dataHandler.delEntry((String) _currentPage.getObject());
		showList(true);
	}
	//	Eventhandler to delete a car - this event is caused, when the user clicks on the delete button
	//  on the car detail page.
	public void sortByCar() {
		if (sort_ascending == false) {
			sort_ascending = true;
		} else {
			sort_ascending = false;
		}
		showList(true);
	}
	// Eventhandlers for car detailpage. You can navigate to first, last, next and previous entry
	public void firstRecord() {
		_carListEntry = dataHandler.getEntry(dataHandler.getFirstEntryID(), 0);
		clickedEntry = (String) _carListEntry.elementAt(0);
		getDetail();
		showList(false);
	}
	public void lastRecord() {
		_carListEntry = dataHandler.getEntry(dataHandler.getLastEntryID(), 0);
		clickedEntry = (String) _carListEntry.elementAt(0);
		getDetail();
		showList(false);
	}
	public void nextRecord() {
		_carListEntry = dataHandler.getEntry(clickedEntry, 1);
		clickedEntry = (String) _carListEntry.elementAt(0);
		getDetail();
		showList(false);
	}
	public void prevRecord() {
		_carListEntry = dataHandler.getEntry(clickedEntry, -1);
		clickedEntry = (String) _carListEntry.elementAt(0);
		getDetail();
		showList(false);
	}

	// end of eventhandlers
	//show detail list of all entries in data set
	//showList() is for eventhandler that calls that method without parameter.
	public void showList() {
		showList(true);
	}

	public void showList(boolean update) {
		Utilities.set_recCount(BasicDataHandler.instance(filter_index, sort_index, sort_ascending, filter_string).getDataCount());
		Vector data = dataHandler.getDataArray(Utilities.getStartIndex(), Utilities.getListCount());

		NavHelper.PG_RECCOUNT = dataHandler.getDataCount();
		NavHelper.PG_CURPAGE = Utilities.getCurrentPageNumber();
		NavHelper.PG_PAGECOUNT = Utilities.getPageCount();
		NavHelper.PG_TOPPREV = Utilities.isTopPrevPagesAvailable();
		NavHelper.PG_NEXTLAST = Utilities.isNextLastPageAvailable();

		AbstractMEPage tPage = (AbstractMEPage) attributeTable.get(TP_DETAILLIST);
		tPage.setAttribute(BasicPage.ATTR_OBJECTLIST, data);
		tPage.setAttribute(BasicPage.ATTR_NAVHELPER, _navHelper);
		if (update == true) {
			updateFooterPanel("" + NavHelper.PG_RECCOUNT + "/" + dataHandler.getDataCount());
		} else {
			updateFooterPanel("" + NavHelper.PG_CURENTRY + "/" + dataHandler.getDataCount());
		}
	}
	public void destroyPage() {
		removeAll();
	}
	public void instantiatePage(String nextPage) {
		if (nextPage == null || nextPage.equals(""))
			return;

		String pageClass = TP_PAGEBASE + nextPage;
		AbstractMEPage newPage = (AbstractMEPage) createObject(pageClass, this);

		if (newPage == null)
			return;

		attributeTable.put(nextPage, newPage);

		newPage.initializePage();
		cardPanel.add(nextPage, newPage);
		Utilities.print("ControllerPage:" + nextPage + " instance created and initialized!");
	}
	public void activatePage(String nextPage) {
		_currentPage = (AbstractMEPage) attributeTable.get(nextPage);
		cardLayout.show(cardPanel, nextPage);
		//_navHelper.RET_MESSAGE = "";
	}
	public boolean isPageInitialized(String pageName) {
		return attributeTable.containsKey(pageName);
	}
	public void updateCurrentPage() {
		_currentPage.updatePage();
	}
	public void deactivateCurrentPage() {
		_currentPage.destroyPage();
	}
	/** Methode runHandler()
	 *  Set the name of clicked button or link
	 * 	@param String and arg - handlerName (currentPage) and clicked link name
	 */
	public void runHandler(String handlerName, Object arg) {
		NavHelper.RET_MESSAGE = "";
		if (handlerName == null || handlerName.equals(""))
			return;
		if (arg != null) {
			//set clicked link in HashMap (AbstractMEPage), only attribute for clicked character groups
			if (handlerName.equals(HND_CHARACTERLIST) || arg.equals("All")) {
				setAttribute(ATTR_CUR_NAV_CHAR, arg);
			} else
				setAttribute(ATTR_HANDLERARG, arg);
		}
		try {
			// ?
			Method methodInvoker = this.getClass().getMethod(handlerName, new Class[] {
			});
			methodInvoker.invoke(this, new Object[] {
			});
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
	}
	//without the current char
	/*public void runHandler(String handlerName, Object arg) {
		NavHelper.RET_MESSAGE = "";
		if (handlerName == null || handlerName.equals(""))
			return;
		if (arg != null)
			setAttribute(ATTR_HANDLERARG, arg);
		try {
			Method methodInvoker = this.getClass().getMethod(handlerName, new Class[] {
			});
			methodInvoker.invoke(this, new Object[] {
			});
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
	}*/
	private static final Object createObject(String className, ControllerPage consParam) {
		Utilities.print("CenterPage.createObject called: " + consParam.getClass().toString());
		Object res = null;
		try {
			Class clazz = Class.forName(className);
			Class parType[] = { ControllerPage.class };
			Constructor con = clazz.getConstructor(parType);
			Object arglist[] = { consParam };
			res = con.newInstance(arglist);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return res;
	}
	/**
	 * Methode updateFooterPanel()
	 * Set the  page counts in footerPanel
	 */

	public void updateFooterPanel(String information) {
		_footerPanel.setPlaceInfo(information);
	}

	public void commit() {
		dataHandler.commit();
	}

}
