package persistenceexample4.page;
import java.awt.Choice;
import java.awt.Component;
import java.awt.TextField;
import java.util.Vector;

import persistenceexample4.Constants;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.InputField;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.page.CreatePage;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
/**
 *
 */
public class CarCreatePage extends CreatePage {

	private Vector _currentCar = null;

	public static TextLabel tlCarNo = new TextLabel(PageConstants.FLD_PFLDNAMES[0]);
	public static TextLabel tlManufacturer = new TextLabel(PageConstants.FLD_PFLDNAMES[1]);
	public static TextLabel tlModel = new TextLabel(PageConstants.FLD_PFLDNAMES[2]);
	public static TextLabel tlEngine = new TextLabel(PageConstants.FLD_PFLDNAMES[3]);
	public static TextLabel tlCylinders = new TextLabel(PageConstants.FLD_PFLDNAMES[4]);
	public static TextLabel tlValves = new TextLabel(PageConstants.FLD_PFLDNAMES[5]);
	public static TextLabel tlLicense = new TextLabel(PageConstants.FLD_PFLDNAMES[6]);

	private TextField tfManufacturer = null;
	private TextField tfModel = null;
	private Choice chEngine = null;
	private Choice chCylinders = null;
	private Choice chValves = null;
	private TextField tfLicense = null;

	public CarCreatePage(ControllerPage mainPage) {
		super(mainPage.getActionHandler());

		tfManufacturer = ComponentConstants.createTextField(18, 40, false);
		tfModel = ComponentConstants.createTextField(18, 40, false);
		((InputField) tfModel).setMandatory(new LinkButton[] { this.saveButton });
		this.saveButton.setEnabled(false);
		chEngine = ComponentConstants.createChoice(PageConstants.FLD_ENGINE, null, PageConstants.FLD_ENGINE[0]);
		chCylinders = ComponentConstants.createChoice(PageConstants.FLD_CYLINDER, null, PageConstants.FLD_CYLINDER[0]);
		chValves = ComponentConstants.createChoice(PageConstants.FLD_VALVES, null, PageConstants.FLD_VALVES[0]);
		tfLicense = ComponentConstants.createTextField(8, 12, false);
	}

	public void initializePage() {
		Utilities.print("CarCreatePage.initializePage called");
		this.setHeaderTexts(new String[] { "Add car to inventory:" });
		this.setFormField(tlManufacturer, new Component[] { tfManufacturer });
		this.setFormField(tlModel, new Component[] { tfModel });
		this.setFormField(tlEngine, new Component[] { chEngine });
		this.setFormField(tlCylinders, new Component[] { chCylinders });
		this.setFormField(tlValves, new Component[] { chValves });
		this.setFormField(tlLicense, new Component[] { tfLicense });
		this.setSaveActionAttributes(Constants.TP_CARHOME, Constants.HND_ADDCAR);
		this.setCancelActionAttributes(Constants.TP_CARHOME, Constants.HND_SHOWHOME, Constants.TP_DETAILLIST, Constants.HND_CHARACTERLIST);

		Utilities.print("CarCreatePage.initializePage ended");
	}
	public void destroyPage() {
		Utilities.print("CarCreatePage.destroyPage called");
		//this.clearAttributes();
		Utilities.print("CarCreatePage.destroyPage ended");
	}
	public void updatePage() {
		//different pages if it is clicked All or another char
 		this.setCancelActionAttributes(Constants.TP_CARHOME, Constants.HND_SHOWHOME, Constants.TP_DETAILLIST, Constants.HND_CHARACTERLIST);
		Utilities.print("CarCreatePage.updatePage called");
		tfManufacturer.setText("");
		tfModel.setText("");
		chEngine.select(0);
		chValves.select(0);
		chCylinders.select(0);
		tfLicense.setText("");
		Utilities.print("CarCreatePage.updatePage ended");
	}
	public Object getObject() {
		_currentCar = (Vector) getAttribute(ATTR_CUROBJECT);
		_currentCar.addElement("Ent");
// Convert the beginning character of the manufacturer always to uppercase so that the selecting of the cars works properly
        String make = tfManufacturer.getText().substring(1);
		_currentCar.addElement(tfManufacturer.getText().substring(0, 1).toUpperCase() + make);
		_currentCar.addElement(tfModel.getText());
		_currentCar.addElement(tfLicense.getText());
		_currentCar.addElement("" + chEngine.getSelectedItem());
		_currentCar.addElement("" + chCylinders.getSelectedItem());
		_currentCar.addElement("" + chValves.getSelectedItem());
		return _currentCar;
	}
}
