package persistenceexample4.dataHandler;

import java.util.Vector;

import persistenceexample4.Constants;
import persistenceexample4.datafactory.ReadWriteEntities;

import com.sap.ip.me.api.services.MeIterator;

public class BasicDataHandler implements Constants {
	private static int columns;
	public static MeIterator persistenceEntities;
	private Vector retSubVec;
	private static BasicDataHandler bdh = null;

	private static int filter_index;
	private static int sort_index;
	private static boolean sort_ascending;
	private static String[] filter_string_array;
	private static int currentPage;
	private static int start_index;
	private static int recCount;
	private static int currentIndex;

	private static String miHomeFolder;
	/**
	 * Method for entries with spezial character
	 */
	public static BasicDataHandler instance(int index, int sortIndex, boolean sort_type, String[] obj) {
		if (bdh == null)
			bdh = new BasicDataHandler();
		filter_index = index;
		sort_index = sortIndex;
		sort_ascending = sort_type;
		//Characters which clicked in the navigation
		filter_string_array = obj;

		generateData();
		return bdh;
	}
	/**
	 * Method creates the demodata to be displayed
	 */
	private static void generateData() {
		// Read data from persistence layer according to filter settings and append it to the header.
		columns = 4;
		persistenceEntities = ReadWriteEntities.readEntity(filter_index, sort_index, sort_ascending, filter_string_array);
	}
	private String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		String vartmp = var;
		if (vartmp == null)
			vartmp = "Not available";
		return vartmp;
	}
	//creates  a subarray of the full dataset defined by a start index and the number of rows
	//The result is returned and also kept locally as retSubVec to be retrieved by the bean
	public Vector getDataArray(int fromIndex, int count) {
        retSubVec = ReadWriteEntities.getEntities(persistenceEntities, fromIndex, count);		
		return retSubVec; 
	}


	//	returns a specific entry of the current subarray
	public void addEntry(String make, String model, String eng, String cyl, String valv, String lic) {
		ReadWriteEntities.addEntity(make, model, eng, cyl, valv, lic);
	}

	//	delete entry
	public void delEntry(String id) {
		ReadWriteEntities.deleteEntity(id);
	}

	//	saves all entries in the database
	public void commit() {
		ReadWriteEntities.commit();
	}	

	// returns the current subarray that has been created with getDataArray
	public Vector getCurrentSubArray() {
		return retSubVec;
	}
	//returns a specific entry of the current subarray
	public String getCurrentSubTableContent(int row, int column) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return "&nbsp;";
		}
		Vector data = (Vector) retSubVec.elementAt(row);
		return data.elementAt(column).toString();
	}
	//returns a specific row of the current subarray
	public Vector getCurrentSubTableVector(int row) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return null;
		}
		Vector data = (Vector) retSubVec.elementAt(row);
		return data;
	}

	public int getDataCount() {
		return ReadWriteEntities.getPersistedEntityCount();
	}

	//	returns a specific entry specified by id
	public Vector getEntry(String id, int prev) {
		currentIndex = ReadWriteEntities.getEntity(persistenceEntities, id, prev);
		Vector dataVektor = ReadWriteEntities.getEntities(persistenceEntities, currentIndex, 1);
		return (Vector) dataVektor.elementAt(0);
	}

	//	returns a the first id of the array
	public String getFirstEntryID() {
		Vector dataVektor = ReadWriteEntities.getEntities(persistenceEntities, 0, 1);	
		Vector dataEntry = (Vector) dataVektor.elementAt(0);
		return dataEntry.elementAt(0).toString();
	}

	//	returns a the first id of the array
	public String getLastEntryID() {
		Vector dataVektor = ReadWriteEntities.getEntities(persistenceEntities, ReadWriteEntities.getPersistedEntityCount()-1, 1);	
		Vector dataEntry = (Vector) dataVektor.elementAt(0);
		return dataEntry.elementAt(0).toString();
	}

	public String getNextEntryID() {
		if (currentIndex < ReadWriteEntities.getPersistedEntityCount()) currentIndex++;
		Vector dataEntry = ReadWriteEntities.getEntities(persistenceEntities, currentIndex, 1);		
		return dataEntry.elementAt(0).toString();
	}

	//	returns a the first id of the array
	public String getPrevEntryID() {
		if (currentIndex > 0) currentIndex--;
		Vector dataEntry = ReadWriteEntities.getEntities(persistenceEntities, currentIndex, 1);		
		return dataEntry.elementAt(0).toString();
	}

	public int getCurrentEntry() {
		return currentIndex;
	}

	/**
	 * used to set the MI homefolder from the main application
	 */
	public void setMiHomeFolder(String string) {
		miHomeFolder = string;
	}
	public String getMiHomeFolder() {
		return miHomeFolder;
	}

	public int getColumns() {
		return columns;
	}
}
