package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.component.BorderedLabel;
import com.sap.ip.me.mdk.api.awt.gui.component.BorderedPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;

/**
 * Creates a panel for a menu - text string representing the command and a
 * special background.
 */
public class MenuPanel extends Panel {
	public static final int VERTICAL = 300;
	public static final int HORIZONTAL = 301;
	private BorderedLabel titleLabel = null;
	private static Font textFont = ComponentConstants.fntBold11Dialog;
	private static Color titleBGColor = ComponentConstants.headerBodyBGColor;
	private static Color titleColor = ComponentConstants.headerTextColor;
	private BorderedPanel bp = null;
	private BorderedPanel mnuPanel = null;

	public MenuPanel(String title) {
		super();
		titleLabel = new BorderedLabel(title);
		titleLabel.setFont(textFont);
		titleLabel.setForeground(titleColor);
		titleLabel.setBackground(titleBGColor);

		double size[][] = { { 0, TableLayout.FILL }, // Columns
			              { TableLayout.MINIMUM, TableLayout.PREFERRED, TableLayout.PREFERRED, TableLayout.FILL }
		}; // Rows
		setLayout(new TableLayout(size));
		add(titleLabel, "1,0");
	}

	public void addMenus(Component[] c) {
		mnuPanel = createList(c, VERTICAL);
		addMenuPanel(mnuPanel);
	}
	public void removeMenus() {
		remove(bp);
		validate();
	}

	public void addBottomNavPanel(Component[] c) {
		addFooterPanel(createList(c, HORIZONTAL));
	}
	public void addMenuPanel(Panel p) {
		add(p, "1,1");
		repaint();
	}
	public void addFooterPanel(Panel p) {
		add(p, "1,2");
		repaint();
	}
	public void addSyncButton(Component c) {
		if (mnuPanel != null)
			mnuPanel.add(c, "2,0");
	}
	public void paint(Graphics g) {

		if (isShowing()) {
			g.setColor(Color.gray);
			g.drawRect(0, 0, getSize().width, getSize().height);
		}
		super.paint(g);
	}

	public BorderedPanel createList(Component[] c, int type) {

		double rcCount[] = new double[c.length];
		for (int i = 0; i < rcCount.length; i++)
			rcCount[i] = TableLayout.PREFERRED;

		if (type == VERTICAL) {
			double size[][] = { { .05, TableLayout.PREFERRED, TableLayout.FILL }, rcCount };
			bp = new BorderedPanel(new TableLayout(size));
			bp.enableBGDraw(true);
			bp.setBorderMask("BLR");
			for (int i = 0; i < rcCount.length; i++)
				bp.add(c[i], "1," + i);
		} else if (type == HORIZONTAL) {
			double size[][] = { rcCount, { TableLayout.PREFERRED }
			}; // Rows
			bp = new BorderedPanel(new TableLayout(size));
			bp.enableBGDraw(true);
			bp.setBorderMask("BLR");
			for (int i = 0; i < rcCount.length; i++)
				bp.add(c[i], (c.length - 1 - i) + ",0");
		}
		bp.validate();
		return bp;
	}
}
