package com.sap.ip.me.mdk.api.awt.gui.page;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * Class the examples use to handle events
 */
public abstract class ActionHandler implements MouseListener {

	protected ControllerPage controlPage = null;

	public ActionHandler(ControllerPage ctrlPage) {
		controlPage = ctrlPage;
	}

	public abstract void handleEvent(Object src);

	public void mouseClicked(MouseEvent event) {
		Object src = event.getSource();
		handleEvent(src);
	}
	public void mousePressed(MouseEvent event) {
	}
	public void mouseReleased(MouseEvent event) {
	}
	public void mouseEntered(MouseEvent event) {
	}
	public void mouseExited(MouseEvent event) {
	}

}
