package genericsyncexample1.bean;
import genericsyncexample1.GenericSyncExample;

import com.sap.ip.me.api.logging.Severities;

/**
 *  JavaBean containing user information. <P>
 *
 *  <B>Ger.:</B> Benutzerinformationen
 *
 *@author    Jan Wetzel
 *@created    23. January 2003
 */
public class UserInformation {

  /**
   *  0:1 association between UserInformation and UserInformation
   *  The singleton instance of the user information.
   */
  private static UserInformation uiInstance;
   	
  /**
   *  R/3 user name (12 character).
   */
  private String userName = "";
  /**
   *  The first name of the user.
   */
  private String firstName = "";
  /**
   *  The last name of the user.
   */
  private String lastName = "";
  /**
   *  The appellation for the user like Mr or Prof.
   */
  private String salut = "";
  /**
   *  The phone numer of the user as String
   */
  private String phone = "";
  /**
   *  The building of the user's office.
   */
  private String building = "";
  /**
   *  The room of the user's office.
   */
  private String room = "";
  /**
   *  The country id of the user's office.
   */
  private String country = "";
  /**
   *  The comany name where the user works.
   */
  private String companyName = "";
  /**
   *  The R/3 mandant.
   */
  private String mandant = "";


  // ---- constructors
  /**
   *  Constructor. Initializes all attributes with the empty String.
   */
  public UserInformation() {
    mandant = userName = firstName = lastName = companyName = salut = building = room = country = phone = "";
  }

  /**
   *  Returns the singleton instance of the UserInformation.
   *
   *@return    The instance value
   */
  public static UserInformation getInstance() {
    if (uiInstance == null) {
      uiInstance = new UserInformation();
    }
    GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformationManager: getInstance() returns {0}", uiInstance);
    return uiInstance;
  }


  /**
   *  <B>Documentation copied from attribute userName</B> <p>
   *
   *  R/3 user name (12 character).
   *
   *@return    The userName value
   */
  public String getUserName() {
    return userName;
  }


  /**
   *  <B>Documentation copied from attribute userName</B> <p>
   *
   *  R/3 user name (12 character).
   *
   *@param  newUserName  The new userName value
   */
  public void setUserName(String newUserName) {
    userName = newUserName;
  }


  /**
   *  <B>Documentation copied from attribute firstName</B> <p>
   *
   *  The first name of the user.
   *
   *@return    The firstName value
   */
  public String getFirstName() {
    return firstName;
  }


  /**
   *  <B>Documentation copied from attribute firstName</B> <p>
   *
   *  The first name of the user.
   *
   *@param  newFirstName  The new firstName value
   */
  public void setFirstName(String newFirstName) {
    firstName = newFirstName;
  }


  /**
   *  <B>Documentation copied from attribute lastName</B> <p>
   *
   *  The last name of the user.
   *
   *@return    The lastName value
   */
  public String getLastName() {
    return lastName;
  }


  /**
   *  <B>Documentation copied from attribute lastName</B> <p>
   *
   *  The last name of the user.
   *
   *@param  newLastName  The new lastName value
   */
  public void setLastName(String newLastName) {
    lastName = newLastName;
  }


  /**
   *  <B>Documentation copied from attribute salut</B> <p>
   *
   *  The appellation for the user like Mr or Prof.
   *
   *@return    The salut value
   */
  public String getSalut() {
    return salut;
  }


  /**
   *  <B>Documentation copied from attribute salut</B> <p>
   *
   *  The appellation for the user like Mr or Prof.
   *
   *@param  newSalut  The new salut value
   */
  public void setSalut(String newSalut) {
    salut = newSalut;
  }


  /**
   *  <B>Documentation copied from attribute phone</B> <p>
   *
   *  The phone numer of the user as String
   *
   *@return    The phone value
   */
  public String getPhone() {
    return phone;
  }


  /**
   *  <B>Documentation copied from attribute phone</B> <p>
   *
   *  The phone numer of the user as String
   *
   *@param  newPhone  The new phone value
   */
  public void setPhone(String newPhone) {
    phone = newPhone;
  }


  /**
   *  <B>Documentation copied from attribute building</B> <p>
   *
   *  The building of the user's office.
   *
   *@return    The building value
   */
  public String getBuilding() {
    return building;
  }


  /**
   *  <B>Documentation copied from attribute building</B> <p>
   *
   *  The building of the user's office.
   *
   *@param  newBuilding  The new building value
   */
  public void setBuilding(String newBuilding) {
    building = newBuilding;
  }


  /**
   *  <B>Documentation copied from attribute room</B> <p>
   *
   *  The room of the user's office.
   *
   *@return    The room value
   */
  public String getRoom() {
    return room;
  }


  /**
   *  <B>Documentation copied from attribute room</B> <p>
   *
   *  The room of the user's office.
   *
   *@param  newRoom  The new room value
   */
  public void setRoom(String newRoom) {
    room = newRoom;
  }


  /**
   *  <B>Documentation copied from attribute country</B> <p>
   *
   *  The country id of the user's office.
   *
   *@return    The country value
   */
  public String getCountry() {
    return country;
  }


  /**
   *  <B>Documentation copied from attribute country</B> <p>
   *
   *  The country id of the user's office.
   *
   *@param  newCountry  The new country value
   */
  public void setCountry(String newCountry) {
    country = newCountry;
  }


  /**
   *  <B>Documentation copied from attribute companyName</B> <p>
   *
   *  The comany name where the user works.
   *
   *@return    The companyName value
   */
  public String getCompanyName() {
    return companyName;
  }


  /**
   *  <B>Documentation copied from attribute companyName</B> <p>
   *
   *  The comany name where the user works.
   *
   *@param  newCompany  The new companyName value
   */
  public void setCompanyName(String newCompany) {
    companyName = newCompany;
  }


  /**
   *  <B>Documentation copied from attribute mandant</B> <p>
   *
   *  The R/3 mandant.
   *
   *@return    The mandant value
   */
  public String getMandant() {
    return mandant;
  }


  /**
   *  <B>Documentation copied from attribute mandant</B> <p>
   *
   *  The R/3 mandant.
   *
   *@param  newMandant  The new mandant value
   */
  public void setMandant(String newMandant) {
    mandant = newMandant;
  }


  /**
   *  For test purposes only. Dumps the bean content to the trace file with
   *  trace level DEVELOP_LEVEL.
   *
   *@param  msg  Description of the Parameter
   */
  public void dump(String msg) {
    GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: ************************************************************");
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: {0}", msg);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Mandant: {0}", mandant);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Username: {0}", userName);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Name: {0} {1} {2}", salut, firstName, lastName);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Company: {0}", companyName);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Location: {0} / {1}", building, room);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Phone: {0}", phone);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: Country: {0}", country);
	GenericSyncExample.aLogger.log(Severities.DEBUG, "UserInformation: ************************************************************");
  }


  /**
   *  Description of the Method
   *
   *@return    Description of the Return Value
   */
  public String toString() {
    return getUserName() + ": " + getFirstName() + " " + getLastName() + " " + getCompanyName();
  }
}
