package example1.actionHandler;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.actionHandler.ActionHandler;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
/**
 * Customized event handler
 */
public class PageActionHandler extends ActionHandler {

	public PageActionHandler(ControllerPage ctrlPage) {
		super(ctrlPage);
	}

	public void handleEvent(Object src) {
		if (src instanceof LinkButton) {
			LinkButton lnkBtn = (LinkButton) src;
			//show the wait cursor
			lnkBtn.showWaitCursor();

			//get the nex page
			String targetLink = lnkBtn.getTargetPage();
			//if the targetPage is set
			if (targetLink != null && !targetLink.equals("")) {
				//instantiate the page if not yet
				if (!controlPage.isPageInitialized(targetLink))
					this.controlPage.instantiatePage(targetLink);
				//run the target handler
				controlPage.runHandler(lnkBtn.getTargetHandler(), lnkBtn.getName());
				//activate the currentPage
				this.controlPage.activatePage(targetLink);
			} else {
				//run the target handler
				controlPage.runHandler(lnkBtn.getTargetHandler(), lnkBtn.getName());
			}
			//update the page
			this.controlPage.updateCurrentPage();
			//put back the default cursor
			lnkBtn.showDefaultCursor();
		}
	}

}
