package example1;

import java.awt.BorderLayout;
import java.awt.MenuItem;
import java.awt.Panel;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.awt.AwtApplication;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.panel.FooterPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.HeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

import example1.page.CenterPage;

/**
 * The MI AWT example implements the AwtApplication interface.
 * Constants contains constant values that should be used in the application. Constants
 * defines the string. This string is the technical name of this
 * application and is also used bei the MDK Plug-in to create the archive name.
 */
public class SystemInfo extends Panel implements AwtApplication, Constants {
	private static HeaderPanel chp = null;
	private static FooterPanel cfp = null;
	private static ControllerPage cmp = null;
// For alternative - see activateApplication	private static ScrollPane sPane = null;

	/* This method returns the name of the MI application. The name has to match the 
	 * archive name and the application name specified in the MI WebConsole.
	 */
	public String getApplicationName() {
		return MI_APPLICATION_NAME;
	}

	public Panel getRootPanel() {
		return this;
	}

	public void actionMenuItem(MenuItem selectedItem) {
		/* This method is activated when the user selects a menu item in the MI AWT window
		 * (for example Action -> Sync). With the getLabel() method of the MenuItem object
		 * the selected item can be identified.
		 * Example:
		 *    if (selectedItem.getLabel().compareTo("Exit") == 0) {
		 *    } 
		 */
	}

	public void initApplication() {
		/* This method is activated when the application is activated in the MI AWT window
		 * (Application -> myApplication) for the first time after the MI framework has been 
		 * started.
		 * This method is used to set up the application, like initializing variables.
		 * Subsequent activations of the application from the MI AWT window skip this
		 * method and call the activateApplication() method. 
		 */
		Utilities.setALogger(AppLog.getInstance(MI_APPLICATION_NAME));
	}

	public void activateApplication() {
		/* This method is activated when the application is activated in the MI AWT window
		 * (Application -> myApplication) everytime, except when the application is already
		 * active.
		 * This method contains the code that is needed to run the application.
		 */
		setLayout(new BorderLayout());

		chp = new HeaderPanel(Utilities.getImage(Utilities.iconLogo));
		chp.setWelcomeText("MDK");

		cfp = new FooterPanel("MI configuration API");
		cfp.setPlaceInfo(MI_APPLICATION_NAME);

		cmp = new CenterPage();

		add("North", chp);
		add("South", cfp);
		/*
		 * Add center panel that contains the data as non-scrollable area. The examples do not need 
		 * vertical scrolling, since the navigation takes care about that. Horizontal scrolling could 
		 * be helpful sometimes, when the data exceeds the MI AWT window width.
		 * If you want a scrollable data area, disable the following command line
		 */
		add("Center", cmp);

		/* Alternative - put the data in scrollable pane - for example if the data exceeds the MI AWT 
		 * window borders and cannot be truncated.
		
				sPane = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
				sPane.add(cmp);
				sPane.setSize(cmp.getSize());
				add("Center",sPane); - this instead of add("Center", cmp); */

		cmp.updateCurrentPage();
	}

	public void deactivateApplication() {
		/* This method is called when the user selects another application in the MI AWT window.
		 * This method can be used to do final steps before the application is terminated. 
		 */
	}

	public void destroyApplication() {
		/* This method is called when the user logs off from the MI.
		 * This method can be used to do final steps before the application is terminated - similar
		 * to method deactivateApplication().
		 */
	}
}
