******************************************** Begin of MDK_INVENTORY_CREATE ******************************
FUNCTION MDK_INVENTORY_CREATE.
*"----------------------------------------------------------------------
*"*"Local Interface:
*"  IMPORTING
*"     VALUE(IS_INVENTORY) TYPE  MDK_INVENTORY
*"  EXPORTING
*"     VALUE(EV_PRODUCTID) TYPE  MDK_INVENTORY-PRODUCTID
*"     VALUE(RETURN) TYPE  BAPIRET2
*"----------------------------------------------------------------------


*{   INSERT         FC5K900028                                        1
  DATA: ls_return    TYPE bapireturn1,
        lv_msgvar      type SYMSGV.

  CLEAR return.

* Assumption: productid not created yet

  is_inventory-createdate = sy-datum.
  is_inventory-createuser = sy-uname.
  is_inventory-createtime = sy-uzeit.
  is_inventory-changedate = sy-datum.
  is_inventory-changeuser = sy-uname.
  is_inventory-changetime = sy-uzeit.

  INSERT mdk_inventory FROM is_inventory.

  IF sy-subrc <> 0.

*   - DB Action failed (Error code = <sy-subrc>)
    move sy-subrc to lv_msgvar.
    CALL FUNCTION 'BALW_BAPIRETURN_GET1'
      EXPORTING
        type       = 'E'
        cl         = 'MDK_EXAMPLES'
        number     = '002'
        par1       = lv_msgvar
      IMPORTING
        bapireturn = ls_return.

    MOVE-CORRESPONDING ls_return TO return.

    EXIT.

  ENDIF.

  COMMIT WORK.

* - Product &1 created successfully
  ls_return-message_v1 = is_inventory-productid.
  ev_productid         = is_inventory-productid.

  CALL FUNCTION 'BALW_BAPIRETURN_GET1'
    EXPORTING
      type       = 'S'
      cl         = 'MDK_EXAMPLES'
      number     = '003'
      par1       = ls_return-message_v1
    IMPORTING
      bapireturn = ls_return.

  MOVE-CORRESPONDING ls_return TO return.

*}   INSERT



ENDFUNCTION.


******************************************** End of MDK_INVENTORY_CREATE ******************************
