FUNCTION merep_country_getlist.
*"----------------------------------------------------------------------
*"*"Local interface:
*"  IMPORTING
*"     VALUE(SPRAS) LIKE  MEREP_COUNTRYT-SPRAS DEFAULT 'EN'
*"  EXPORTING
*"     VALUE(RETURN) LIKE  BAPIRET2 STRUCTURE  BAPIRET2
*"  TABLES
*"      COUNTRYT STRUCTURE  MEREP_COUNTRYT
*"----------------------------------------------------------------------

* Assumption:
*
*  - English texts are completely available
*  - Non english texts can be a subset of the english texts
*  - Missing non english texts will be filled with the english

  DATA:
    lds_return      LIKE bapireturn1,
    ldt_countryt_en LIKE merep_countryt OCCURS 0,
    lds_countryt_en LIKE merep_countryt,
    ldt_countryt    LIKE merep_countryt OCCURS 0,
    lds_countryt    LIKE merep_countryt,
    ldf_dbcnt       LIKE sy-dbcnt,
    ldf_lines_en    TYPE i,
    ldf_lines       TYPE i.

  CLEAR return.

  SELECT COUNT(*) FROM merep_country.

  IF sy-subrc <> 0.

*   - No data in table MEREP_COUNTRY
    lds_return-type       = 'I'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '008'.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  IF spras IS INITIAL.

    spras = 'EN'.

  ENDIF.

  SELECT * FROM merep_countryt INTO TABLE ldt_countryt_en
                WHERE spras = 'EN'.

  IF spras = 'EN'.

    countryt[] = ldt_countryt_en[].

  ELSE.

    DESCRIBE TABLE ldt_countryt_en LINES ldf_lines_en.

    SELECT * FROM merep_countryt INTO TABLE ldt_countryt
                 WHERE spras = spras.

    DESCRIBE TABLE ldt_countryt LINES ldf_lines.

    IF ldf_lines < ldf_lines_en.

      LOOP AT ldt_countryt_en INTO lds_countryt_en.

        READ TABLE ldt_countryt INTO lds_countryt
                            WITH KEY land = lds_countryt_en-land.

        IF sy-subrc = 0.

          APPEND lds_countryt TO countryt.

        ELSE.

          APPEND lds_countryt_en TO countryt.

        ENDIF.

      ENDLOOP.

    ELSE.

      countryt[] = ldt_countryt_en[].

    ENDIF.

  ENDIF.

ENDFUNCTION.
