FUNCTION merep_contact_modify .
*"----------------------------------------------------------------------
*"*"Local interface:
*"  IMPORTING
*"     VALUE(PERSON) LIKE  MEREP_PERSON STRUCTURE  MEREP_PERSON
*"  EXPORTING
*"     VALUE(RETURN) LIKE  BAPIRET2 STRUCTURE  BAPIRET2
*"  TABLES
*"      ADDRESS STRUCTURE  MEREP_ADDRESS
*"      E_MAIL STRUCTURE  MEREP_E_MAIL
*"----------------------------------------------------------------------

  DATA:
      ldf_persnumber            LIKE merep_person-persnumber,
      lds_address               LIKE merep_address,
      lds_e_mail                LIKE merep_e_mail,
      lds_return                LIKE bapireturn1,
      lds_person                LIKE merep_person.

  CLEAR return.

  IF person-last_name IS INITIAL.

*   - Last name is mandatory
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '004'.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  SELECT SINGLE * FROM merep_person INTO lds_person
                         WHERE persnumber = person-persnumber.

  IF sy-subrc = 0.

    person-credat = lds_person-credat.
    person-crenam = lds_person-crenam.
    person-cretim = lds_person-cretim.
    person-chgdat = sy-datum.
    person-chgnam = sy-uname.
    person-chgtim = sy-uzeit.

    UPDATE merep_person FROM person.

  ELSE.

*   - DB update failed (Table name = &, Key = &)
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '002'.
    lds_return-message_v1 = 'MEREP_PERSON'.
    lds_return-message_v2 = person-persnumber.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
        par1   = lds_return-message_v1
        par2   = lds_return-message_v2
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.
  ENDIF.

  DELETE FROM merep_address
              WHERE persnumber = person-persnumber.

  DELETE FROM merep_e_mail
              WHERE persnumber = person-persnumber.

  LOOP AT address INTO lds_address.

    lds_address-persnumber = person-persnumber.
    MODIFY address FROM lds_address.

  ENDLOOP.

  LOOP AT e_mail INTO lds_e_mail.

    lds_e_mail-persnumber = person-persnumber.
    MODIFY e_mail FROM lds_e_mail.

  ENDLOOP.

  IF NOT address[] IS INITIAL.

    INSERT merep_address FROM TABLE address.

    IF sy-subrc <> 0.

*   - DB update failed (Table name = &)
      lds_return-type       = 'E'.
      lds_return-id         = 'MEREP_SAMPLE_APPL1'.
      lds_return-number     = '002'.
      lds_return-message_v1 = 'MEREP_ADDRESS'.

      CALL FUNCTION 'MEREP_RETURN_GET'
        EXPORTING
          type   = lds_return-type
          id     = lds_return-id
          number = lds_return-number
          par1   = lds_return-message_v1
        IMPORTING
          return = lds_return.

      MOVE-CORRESPONDING lds_return TO return.

      ROLLBACK WORK.

      EXIT.
    ENDIF.

  ENDIF.

  IF NOT e_mail[] IS INITIAL.

    INSERT merep_e_mail FROM TABLE e_mail.

    IF sy-subrc <> 0.

*   - DB update failed (Table name = &, Key = &)
      lds_return-type       = 'E'.
      lds_return-id         = 'MEREP_SAMPLE_APPL1'.
      lds_return-number     = '002'.
      lds_return-message_v1 = 'MEREP_E_MAIL'.
      lds_return-message_v2 = person-persnumber.

      CALL FUNCTION 'MEREP_RETURN_GET'
        EXPORTING
          type   = lds_return-type
          id     = lds_return-id
          number = lds_return-number
          par1   = lds_return-message_v1
          par2   = lds_return-message_v2
        IMPORTING
          return = lds_return.

      MOVE-CORRESPONDING lds_return TO return.

      ROLLBACK WORK.

      EXIT.
    ENDIF.

  ENDIF.

  COMMIT WORK.

* - Person changed successfully (Persnumber=&)
  lds_return-type       = 'S'.
  lds_return-id         = 'MEREP_SAMPLE_APPL1'.
  lds_return-number     = '006'.
  lds_return-message_v1 = person-persnumber.

  CALL FUNCTION 'MEREP_RETURN_GET'
    EXPORTING
      type   = lds_return-type
      id     = lds_return-id
      number = lds_return-number
      par1   = lds_return-message_v1
    IMPORTING
      return = lds_return.

  MOVE-CORRESPONDING lds_return TO return.

ENDFUNCTION.
