FUNCTION merep_contact_getdetail.
*"----------------------------------------------------------------------
*"*"Local interface:
*"  IMPORTING
*"     VALUE(PERSNUMBER) LIKE  MEREP_PERSON-PERSNUMBER
*"  EXPORTING
*"     VALUE(PERSON) LIKE  MEREP_PERSON STRUCTURE  MEREP_PERSON
*"     VALUE(RETURN) LIKE  BAPIRET2 STRUCTURE  BAPIRET2
*"  TABLES
*"      ADDRESS STRUCTURE  MEREP_ADDRESS
*"      E_MAIL STRUCTURE  MEREP_E_MAIL
*"----------------------------------------------------------------------

  DATA:
   lds_return                LIKE bapireturn1.

  CLEAR return.

  SELECT SINGLE *
                   FROM      merep_person
                   INTO      person
                   WHERE     persnumber = persnumber.

  IF sy-subrc <> 0.

*   - Person not found (Persnumber = &)
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '005'.
    lds_return-message_v1 = persnumber.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
        par1   = lds_return-message_v1
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  SELECT *
                   FROM      merep_address
                   INTO TABLE
                             address
                   WHERE     persnumber = persnumber.

  SELECT *
                   FROM      merep_e_mail
                   INTO TABLE
                             e_mail
                   WHERE     persnumber = persnumber.

ENDFUNCTION.
