FUNCTION merep_contact_create.
*"----------------------------------------------------------------------
*"*"Local interface:
*"  IMPORTING
*"     VALUE(PERSON) LIKE  MEREP_PERSON STRUCTURE  MEREP_PERSON
*"  EXPORTING
*"     VALUE(PERSNUMBER) LIKE  MEREP_PERSON-PERSNUMBER
*"     VALUE(RETURN) LIKE  BAPIRET2 STRUCTURE  BAPIRET2
*"  TABLES
*"      ADDRESS STRUCTURE  MEREP_ADDRESS
*"      E_MAIL STRUCTURE  MEREP_E_MAIL
*"----------------------------------------------------------------------

  DATA:
     ldf_persnumber            LIKE merep_person-persnumber,
     lds_address               LIKE merep_address,
     lds_e_mail                LIKE merep_e_mail,
     lds_return                LIKE bapireturn1.

  CLEAR return.

  IF person-last_name IS INITIAL.

*   - Last name is mandatory
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '004'.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  CALL FUNCTION 'NUMBER_GET_NEXT'
    EXPORTING
      nr_range_nr             = '00'
      object                  = 'MEREP_PERS'
    IMPORTING
      number                  = ldf_persnumber
    EXCEPTIONS
      interval_not_found      = 1
      number_range_not_intern = 2
      object_not_found        = 3
      quantity_is_0           = 4
      quantity_is_not_1       = 5
      interval_overflow       = 6
      OTHERS                  = 7.

  IF sy-subrc = 0.

  ELSE.

*   - Could not get next number (RC=&)
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '001'.
    lds_return-message_v1 = sy-subrc.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
        par1   = lds_return-message_v1
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  persnumber = ldf_persnumber.

  person-persnumber = persnumber.
  person-credat = sy-datum.
  person-crenam = sy-uname.
  person-cretim = sy-uzeit.
  person-chgdat = sy-datum.
  person-chgnam = sy-uname.
  person-chgtim = sy-uzeit.

  LOOP AT address INTO lds_address.

    lds_address-persnumber = persnumber.
    MODIFY address FROM lds_address.

  ENDLOOP.

  LOOP AT e_mail INTO lds_e_mail.

    lds_e_mail-persnumber = persnumber.
    MODIFY e_mail FROM lds_e_mail.

  ENDLOOP.

  INSERT merep_person FROM person.

  IF sy-subrc <> 0.

*   - DB update failed (Table name=&, Persnumber=&)
    lds_return-type       = 'E'.
    lds_return-id         = 'MEREP_SAMPLE_APPL1'.
    lds_return-number     = '002'.
    lds_return-message_v1 = 'MEREP_PERSON'.
    lds_return-message_v2 = ldf_persnumber.

    CALL FUNCTION 'MEREP_RETURN_GET'
      EXPORTING
        type   = lds_return-type
        id     = lds_return-id
        number = lds_return-number
        par1   = lds_return-message_v1
        par2   = lds_return-message_v2
      IMPORTING
        return = lds_return.

    MOVE-CORRESPONDING lds_return TO return.

    EXIT.

  ENDIF.

  IF NOT address[] IS INITIAL.

    INSERT merep_address FROM TABLE address.

    IF sy-subrc <> 0.

*     - DB update failed (Table name=&, Persnumber=&)
      lds_return-type       = 'E'.
      lds_return-id         = 'MEREP_SAMPLE_APPL1'.
      lds_return-number     = '002'.
      lds_return-message_v1 = 'MEREP_ADDRESS'.
      lds_return-message_v2 = ldf_persnumber.

      CALL FUNCTION 'MEREP_RETURN_GET'
        EXPORTING
          type   = lds_return-type
          id     = lds_return-id
          number = lds_return-number
          par1   = lds_return-message_v1
          par2   = lds_return-message_v2
        IMPORTING
          return = lds_return.

      MOVE-CORRESPONDING lds_return TO return.

      ROLLBACK WORK.

      EXIT.

    ENDIF.

  ENDIF.

  IF NOT e_mail[] IS INITIAL.

    INSERT merep_e_mail FROM TABLE e_mail.

    IF sy-subrc <> 0.

*     - DB update failed (Table name=&, Persnumber=&)
      lds_return-type       = 'E'.
      lds_return-id         = 'MEREP_SAMPLE_APPL1'.
      lds_return-number     = '002'.
      lds_return-message_v1 = 'MEREP_E_MAIL'.
      lds_return-message_v2 = ldf_persnumber.

      CALL FUNCTION 'MEREP_RETURN_GET'
        EXPORTING
          type   = lds_return-type
          id     = lds_return-id
          number = lds_return-number
          par1   = lds_return-message_v1
          par2   = lds_return-message_v2
        IMPORTING
          return = lds_return.

      MOVE-CORRESPONDING lds_return TO return.

      ROLLBACK WORK.

      EXIT.

    ENDIF.

  ENDIF.

  COMMIT WORK.

* - Person created successfully (Persnumber=&)
  lds_return-type       = 'S'.
  lds_return-id         = 'MEREP_SAMPLE_APPL1'.
  lds_return-number     = '003'.
  lds_return-message_v1 = ldf_persnumber.

  CALL FUNCTION 'MEREP_RETURN_GET'
    EXPORTING
      type   = lds_return-type
      id     = lds_return-id
      number = lds_return-number
      par1   = lds_return-message_v1
    IMPORTING
      return = lds_return.

  MOVE-CORRESPONDING lds_return TO return.

ENDFUNCTION.
