public class MyOutDeltaOberver implements SyncBoOutDeltaObserver {

	public SyncBoDescriptor[] observeSyncBoTypes() {

		SyncBoDescriptorIterator itr = SmartSyncRuntime.getInstance().getSyncBoDescriptorFacade().getAllSyncBoDescriptors();

		Vector syncBos = new Vector();
		while (itr.hasNext()) {
			syncBos.addElement(itr.next());
		}

		SyncBoDescriptor[] syncBoArray = new SyncBoDescriptor[syncBos.size()];
		for (int i = 0; i < syncBos.size(); i++) {
			syncBoArray[i] = (SyncBoDescriptor) syncBos.elementAt(i);
		}

		return syncBoArray;
	}

	public void sendingSyncBoOutDelta(SyncBoOutDelta syncBoOutDelta) {
		System.out.println(syncBoOutDelta.toString());

		// send all the out data using synchronous mode
		syncBoOutDelta.setSendType(SyncBoOutDeltaSendType.SEND_DIRECT);
	}

}

public class MyMessageHandler implements MessageReplyObserver {

	public MessageReplyType[] observeMessageReplyTypes() {
		MessageReplyType[] reply = new MessageReplyType[2];
		reply[0] = MessageReplyType.SYNC_BEGIN;
		reply[1] = MessageReplyType.SYNC_END;
		return reply;
	}

	public void messageReplyReceived(MessageReply messageReply) {
		if (messageReply.getType() == MessageReplyType.SYNC_BEGIN) {
			// do pre-synchronization task here
			MeIterator itr = SmartSyncRuntime.getInstance().getSyncBoDeltaRequestFacade(VisibilityType.SEPARATED).getAllSyncBoDeltaRequests();
			while (itr.hasNext()) {
				SyncBoDeltaRequest request = (SyncBoDeltaRequest) itr.next();
				if (request.getSyncBoDescriptor().getSyncProcessing() != SyncProcessingType.UPLOAD) {
					request.setProcessing(SyncBoDeltaRequestType.DIRECT_REQUEST);
				}
			}
		} else if (messageReply.getType() == MessageReplyType.SYNC_END) {
			// do post-synchronization task here
		}
	}
}
