    //Create the query: search for top row C field of testIndex + it's corresponding child row
    SmartSyncJQueryFactory queryFactory = smartsyncRuntime.getJQueryFactory();
    JQueryAttribute attributeTopKey = queryFactory.createAttribute(topKeyFieldDesc002);
    JQueryAttribute attributeChildKey = queryFactory.createAttribute(c10KeyFieldDesc002);
    JQueryAttribute attributeTopC = queryFactory.createAttribute(topCFieldDesc002);
    JQueryCondition linkCondition = queryFactory.createLinkCondition(topRowDesc002, c10RowDesc002);
    JQueryCondition simpleCondition = queryFactory.createCondition
                                      (attributeTopC, RelationalOperatorType.EQUALS, testFieldValue+testIndex);
    JQueryCondition compositeCondition = queryFactory.createCondition
                                         (new JQueryCondition[]{linkCondition, simpleCondition},
                                         LogicalOperatorType.AND);
    JQuery query = queryFactory.createQuery
                   (new JQueryAttribute[]{attributeTopKey, attributeChildKey, attributeTopC},
                   compositeCondition);

    //Start the query
    txManager.beginTransaction();
    JQueryResult queryResult = dataFacade.executeQuery(query);//this will not create objects
    try{
         for(MeIterator queryIt = queryResult.iterator(); queryIt.hasNext(); ){
         //This will create objects: lazy loading
            JQueryResultRow resultRow = (JQueryResultRow) queryIt.next();
            String selectedTopKeyValue = (String) resultRow.get(attributeTopKey);
            String selectedChildKeyValue = (String) resultRow.get(attributeChildKey);
            String selectedTopCValue = (String) resultRow.get(attributeTopC);
         }
    }
    finally{
         queryResult.release();
         txManager.commit();
    }
