    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 1: Very Slow (ME 2.1 Data types");
    //	This approach is very slow, as:
    //	- every single setFieldValue invocation leads to an update of the entire table row
    //	- every update of the table row leads to a commit, as no explicit transaction boundaries have been set
    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.setFieldValue(this.topCFieldDescriptor, C_VALUE_21);
    topRow.setFieldValue(this.topNFieldDescriptor, N_VALUE_21);
    topRow.setFieldValue(this.topDFieldDescriptor, D_VALUE_21);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsString);
    childRow.setFieldValue(this.c10CFieldDescriptor, C_VALUE_21);
    childRow.setFieldValue(this.c10NFieldDescriptor, N_VALUE_21);
    childRow.setFieldValue(this.c10DFieldDescriptor, D_VALUE_21);

    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 2: Slow (ME 2.1 Data types)");
    //	This approach is slow, as:
    //	- every single setFieldValue invocation leads to an update of the entire table row
    //	It is however faster than the previous approach, as:
    //	- explicit transaction boundaries have been set and therefore only one final commit is being invokated
    transactionManager.beginTransaction();

    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.setFieldValue(this.topCFieldDescriptor, C_VALUE_21);
    topRow.setFieldValue(this.topNFieldDescriptor, N_VALUE_21);
    topRow.setFieldValue(this.topDFieldDescriptor, D_VALUE_21);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsString);
    childRow.setFieldValue(this.c10CFieldDescriptor, C_VALUE_21);
    childRow.setFieldValue(this.c10NFieldDescriptor, N_VALUE_21);
    childRow.setFieldValue(this.c10DFieldDescriptor, D_VALUE_21);

    transactionManager.commit();
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 3: Fast (ME 2.1 Data types)");
    //	This approach faster than the previous approach, as:
    //	- modifyFieldValue invocations do not lead directly to an update of the entire table row; instead this only happens once per row, after explicitly invoking modifyRow
    //	It is however not optimal, as:
    //	- every update of the table row leads to a commit, as no explicit transaction boundaries have been set
    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.modifyFieldValue(this.topCFieldDescriptor, C_VALUE_21);
    topRow.modifyFieldValue(this.topNFieldDescriptor, N_VALUE_21);
    topRow.modifyFieldValue(this.topDFieldDescriptor, D_VALUE_21);
    syncBo.modifyRow(topRow);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsString);
    childRow.modifyFieldValue(this.c10CFieldDescriptor, C_VALUE_21);
    childRow.modifyFieldValue(this.c10NFieldDescriptor, N_VALUE_21);
    childRow.modifyFieldValue(this.c10DFieldDescriptor, D_VALUE_21);
    syncBo.modifyRow(childRow);
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 4: Best way (ME 2.1 Data types)");
    //	This approach is the fastest possible approach with 2.1 data types, as:
    //	- modifyFieldValue invocations do not lead directly to an update of the entire table row; instead this only  
    //  happens once per row, after explicitly invoking modifyRow
    //	- explicit transaction boundaries have been set and therefore only one final commit is being invokated
    transactionManager.beginTransaction();

    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.modifyFieldValue(this.topCFieldDescriptor, C_VALUE_21);
    topRow.modifyFieldValue(this.topNFieldDescriptor, N_VALUE_21);
    topRow.modifyFieldValue(this.topDFieldDescriptor, D_VALUE_21);
    syncBo.modifyRow(topRow);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsString);
    childRow.modifyFieldValue(this.c10CFieldDescriptor, C_VALUE_21);
    childRow.modifyFieldValue(this.c10NFieldDescriptor, N_VALUE_21);
    childRow.modifyFieldValue(this.c10DFieldDescriptor, D_VALUE_21);
    syncBo.modifyRow(childRow);

    transactionManager.commit();
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 5: Very slow (MI 2.5 data types)");
    //	This approach is very slow, as:
    //	- every single setFieldValue invocation leads to an update of the entire table row
    //	- every update of the table row leads to a commit, as no explicit transaction boundaries have been set
    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();
    topRow.getField(this.topCFieldDescriptor).setValue(C_VALUE_25);
    topRow.getField(this.topNFieldDescriptor).setValue(N_VALUE_25);
    topRow.getField(this.topDFieldDescriptor).setValue(D_VALUE_25);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsBigInteger);
    childRow.getField(this.c10CFieldDescriptor).setValue(C_VALUE_25);
    childRow.getField(this.c10NFieldDescriptor).setValue(N_VALUE_25);
    childRow.getField(this.c10DFieldDescriptor).setValue(D_VALUE_25);
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 6: Slow (MI 2.5 data types)");
    //	This approach is slow, as:
    //	- every single setFieldValue invocation leads to an update of the entire table row
    //	It is however faster than the previous approach, as:
    //	- explicit transaction boundaries have been set and therefore only one final commit is being invokated
    transactionManager.beginTransaction();

    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.getField(this.topCFieldDescriptor).setValue(C_VALUE_25);
    topRow.getField(this.topNFieldDescriptor).setValue(N_VALUE_25);
    topRow.getField(this.topDFieldDescriptor).setValue(D_VALUE_25);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsBigInteger);
    childRow.getField(this.c10CFieldDescriptor).setValue(C_VALUE_25);
    childRow.getField(this.c10NFieldDescriptor).setValue(N_VALUE_25);
    childRow.getField(this.c10DFieldDescriptor).setValue(D_VALUE_25);
    childRow.getField(this.c10DFieldDescriptor).setValue(D_VALUE_25);

    transactionManager.commit();
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 7: Fast (MI 2.5 data types)");
    //	This approach faster than the previous approach, as:
    //	- modifyFieldValue invocations do not lead directly to an update of the entire table row; instead this only  
    //  happens once per row, after explicitly invoking modifyRow
    //	It is however not optimal, as:
    //	- every update of the table row leads to a commit, as no explicit transaction boundaries have been set
    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.getField(this.topCFieldDescriptor).modifyValue(C_VALUE_25);
    topRow.getField(this.topNFieldDescriptor).modifyValue(N_VALUE_25);
    topRow.getField(this.topDFieldDescriptor).modifyValue(D_VALUE_25);
    syncBo.modifyRow(topRow);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsBigInteger);
    childRow.getField(this.c10CFieldDescriptor).modifyValue(C_VALUE_25);
    childRow.getField(this.c10NFieldDescriptor).modifyValue(N_VALUE_25);
    childRow.getField(this.c10DFieldDescriptor).modifyValue(D_VALUE_25);
    syncBo.modifyRow(childRow);
    //	--------------------------------------------------------------
    //	--------------------------------------------------------------
    System.out.println("Approach 8: Best way (MI 2.5 data types)");
    //	This approach is the fastest possible approach with 2.1 data types, as:
    //	- modifyFieldValue invocations do not lead directly to an update of the entire table row; instead this only  
    //  happens once per row, after explicitly invoking modifyRow
    //	- explicit transaction boundaries have been set and therefore only one final commit is being invokated
    transactionManager.beginTransaction();
    syncBo = this.dataFacade.getSyncBo(syncBoDescriptor, topRowKeyAsString);
    topRow = syncBo.getTopRow();

    topRow.getField(this.topCFieldDescriptor).modifyValue(C_VALUE_25);
    topRow.getField(this.topNFieldDescriptor).modifyValue(N_VALUE_25);
    topRow.getField(this.topDFieldDescriptor).modifyValue(D_VALUE_25);
    syncBo.modifyRow(topRow);

    childRow = syncBo.getRow(this.c10RowDescriptor, childRowKeyAsBigInteger);
    childRow.getField(this.c10CFieldDescriptor).modifyValue(C_VALUE_25);
    childRow.getField(this.c10NFieldDescriptor).modifyValue(N_VALUE_25);
    childRow.getField(this.c10DFieldDescriptor).modifyValue(D_VALUE_25);
    syncBo.modifyRow(childRow);

    transactionManager.commit();

