FUNCTION susr_user_address_read.
*"----------------------------------------------------------------------
*"*"Lokale Schnittstelle:
*"  IMPORTING
*"     VALUE(USER_NAME) LIKE  USR01-BNAME
*"     VALUE(READ_DB_DIRECTLY) LIKE  SZAD_FIELD-FLAG DEFAULT SPACE
*"  EXPORTING
*"     VALUE(USER_ADDRESS) LIKE  ADDR3_VAL STRUCTURE  ADDR3_VAL
*"     VALUE(USER_USR03) LIKE  USR03 STRUCTURE  USR03
*"  EXCEPTIONS
*"      USER_ADDRESS_NOT_FOUND
*"----------------------------------------------------------------------
* TABLES: USR03, USR21, TSAD3T, ADCP."USR0340A                   "*367d
*--- "*509d+
*  DATA: nametext(75).
*  DATA: status_table LIKE adrstatus OCCURS 0 WITH HEADER LINE.
*  DATA: read_cam LIKE szad_field-flag.
*--- "*509d-
  DATA: addr_sel LIKE addr3_sel.
  DATA: addr_val LIKE addr3_val.
*  DATA: RC LIKE SZAD_FIELD-RETURNCODE.                          "*367d
*------- "*367i+
  DATA: v_addr_usr_wa LIKE v_addr_usr.
  DATA: save_subrc LIKE sy-subrc.
  DATA: save_tabix LIKE sy-tabix.
*------- "*367i-

  CLEAR usr21.
  CLEAR usr03.                         "USR0340A
*----------- "*467d+
*  CLEAR tsad3t.
*  CLEAR adcp.                          "*227i
*----------- "*467d-

  IF user_name = space.                "*263i
    MESSAGE e824 RAISING user_address_not_found.                 "*263i
  ENDIF.                               "*263i

*------- "*509d+
*  read_cam = space.
*  REFRESH status_table.
*  CALL FUNCTION 'ADDR_GET_STATUS_INFO'
*       TABLES
*            status_table = status_table
*       EXCEPTIONS
*            OTHERS       = 0.
*  LOOP AT status_table.
*    IF status_table-constant = 'BC01' AND status_table-value = 'X'.
*      read_cam = 'X'.
*      EXIT.
*    ENDIF.
*  ENDLOOP.
*  IF read_cam = 'X'.
*------- "*509d-
    IF user_name <> g_last_user_name.  "*227i
      SELECT SINGLE * FROM usr21 WHERE bname = user_name.
      IF sy-subrc <> 0.
        CLEAR g_last_usr21.            "*227i
        g_last_user_name = user_name.  "*227i
        MESSAGE e289 WITH user_name RAISING user_address_not_found.
      ENDIF.
      g_last_usr21 = usr21.            "*227i
    ELSE.                              "*227i
      IF NOT g_last_usr21 IS INITIAL.  "*227i
        usr21 = g_last_usr21.          "*227i
      ELSE.                            "*227i
        MESSAGE e289 WITH user_name    "*227i
                     RAISING user_address_not_found.             "*227i
      ENDIF.                           "*227i
    ENDIF.                             "*227i

    IF usr21-persnumber <> space
       AND usr21-addrnumber <> space.
      addr_sel-persnumber = usr21-persnumber.
      addr_sel-addrnumber = usr21-addrnumber.
      addr_sel-date       = '00010101'.
    ELSE.
      MESSAGE e289 WITH user_name RAISING user_address_not_found.
    ENDIF.
*----------- "*367i+
*   check in buffer if update is active
    IF g_update_active IS INITIAL.
*----------- "*367i-
      DATA: ev_upginfo LIKE uvers.
      CALL FUNCTION 'UPG_GET_ACTIVE_COMP_UPGRADE'
          EXPORTING
*             IV_COMPONENT           = 'SAP_BASIS'
               iv_upgtype             = 'A'
               iv_buffered            = 'X'
           IMPORTING
                ev_upginfo             = ev_upginfo
           EXCEPTIONS
                no_upgrade_active      = 1
                ambigious_entries      = 2
                invalid_component_name = 3
                OTHERS                 = 4.
      IF sy-subrc = 1
         OR ( sy-subrc = 0 AND ev_upginfo-putstatus <> 'B'
              AND ev_upginfo-putstatus <> 'S' ).
*-------------------------------------------------------------- "*367i+
        g_update_active = c_n.
      ELSE.
        g_update_active = c_y.
      ENDIF.
    ENDIF.
    IF g_update_active = c_n.
*-------------------------------------------------------------- "*367i-
      IF read_db_directly = 'X'.
*     nur Feld department mit direktem SELECT auf ADCP bestimmen
*     (Sonderlocke  - nur fr RDDIMPDP auerhalb des Upgrades)
        IF user_name <> g_last_user_name.                        "*227i
          SELECT * FROM adcp WHERE addrnumber =  usr21-addrnumber
                             AND persnumber =  usr21-persnumber
                             AND nation     =  space.
          ENDSELECT.
          IF sy-subrc = 0.
            g_last_adcp = adcp.        "*227i
          ELSE.
            CLEAR g_last_adcp.         "*227i
            g_last_user_name = user_name.                        "*227i
            MESSAGE e289 WITH user_name RAISING user_address_not_found.
          ENDIF.
        ELSE.                          "*227i
          IF NOT g_last_adcp IS INITIAL.                         "*227i
            adcp = g_last_adcp.        "*227i
          ELSE.                        "*227i
            MESSAGE e289 WITH user_name"*227i
                         RAISING user_address_not_found.         "*227i
          ENDIF.                       "*227i
        ENDIF.                         "*227i
        user_address-department = adcp-department.
        user_usr03-abtlg        = adcp-department.
      ELSE.
*     Normales Nachlesen, falls nicht im Austausch-Upgrade (Downtime
*     oder Phase PCON)
*------------------------------ "*367d+
*        CALL FUNCTION 'ADDR_PERS_COMP_GET'
*             EXPORTING
*                  ADDRESS_PERS_IN_COMP_SELECTION = ADDR_SEL
*             IMPORTING
*                  ADDRESS_PERS_IN_COMP_VALUE     = ADDR_VAL
*                  RETURNCODE                     = RC
*             EXCEPTIONS
*                  OTHERS                         = 1.
*        IF SY-SUBRC <> 0 OR RC = 'E'.
*------------------------------ "*367d-
*------------------------------------- "*367i+
*       first read in buffer (if nothing is found at least save
*       index for insert)
        READ TABLE g_user_data WITH KEY user = user_name
          BINARY SEARCH.
        save_subrc = sy-subrc.
        save_tabix = sy-tabix.
        IF save_subrc <> 0.
*         read in database if data not found in buffer
          SELECT SINGLE * FROM v_addr_usr INTO v_addr_usr_wa
            WHERE addrnumber = addr_sel-addrnumber
              AND persnumber = addr_sel-persnumber
              AND date_from  = addr_sel-date
              AND nation     = addr_sel-nation.
*             and DATE_FR_C  = ADDR_SEL-DATE
*             and NATION_C   = ADDR_SEL-NATION
*             and DATE_FR_P  = ADDR_SEL-DATE.
          IF sy-subrc <> 0.
*------------------------------------- "*367i-
            MESSAGE e289 WITH user_name RAISING user_address_not_found.
          ENDIF.                       "*367i
        ELSE.
*-------------------------"*367i+
          v_addr_usr_wa = g_user_data-data.
        ENDIF.
        MOVE-CORRESPONDING v_addr_usr_wa TO addr_val.
        g_user_data-user = user_name.
        g_user_data-data = v_addr_usr_wa.
*       insert buffer
        CASE save_subrc.
          WHEN 0.
*           MODIFY g_user_data INDEX save_tabix. "not necessary
          WHEN OTHERS.
            INSERT g_user_data INDEX save_tabix.
        ENDCASE.
        addr_val-date = addr_sel-date.
*-------------------------"*367i-
        user_address = addr_val.
        IF user_usr03 IS REQUESTED.    "*369i
*         Felder auf USR03 mappen
          user_usr03-mandt = sy-mandt. "USR0340A
          user_usr03-bname = user_name."USR0340A
          IF addr_val-converted = 'X'.
            user_usr03-name1 = addr_val-name_text."USR0340A
          ELSE.
            user_usr03-name1 = addr_val-name_first."USR0340A
            user_usr03-name2 = addr_val-name_last."USR0340A
          ENDIF.
          user_usr03-name3 = addr_val-name1."USR0340A
          user_usr03-name4 = addr_val-name2."USR0340A
          SELECT SINGLE * FROM tsad3t WHERE langu = sy-langu
                                        AND title = addr_val-title_p.
          IF sy-subrc = 0.
            user_usr03-salut = tsad3t-title_medi."USR0340A
          ELSE.
*            CLEAR tsad3t.     "*467d
            CLEAR user_usr03-salut.    "*467i
          ENDIF.
          user_usr03-abtlg = addr_val-department."USR0340A
          user_usr03-kostl = usr21-kostl."USR0340A
          user_usr03-buinr = addr_val-building_c."USR0340A
          user_usr03-roonr = addr_val-roomnum_c."USR0340A
*------------ "*369i+
          IF NOT addr_val-house_num1 IS INITIAL OR
             NOT addr_val-house_num2 IS INITIAL.
            CALL FUNCTION 'ADDR_COMPOSE_STREET_LINE'
                 EXPORTING
                      street             = addr_val-street
                      house_number       = addr_val-house_num1
                      house_number2      = addr_val-house_num2
                      length             = 30
*                   RULE               =
*                   ADDRESS_LAYOUT_KEY =
                      country            = addr_val-country
                      language           = addr_val-langu
                 IMPORTING
                      street_line        = user_usr03-stras
                      .
          ELSE.
*------------ "*369i-
            user_usr03-stras = addr_val-street."USR0340A
          ENDIF.                       "*369i
          user_usr03-pfach = addr_val-po_box."USR0340A
          user_usr03-pstlz = addr_val-post_code1."USR0340A
          user_usr03-ort01 = addr_val-city1."USR0340A
          user_usr03-regio = addr_val-region."USR0340A
          user_usr03-land1 = addr_val-country."USR0340A
          IF addr_val-langu_p IS INITIAL. "*509i
            user_usr03-spras = addr_val-langu."USR0340A
*-------- "*509i+
          ELSE.
            user_usr03-spras = addr_val-langu_p."USR0340A
          ENDIF.
*-------- "*509i-
*         USER_USR03-TELPR = ADDR_VAL-???
          CONCATENATE addr_val-tel_number addr_val-tel_extens
                   INTO user_usr03-telnr."USR0340A
*         USER_USR03-TEL01 = ADDR_VAL-???
*         USER_USR03-TEL02 = ADDR_VAL-???
*         USER_USR03-TELX1 = ADDR_VAL-???
          CONCATENATE addr_val-fax_number addr_val-fax_extens
                   INTO user_usr03-telfx."USR0340A
*         USER_USR03-TELTX = ADDR_VAL-???
          user_usr03-ort02 = addr_val-city2."USR0340A
          user_usr03-pstl2 = addr_val-post_code2."USR0340A
          user_usr03-tzone = addr_val-time_zone."USR0340A
        ENDIF.                         "*369i
      ENDIF.
*      ENDIF.                                                    "*367d
    ELSE.
*     Sonderbehandlung fr den Austausch-Upgrade
      user_address-name_last  = user_name.
      user_address-name_text  = user_name.
      user_address-addrnumber = usr21-addrnumber.
      user_address-persnumber = usr21-persnumber.
      user_usr03-mandt = sy-mandt.     "USR0340A
      user_usr03-bname = user_name.    "USR0340A
      user_usr03-name2 = user_name.

    ENDIF.   " if sy-subrc <> 1 (vom FB upg_get_active_comp_upgrade)
*---- "*509d+
*  ELSE.
*    SELECT SINGLE * FROM usr03 WHERE bname = user_name."USR0340A
*    IF sy-subrc <> 0.
*      MESSAGE e289 WITH user_name RAISING user_address_not_found.
*    ENDIF.
*    MOVE usr03 TO user_usr03.          "USR0340A
*
** Folgende Felder aus der USR03 werden in Zukunft nicht mehr
** untersttzt (Information in Mail an Anwender aufnehmen):
** KOSTL  Kostenstelle   (doch -> steht in USR21)
*
** Folgende Felder sind in Zukunft ber andere Adre-FBs zu besorgen:
** TEL01  Telefonnummer
** TEL02  Telefonnummer
** TELX1  Telexnnummer
** TELTX  Teletexnummer
** TZONE  Zeitzone   (ggf. als abweichende Zeitzone)
*
** Folgende Felder aus der USR03 sind in Zukunft Bestandteil der
** Firmenadresse:
** STRAS
** PFACH
** PSTLZ
** PSTL2
** ORT01
** ORT02
** REGIO
** LAND1
** NAME3
** NAME4
** TZONE
*
** Folgende Felder aus USR03 konnten auch bisher nicht gepflegt werden:
** TELPR  Telefonnummer (privat)
*
** Anrede  -> wird mglichst gut umgesetzt, ist dann als Schlssel oder
**            ggf. als Teil von NAMETEXT vorhanden.
*    user_address-name_first = usr03-name1."USR0340A
*    user_address-name_last  = usr03-name2."USR0340A
*    user_address-department = usr03-abtlg."USR0340A
*    user_address-building_c = usr03-buinr."USR0340A
*    user_address-roomnum_c  = usr03-roonr."USR0340A
*    user_address-name1      = usr03-name3."USR0340A
*    user_address-name2      = usr03-name4."USR0340A
*    user_address-street     = usr03-stras."USR0340A
*    user_address-po_box     = usr03-pfach."USR0340A
*    user_address-post_code1 = usr03-pstlz."USR0340A
*    user_address-post_code2 = usr03-pstl2."USR0340A
*    user_address-city1      = usr03-ort01."USR0340A
*    user_address-city2      = usr03-ort02."USR0340A
*    user_address-region     = usr03-regio."USR0340A
*    user_address-country    = usr03-land1."USR0340A
*    user_address-langu_p    = usr03-spras."USR0340A
*    user_address-tel_number = usr03-telnr."USR0340A
*    user_address-fax_number = usr03-telfx."USR0340A
*    user_address-time_zone  = usr03-tzone."USR0340A
*
*    nametext(15)    = usr03-salut.     "USR0340A
*    nametext+15(30) = usr03-name1.     "USR0340A
*    nametext+45(30) = usr03-name2.     "USR0340A
*    CONDENSE nametext.
*    user_address-name_text  = nametext.
*  ENDIF.
*---- "*509d-
  g_last_user_name = user_name.        "*227i
ENDFUNCTION.
