/*
 * Decompiled with CFR 0.152.
 */
package mdkInventory1.dataAccess;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.CharacterField;
import com.sap.ip.me.api.smartsync.DecimalField;
import com.sap.ip.me.api.smartsync.Field;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.NumericField;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.SmartSyncRuntime;
import com.sap.ip.me.api.smartsync.SmartSyncTransactionManager;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoDataFacade;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import mdkInventory1.Constants;
import mdkInventory1.GetProperties;

public class SmartSyncDBAccess
implements Constants {
    private String[] tableHeaderNamesToDisplay;
    private String[] tableHeaderNames;
    private int headerFieldCount;
    private static SyncBoDataFacade dataFacade;
    private static SyncBoDescriptorFacade descriptorFacade;

    public SmartSyncDBAccess() {
        dataFacade = SmartSyncRuntime.getInstance().getSyncBoDataFacade();
        descriptorFacade = SmartSyncRuntime.getInstance().getSyncBoDescriptorFacade();
    }

    public MeIterator getAllSyncBoInstances(String syncBoName) {
        try {
            SyncBoDescriptor sbd = descriptorFacade.getSyncBoDescriptor(syncBoName);
            return dataFacade.getSyncBos(sbd).iterator();
        }
        catch (PersistenceException pex) {
            System.out.println(pex.getMessage());
            return null;
        }
    }

    public MeIterator getRowInstances(String syncBoName, int start, int count, int sortIndex, boolean sortOrder, String filter) {
        try {
            SyncBoDescriptor sbd = descriptorFacade.getSyncBoDescriptor(syncBoName);
            MeIterator iteratorRows = null;
            SmartSyncQueryFactory queryFactory = SmartSyncRuntime.getInstance().getQueryFactory();
            RowDescriptor rd = sbd.getTopRowDescriptor();
            FieldDescriptor fd = rd.getFieldDescriptor(this.tableHeaderNames[sortIndex]);
            Condition cond = queryFactory.createCondition(fd, RelationalOperatorType.STARTS_WITH, (Object)filter);
            SortOrder singleSortOrder = queryFactory.createSortOrder(fd, sortOrder);
            Query rowQuery = queryFactory.createQuery(rd, cond, singleSortOrder, start, count);
            iteratorRows = dataFacade.getRows(rowQuery).iterator();
            return iteratorRows;
        }
        catch (PersistenceException pex) {
            System.out.println(pex.getMessage());
            return null;
        }
    }

    public SyncBo getSyncBoInstance(String syncBoName, String syncKey) {
        SyncBoDescriptor sbd = descriptorFacade.getSyncBoDescriptor(syncBoName);
        try {
            SyncBo sb = dataFacade.getSyncBo(sbd, syncKey);
            return sb;
        }
        catch (PersistenceException pex) {
            System.out.println(pex.getMessage());
            return null;
        }
    }

    public String[] getHeaderFieldNames(String syncBoName) {
        SyncBoDescriptor sbd = descriptorFacade.getSyncBoDescriptor(syncBoName);
        RowDescriptor trd = sbd.getTopRowDescriptor();
        String[] arrayFieldNames = new String[trd.getFieldCount()];
        this.tableHeaderNamesToDisplay = new String[trd.getFieldCount()];
        int i = 0;
        if (trd.getFieldCount() > 0) {
            FieldDescriptorIterator fdi = trd.getAllFieldDescriptors();
            while (fdi.hasNext()) {
                arrayFieldNames[i] = fdi.next().getFieldName();
                this.tableHeaderNamesToDisplay[i] = GetProperties.getString(arrayFieldNames[i]);
                ++i;
            }
            return arrayFieldNames;
        }
        System.out.println("SmartSyncDBAccess.getHeaderFieldNames - Array of Header Field Names is empty");
        return null;
    }

    public String getHeaderFieldValue(Row header, String headerFieldName) {
        RowDescriptor trd = header.getRowDescriptor();
        FieldDescriptor fd = trd.getFieldDescriptor(headerFieldName);
        if (fd != null) {
            BasisFieldType bft = fd.getFieldType();
            try {
                if (bft == BasisFieldType.N) {
                    NumericField nf = header.getNumericField(fd);
                    return nf.getValueWithLeadingZeros();
                }
                Field f = header.getField(fd);
                if (f == null || f.getValue() == null) {
                    return "";
                }
                return f.getValue().toString();
            }
            catch (SmartSyncException ssex) {
                System.out.println(ssex.getMessage());
                return null;
            }
        }
        return null;
    }

    public String getHeaderFieldValue(SyncBo sb, String headerFieldName) {
        SyncBoDescriptor sbd = sb.getSyncBoDescriptor();
        RowDescriptor trd = sbd.getTopRowDescriptor();
        FieldDescriptor fd = trd.getFieldDescriptor(headerFieldName);
        if (fd != null) {
            BasisFieldType bft = fd.getFieldType();
            Row header = sb.getTopRow();
            try {
                if (bft == BasisFieldType.N) {
                    NumericField nf = header.getNumericField(fd);
                    return nf.getValueWithLeadingZeros();
                }
                Field f = header.getField(fd);
                if (f == null || f.getValue() == null) {
                    return "";
                }
                return f.getValue().toString();
            }
            catch (SmartSyncException ssex) {
                System.out.println(ssex.getMessage());
                return null;
            }
        }
        return null;
    }

    public boolean setHeaderFieldValue(SyncBo sb, String headerFieldName, Object value) {
        SyncBoDescriptor sbd = sb.getSyncBoDescriptor();
        RowDescriptor trd = sbd.getTopRowDescriptor();
        FieldDescriptor fd = trd.getFieldDescriptor(headerFieldName);
        if (fd != null) {
            BasisFieldType bft = fd.getFieldType();
            Row header = sb.getTopRow();
            try {
                if (bft == BasisFieldType.N) {
                    NumericField nf = header.getNumericField(fd);
                    if (nf != null) {
                        BigInteger ii = new BigInteger(value.toString());
                        nf.setValue(ii);
                        return true;
                    }
                    return false;
                }
                if (bft == BasisFieldType.C) {
                    CharacterField cf = header.getCharacterField(fd);
                    if (cf != null) {
                        cf.setValue(value.toString());
                        return true;
                    }
                    return false;
                }
                if (bft == BasisFieldType.P) {
                    DecimalField df = header.getDecimalField(fd);
                    if (df != null) {
                        BigDecimal bd = new BigDecimal(value.toString());
                        df.setValue(bd);
                        return true;
                    }
                    return false;
                }
            }
            catch (SmartSyncException ex) {
                System.out.println(ex.getMessage());
            }
            catch (PersistenceException e) {
                System.out.println(e.getMessage());
            }
        }
        return false;
    }

    public String getItemFieldValue(Row item, String itemFieldName) {
        RowDescriptor rd = item.getRowDescriptor();
        FieldDescriptor fd = rd.getFieldDescriptor(itemFieldName);
        BasisFieldType bft = fd.getFieldType();
        try {
            if (bft == BasisFieldType.N) {
                NumericField nf = item.getNumericField(fd);
                return nf.getValueWithLeadingZeros();
            }
            Field f = item.getField(fd);
            if (f == null) {
                return "";
            }
            return f.getValue().toString();
        }
        catch (SmartSyncException ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public MeIterator readEntitiesFromDB(int start, int count, int sortIndex, boolean sort_ascending, String filter_string) {
        Vector lineVector = new Vector();
        this.tableHeaderNames = this.getHeaderFieldNames("YMDK_INVEN");
        this.setColumns(this.tableHeaderNames.length);
        return this.getRowInstances("YMDK_INVEN", start, count, sortIndex, sort_ascending, filter_string);
    }

    public int getNumberOfSyncBos() {
        int rows_in_dataset = 0;
        MeIterator syncBos = this.getAllSyncBoInstances("YMDK_INVEN");
        while (syncBos.hasNext()) {
            syncBos.next();
            ++rows_in_dataset;
        }
        return rows_in_dataset;
    }

    public Vector getEntities(MeIterator syncBos, int fromIndex, int count) {
        Vector retVec = new Vector();
        int i = 0;
        if (syncBos != null) {
            syncBos.reset();
            while (syncBos.hasNext()) {
                Row row = (Row)syncBos.next();
                if (i >= fromIndex) {
                    Vector<String> rowData = new Vector<String>();
                    int col = 0;
                    while (col < this.getColumns()) {
                        rowData.addElement(this.getHeaderFieldValue(row, this.tableHeaderNames[col]));
                        ++col;
                    }
                    retVec.addElement(rowData);
                }
                if (count <= 0 || ++i < fromIndex + count) continue;
                return retVec;
            }
        }
        return retVec;
    }

    public void modifyRowInDB(String syBName, String syncKey, String newValue, int col) throws SmartSyncException, PersistenceException {
        String syncBoName = syBName;
        if (syncBoName == null) {
            syncBoName = "YMDK_INVEN";
        }
        SyncBo syncBo = this.getSyncBoInstance(syncBoName, syncKey);
        SmartSyncTransactionManager transactionManager = dataFacade.getSmartSyncTransactionManager();
        transactionManager.beginTransaction();
        this.setHeaderFieldValue(syncBo, this.tableHeaderNames[col], newValue);
        transactionManager.commit();
    }

    public void addRowInDB(String syBName, String[] newValues) throws SmartSyncException, PersistenceException {
        String syncBoName = syBName;
        if (syncBoName == null) {
            syncBoName = "YMDK_INVEN";
        }
        SyncBoDescriptor sbd = descriptorFacade.getSyncBoDescriptor(syncBoName);
        SyncBo newsyncBo = dataFacade.createEmptySyncBo(sbd);
        SmartSyncTransactionManager transactionManager = dataFacade.getSmartSyncTransactionManager();
        transactionManager.beginTransaction();
        int i = 0;
        while (i < this.getColumns()) {
            if (newValues[i] != null) {
                this.setHeaderFieldValue(newsyncBo, this.tableHeaderNames[i], newValues[i]);
            }
            ++i;
        }
        dataFacade.insertSyncBo(newsyncBo);
        transactionManager.commit();
    }

    public int getColumns() {
        return this.headerFieldCount;
    }

    public void setColumns(int col) {
        this.headerFieldCount = col;
    }

    public String[] getTableHeaderNames() {
        return this.tableHeaderNamesToDisplay;
    }

    public void setTableHeaderNames(String[] strings) {
        this.tableHeaderNamesToDisplay = strings;
    }

    public String getTableHeaderName(int col) {
        return this.tableHeaderNamesToDisplay[col];
    }
}

