/*
 * Decompiled with CFR 0.152.
 */
package mdkInventory1.bean;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import java.util.Vector;
import mdkInventory1.Constants;
import mdkInventory1.dataAccess.SmartSyncDBAccess;

public class BasicDataHandler
implements Constants {
    private static int columns;
    private static Vector tableHeaderNamesToDisplay;
    private static MeIterator rows;
    private Vector retSubVec;
    private static BasicDataHandler bdh;
    private static SmartSyncDBAccess dbAccess;
    private static int start_index;
    private static int sort_index;
    private static boolean sort_ascending;
    private static int recCount;
    private int tablecolumns;
    private static String miHomeFolder;
    public static int rows_in_dataset;
    public static int tablerows;
    public static int current_index;

    public static BasicDataHandler instance(boolean refreshSyncBoCount, int start, int count, int sortIndex, boolean sort_type, String filter_string) {
        if (bdh == null) {
            bdh = new BasicDataHandler();
        }
        if (dbAccess == null) {
            dbAccess = new SmartSyncDBAccess();
        }
        if (refreshSyncBoCount) {
            rows_in_dataset = dbAccess.getNumberOfSyncBos();
        }
        rows = dbAccess.readEntitiesFromDB(start, count, sortIndex, sort_type, filter_string);
        BasicDataHandler.setColumns(dbAccess.getColumns());
        sort_ascending = sort_type;
        sort_index = sortIndex;
        return bdh;
    }

    public void getDataArray() {
        this.retSubVec = dbAccess.getEntities(rows, 0, -1);
    }

    public String getCurrentSubTableContent(int row, int column) {
        if (row >= this.retSubVec.size()) {
            return "";
        }
        Vector data = (Vector)this.retSubVec.elementAt(row);
        return data.elementAt(column).toString();
    }

    public void setMiHomeFolder(String string) {
        miHomeFolder = string;
    }

    public String getMiHomeFolder() {
        return miHomeFolder;
    }

    public String getTableHeaderName(int col) {
        return dbAccess.getTableHeaderName(col);
    }

    public int getColumns() {
        return columns;
    }

    public static void setColumns(int col) {
        columns = col;
    }

    public Vector getTableHeader() {
        return tableHeaderNamesToDisplay;
    }

    public void initTableHeader(int noFields) {
        tableHeaderNamesToDisplay = new Vector();
        int i = 0;
        while (i < noFields) {
            tableHeaderNamesToDisplay.addElement(" ");
            ++i;
        }
    }

    public void setTableHeader(Vector vector) {
        tableHeaderNamesToDisplay = vector;
    }

    public void setTableHeaderEntry(String entry, int col) {
        tableHeaderNamesToDisplay.setElementAt(entry, col);
    }

    public int getTableRows() {
        return tablerows;
    }

    public String getHeaderContent(int column) {
        if (tableHeaderNamesToDisplay.elementAt(column) == null) {
            return null;
        }
        String ret = tableHeaderNamesToDisplay.elementAt(column).toString();
        if (column == 1) {
            ret = "<a href=\"?event=productIdSort\" > <img src=\"" + this.getMimeProductIDFileName() + "\" border=\"0\">" + ret + "</a>";
        }
        return ret;
    }

    private String getMimeProductIDFileName() {
        String mime = "mimes/ascending.gif";
        if (!sort_ascending) {
            mime = "mimes/descending.gif";
        }
        return mime;
    }

    public void setTableRows(int i) {
        tablerows = i;
    }

    public int getTableColumns() {
        return this.tablecolumns;
    }

    public void setTableColumns(int col) {
        this.tablecolumns = col;
    }

    public void setRowsInDataset(int i) {
        rows_in_dataset = i;
    }

    public int getRowsInDataset() {
        return rows_in_dataset;
    }

    public int getCurrentIndex() {
        return current_index;
    }

    public void setCurrentIndex(int i) {
        current_index = i;
    }

    public boolean modifyEntry(String synckey, String newValue, int col) {
        boolean suc = true;
        try {
            dbAccess.modifyRowInDB(null, synckey, newValue, col);
        }
        catch (SmartSyncException e) {
            System.out.println((Object)e);
            suc = false;
        }
        catch (PersistenceException e) {
            System.out.println((Object)e);
            suc = false;
        }
        return suc;
    }

    public boolean addEntry(String[] newValues) {
        boolean suc = true;
        try {
            dbAccess.addRowInDB(null, newValues);
            ++rows_in_dataset;
        }
        catch (SmartSyncException e) {
            System.out.println((Object)e);
            suc = false;
        }
        catch (PersistenceException e) {
            System.out.println((Object)e);
            suc = false;
        }
        return suc;
    }

    static {
        bdh = null;
        dbAccess = null;
    }
}

