/*
 * Decompiled with CFR 0.152.
 */
package mdkInventory1;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.services.MEResourceBundle;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mdkInventory1.Constants;
import mdkInventory1.bean.BasicDataHandler;
import mdkInventory1.bean.TableViewDefinition;

public class ControllerServlet
extends AbstractMEHttpServlet
implements Constants {
    public static MEResourceBundle RESOURCE_BUNDLE;
    private TableViewDefinition tableViewDefinition;
    private BasicDataHandler dataHandler;
    private String headLine;
    private int start_index;
    private int sort_index;
    private boolean sort_ascending;
    private String buttontext;
    private String pageTitle;
    private String currentPageFooter;
    private String buttontextQuery;
    private String filter_string;
    private String current_filter_string;
    private Vector commandLine = new Vector();

    public String getApplicationName() {
        return "MDK_SMARTSYNC_INVENTORYJSP";
    }

    public void doInitialize() throws ServletException {
        this.setResourceBundle("mdkInventory1.properties.inventory");
        RESOURCE_BUNDLE = this.getResourceBundle();
        this.setFilterOff();
        ClassLoader cl = this.getClass().getClassLoader();
        AppLog aLogger = AppLog.getInstance((String)"MDK_SMARTSYNC_INVENTORYJSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
        this.setCommands();
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextJSP = "/jsp/menu.jsp";
        this.pageTitle = "Inventory Management";
        this.currentPageFooter = "menu.jsp";
        this.headLine = "I am a Mobile Infrastructure Client application using the Smart Sync API";
        nextJSP = "/jsp/menu.jsp";
        if (eventName.equals("productIdSort")) {
            this.sort_index = 1;
            this.sort_ascending = !this.sort_ascending;
        }
        if (eventName.equals("navGoTop")) {
            this.start_index = 0;
        }
        if (eventName.equals("navGoBottom")) {
            this.start_index = (this.dataHandler.getRowsInDataset() - 1) / 5 * 5;
        }
        if (eventName.equals("navGoPageup") && this.start_index >= 5) {
            this.start_index -= 5;
        }
        if (eventName.equals("navGoPagedown")) {
            this.start_index += 5;
        }
        if (eventName.startsWith("navGoToPage")) {
            String inputField = request.getParameter("GOTO_PAGE");
            int number = Integer.parseInt(inputField);
            this.setCurrenPage(number);
        }
        if (eventName.equals("addEntrySubmit")) {
            this.addEntry(request);
        }
        if (eventName.equals("querySubmit")) {
            nextJSP = this.setFilter(request);
        }
        boolean refreshSyncBoCount = false;
        if (eventName.trim().length() < 1) {
            refreshSyncBoCount = true;
        }
        this.getBeansFromContext(request, refreshSyncBoCount);
        if (eventName.equals("addEntry")) {
            this.pageTitle = "Add inventory item";
            this.currentPageFooter = "add.jsp";
            nextJSP = "/jsp/add.jsp";
        }
        if (eventName.equals("queryEntries")) {
            nextJSP = "/jsp/query.jsp";
        }
        if (eventName.equals("saveEntries")) {
            nextJSP = this.saveEntries(request);
        }
        if (eventName.equals("addEntryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("deleteEntrySubmit")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("queryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        this.loadBean();
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    private void setCurrenPage(int number) {
        this.start_index = (number - 1) * 5;
        int max_index = (this.dataHandler.getRowsInDataset() - 1) / 5 * 5;
        if (this.start_index > max_index) {
            this.start_index = max_index;
        }
        if (this.start_index < 0) {
            this.start_index = 0;
        }
    }

    private boolean getDetailPage(String eventName) {
        boolean detail = false;
        int i = 0;
        while (i < this.dataHandler.getTableRows()) {
            if (eventName.equals(this.dataHandler.getCurrentSubTableContent(i, 0))) {
                detail = true;
            }
            ++i;
        }
        return detail;
    }

    private String saveEntries(HttpServletRequest request) {
        String nextJSP = null;
        boolean valuesOK = true;
        int i = 0;
        while (i < this.dataHandler.getTableRows()) {
            String synckey;
            String inputFieldString = request.getParameter(this.dataHandler.getCurrentSubTableContent(i, 0));
            if (inputFieldString != null && (synckey = this.dataHandler.getCurrentSubTableContent(i, 0)).length() > 0) {
                String currentAmount = this.dataHandler.getCurrentSubTableContent(i, 5);
                int newAmount = 0;
                int oldAmount = 0;
                try {
                    newAmount = Integer.parseInt(inputFieldString);
                }
                catch (NumberFormatException e) {
                    valuesOK = false;
                }
                try {
                    oldAmount = Integer.parseInt(currentAmount);
                }
                catch (NumberFormatException e) {
                    oldAmount = 0;
                }
                if (oldAmount != newAmount && valuesOK) {
                    System.out.println("Save new value");
                    this.dataHandler.modifyEntry(synckey, inputFieldString, 5);
                }
            }
            ++i;
        }
        nextJSP = "/jsp/menu.jsp";
        if (!valuesOK) {
            nextJSP = "/jsp/savefailed.jsp";
        }
        return nextJSP;
    }

    private void addEntry(HttpServletRequest request) {
        String[] newValues = new String[this.dataHandler.getColumns()];
        int i = 0;
        while (i < this.dataHandler.getColumns()) {
            if (this.dataHandler.getTableHeaderName(i) != null) {
                newValues[i] = request.getParameter(this.dataHandler.getTableHeaderName(i));
            }
            if (i == 5) {
                newValues[i] = "0";
            }
            ++i;
        }
        this.dataHandler.addEntry(newValues);
    }

    private String setFilter(HttpServletRequest request) {
        this.filter_string = request.getParameter("PRODUCTID");
        if (this.filter_string.length() == 0) {
            this.setFilterOff();
        } else {
            this.setFilterOn(1, this.filter_string);
            this.setCurrenPage(1);
        }
        return "/jsp/menu.jsp";
    }

    private void getBeansFromContext(HttpServletRequest request, boolean refreshSyncBoCount) {
        this.tableViewDefinition = (TableViewDefinition)request.getSession().getAttribute("tableViewDefinition");
        if (this.tableViewDefinition == null) {
            this.tableViewDefinition = new TableViewDefinition();
        }
        this.dataHandler = BasicDataHandler.instance(refreshSyncBoCount, this.start_index, 5, this.sort_index, this.sort_ascending, this.filter_string);
    }

    public void loadBean() {
        this.tableViewDefinition.setHeaderPanelEntryLeft("<a href=\"http://127.0.0.1:4444/me\" > <img src=\"mimes/milogo.gif\" alt=\"MI Home\" ></a>");
        this.tableViewDefinition.setHeaderPanelEntryRight("MDK");
        this.setCommands();
        this.tableViewDefinition.setFooterPanelEntryLeft(this.current_filter_string);
        this.tableViewDefinition.setFooterPanelEntryRight(this.currentPageFooter);
        this.tableViewDefinition.setCommandLine(this.commandLine);
        this.tableViewDefinition.setCenterPageTitle(this.pageTitle);
        this.setTableHeader();
        this.dataHandler.getDataArray();
        this.dataHandler.setTableRows(5);
        this.dataHandler.setTableColumns(this.dataHandler.getColumns());
        this.dataHandler.setRowsInDataset(this.dataHandler.getRowsInDataset());
        this.dataHandler.setCurrentIndex(this.start_index);
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.tableViewDefinition == null) {
            request.getSession().removeAttribute("tableViewDefintion");
        } else {
            request.getSession().setAttribute("tableViewDefinition", (Object)this.tableViewDefinition);
        }
        if (this.dataHandler == null) {
            request.getSession().removeAttribute("dataHandler");
        } else {
            request.getSession().setAttribute("dataHandler", (Object)this.dataHandler);
        }
    }

    private void setFilterOff() {
        this.sort_index = 1;
        this.sort_ascending = true;
        this.buttontextQuery = "Set Filter";
        this.current_filter_string = "No Filter";
        this.filter_string = "";
    }

    private void setFilterOn(int index, String filter_string) {
        this.buttontextQuery = "Reset Filter";
        this.current_filter_string = "Filter: " + filter_string;
        this.sort_index = index;
    }

    private void setCommands() {
        this.commandLine.removeAllElements();
        this.commandLine.addElement("<input type=\"submit\" value=\"Add\" class=\"image\" name=\"_event_addEntry\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"" + this.buttontextQuery + "\" class=\"image\" name=\"_event_" + "queryEntries" + "\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"Save\" class=\"image\" name=\"_event_saveEntries\">");
    }

    private void setTableHeader() {
        int headercol = this.dataHandler.getColumns();
        this.dataHandler.initTableHeader(headercol);
        int i = 0;
        while (i < headercol) {
            this.dataHandler.setTableHeaderEntry(this.dataHandler.getTableHeaderName(i), i);
            ++i;
        }
    }
}

