/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample3.datafactory;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.QueryRuntime;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import java.util.Vector;
import persistenceexample3.Constants;
import persistenceexample3.datafactory.Car;
import persistenceexample3.datafactory.ExamplePackagePersistenceMaster;
import persistenceexample3.datafactory.License;

public class ReadWriteEntities
implements Constants {
    private static PersistenceRuntime persistence;
    private static PersistenceManager perManager;
    private static ExamplePackagePersistenceMaster master;
    private static int idCount;

    public static void setupPersistenceRuntime() {
        try {
            persistence = PersistenceRuntime.getInstance();
            master = new ExamplePackagePersistenceMaster();
            persistence.registerPersistenceMaster((PackagePersistenceMaster)master);
            perManager = persistence.getPersistenceManager(VisibilityType.SEPARATED);
            perManager.registerEntityFactory((EntityFactory)master);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error during startup");
            System.exit(-1);
        }
    }

    public static PersistableEntity createCarEntity(String name) {
        Car car = new Car(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_CAR, name));
        return car;
    }

    public static PersistableEntity createLicenseEntity(String number) {
        License license = new License(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_LICENSE, number));
        return license;
    }

    public static void combineCarLicense(PersistableEntity car, PersistableEntity license) {
        License l = (License)license;
        Car c = (Car)car;
        c.setLicense(l);
    }

    public static void setCarAttributes(PersistableEntity car, String make, String model, String engine, int cyl, int valves) {
        Car c = (Car)car;
        c.setValues(make, model, engine, cyl, valves);
    }

    public static void writeEntity(PersistableEntity obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                ReadWriteEntities.setupPersistenceRuntime();
                perManager.beginTransaction(false);
                perManager.update(obj, TreeOptionType.COMPLETE);
                perManager.commit();
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void addEntity(String make, String model, String engine, String cylinders, String valves, String lic) {
        PersistableEntity ecar = null;
        PersistableEntity elic = null;
        if (make.length() > 0) {
            ecar = ReadWriteEntities.createCarEntity(Integer.toString(idCount));
            ++idCount;
        }
        if (lic.length() > 0) {
            elic = ReadWriteEntities.createLicenseEntity(lic);
        }
        if (elic != null && ecar != null) {
            ReadWriteEntities.combineCarLicense(ecar, elic);
        }
        int cyl = Integer.parseInt(cylinders);
        int val = Integer.parseInt(valves);
        ReadWriteEntities.setCarAttributes(ecar, make, model, engine, cyl, val);
        ReadWriteEntities.writeEntity(ecar);
        ReadWriteEntities.writeEntity(elic);
    }

    public static Vector readEntity(Vector retVector, int index, int sortIndex, boolean sort_ascending, String obj, boolean all) {
        Vector<String> found_entities = null;
        int count = 0;
        PersistenceException e = null;
        try {
            if (perManager == null) {
                System.out.println(" perManager is null");
            } else {
                Object entity;
                ReadWriteEntities.setupPersistenceRuntime();
                perManager.beginTransaction(false);
                MeIterator entities = null;
                QueryRuntime queryRuntime = QueryRuntime.getInstance();
                SortOrder sortOrder = null;
                SortOrder[] sortOrderMake = new SortOrder[2];
                Condition cond = null;
                Query query = null;
                ClassDescriptor cdes = master.getClassDescriptor("Car-Query");
                AttributeDescriptor attDesc = cdes.getAttributeDescriptor(0);
                cond = index < 0 ? queryRuntime.createCondition(attDesc, RelationalOperatorType.GREATER_THAN, (Object)"") : queryRuntime.createCondition(attDesc, RelationalOperatorType.STARTS_WITH, (Object)obj);
                sortOrderMake[0] = queryRuntime.createSortOrder(ExamplePackagePersistenceMaster.CAR_ATTRIBS[sortIndex], sort_ascending);
                sortOrderMake[1] = queryRuntime.createSortOrder(ExamplePackagePersistenceMaster.CAR_ATTRIBS[sortIndex + 1], true);
                sortOrder = queryRuntime.createSortOrder(sortOrderMake);
                query = queryRuntime.createQuery(cdes.getClasstype(), cond, sortOrder);
                entities = perManager.get(query);
                while (entities.hasNext()) {
                    entity = (Car)entities.next();
                    found_entities = new Vector<String>();
                    found_entities.addElement(((Car)entity).toString());
                    found_entities.addElement(((Car)entity).makeToString());
                    found_entities.addElement(((Car)entity).modelToString());
                    found_entities.addElement(((Car)entity).licToString());
                    found_entities.addElement(((Car)entity).engineToString());
                    found_entities.addElement(((Car)entity).cylToString());
                    found_entities.addElement(((Car)entity).valveToString());
                    System.err.println("got car: " + ((Car)entity).toString() + " : " + ((Car)entity).makeToString());
                    ++count;
                    retVector.addElement(found_entities);
                }
                if (all) {
                    entities = perManager.getAll(ExamplePackagePersistenceMaster.P_CLASS_LICENSE);
                    while (entities.hasNext()) {
                        entity = (License)entities.next();
                        System.err.println("got license: " + entity);
                        found_entities = new Vector();
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(((License)entity).toString());
                        ++count;
                        retVector.addElement(found_entities);
                    }
                }
                perManager.commit();
            }
        }
        catch (PersistenceException e1) {
            e = e1;
            e.printStackTrace();
        }
        return retVector;
    }

    public static void deleteEntity(String obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                PersistableEntity toDel = perManager.get(master.getClassDescriptor("Car-Query"), obj);
                perManager.delete(toDel, TreeOptionType.COMPLETE);
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void commit() {
        try {
            perManager.commit();
        }
        catch (PersistenceException e) {
            System.out.println("Data can not be stored");
            e.printStackTrace();
        }
        try {
            perManager = persistence.getPersistenceManager(VisibilityType.SEPARATED);
            perManager.registerEntityFactory((EntityFactory)master);
            perManager.beginTransaction(true);
        }
        catch (PersistenceException e1) {
            System.out.println("Persistence Manager cannot be started");
            e1.printStackTrace();
        }
    }

    public static void writeExampleEntries() {
        int count = ReadWriteEntities.numberOfEntries();
        if (count == 0) {
            idCount = 0;
            ReadWriteEntities.addEntity("BMW", "540", "Gasoline", "8", "2", "HD-JD1234");
            ReadWriteEntities.addEntity("BMW", "320", "Gasoline", "6", "2", "HD-JM2345");
            ReadWriteEntities.addEntity("VW", "Passat", "Diesel", "4", "2", "");
            ReadWriteEntities.addEntity("Opel", "Vectra", "Diesel", "4", "4", "HD-JL3456");
            ReadWriteEntities.addEntity("Toyota", "Camry", "Diesel", "4", "2", "BRA-XX456");
            ReadWriteEntities.addEntity("Mazda", "6", "Gasoline", "4", "2", "SFA-BA456");
            ReadWriteEntities.addEntity("Renault", "Megane", "Diesel", "4", "2", "F-ME1256");
            ReadWriteEntities.addEntity("Renault", "Scenic", "Gasoline", "4", "2", "F-SC 5478");
            ReadWriteEntities.addEntity("Ford", "Mondeo", "Gasoline", "6", "2", "K-MO 1239");
            ReadWriteEntities.addEntity("Peugeot", "307", "Gasoline", "4", "2", "AA-X 139");
        }
    }

    private static int numberOfEntries() {
        idCount = -1;
        int count = 0;
        try {
            MeIterator entities = perManager.getAll(master.getClassDescriptor("Car-Query"));
            while (entities.hasNext()) {
                ++count;
                Car entity = (Car)entities.next();
                int id = Integer.parseInt(entity.toString());
                if (id <= idCount) continue;
                idCount = id;
            }
            ++idCount;
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return count;
    }
}

