/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample3;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import persistenceexample3.Constants;
import persistenceexample3.bean.TableViewBean;
import persistenceexample3.datafactory.ReadWriteEntities;

public class PersistenceExample
extends AbstractMEHttpServlet
implements Constants {
    public static int idCounter;
    private TableViewBean tableViewBean;
    private String headLine;
    boolean listall;
    private int filter_index;
    private int sort_index;
    private boolean sort_ascending;
    private String buttontext;
    private String buttontextQuery;
    private String filter_string;

    public String getApplicationName() {
        return "MDK_persistence_query_sortJSP";
    }

    public void doInitialize() throws ServletException {
        idCounter = 0;
        ReadWriteEntities.setupPersistenceRuntime();
        ReadWriteEntities.writeExampleEntries();
        this.setListPartial();
        this.setFilterOff();
        this.sort_index = 0;
        this.sort_ascending = true;
        ClassLoader cl = this.getClass().getClassLoader();
        AppLog aLogger = AppLog.getInstance((String)"MDK_persistence_query_sortJSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextJSP = "/jsp/menu.jsp";
        this.headLine = "I am a Mobile Infrastructure Client application using the Persistence API";
        this.getBeansFromContext(request);
        if (eventName.equals("listEntries")) {
            if (this.listall) {
                this.setListPartial();
            } else {
                this.setListAll();
            }
        }
        if (eventName.equals("addEntry")) {
            nextJSP = "/jsp/add.jsp";
        }
        if (eventName.equals("queryEntries")) {
            nextJSP = "/jsp/query.jsp";
        }
        if (eventName.equals("delEntry")) {
            this.deleteEntry(request);
        }
        if (eventName.equals("makeSort")) {
            this.sort_index = 0;
            this.sort_ascending = !this.sort_ascending;
        }
        if (eventName.equals("modelSort")) {
            this.sort_index = 1;
            this.sort_ascending = !this.sort_ascending;
        }
        if (eventName.equals("saveEntries")) {
            ReadWriteEntities.commit();
        }
        if (eventName.equals("addEntryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("addEntrySubmit")) {
            nextJSP = this.addEntry(request);
        }
        if (eventName.equals("deleteEntrySubmit")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("queryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("querySubmit")) {
            nextJSP = this.setFilter(request);
        }
        this.loadBean(this.listall);
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    private String deleteEntry(HttpServletRequest request) {
        String nextJSP = null;
        boolean aRowWasChecked = false;
        int i = 1;
        while (i < this.tableViewBean.getTableRows()) {
            String check = request.getParameter(this.tableViewBean.getTableContent(i, 0));
            if (check != null) {
                aRowWasChecked = true;
                String car = this.tableViewBean.getTableContent(i, 0);
                if (car.length() > 0) {
                    ReadWriteEntities.deleteEntity(car);
                }
            }
            ++i;
        }
        nextJSP = "/jsp/menu.jsp";
        if (!aRowWasChecked) {
            nextJSP = "/jsp/delete.jsp";
        }
        return nextJSP;
    }

    private String addEntry(HttpServletRequest request) {
        String make = request.getParameter("MAKE");
        String model = request.getParameter("MODEL");
        String engine = request.getParameter("ENGINE");
        String cylinders = request.getParameter("CYLINDERS");
        String valves = request.getParameter("VALVES");
        String lic = request.getParameter("LICENSE");
        ReadWriteEntities.addEntity(make, model, engine, cylinders, valves, lic);
        return "/jsp/menu.jsp";
    }

    private String setFilter(HttpServletRequest request) {
        this.filter_string = request.getParameter("MAKE");
        if (this.filter_string.length() == 0) {
            this.setFilterOff();
        } else {
            this.setFilterOn(0, this.filter_string);
        }
        return "/jsp/menu.jsp";
    }

    private void getBeansFromContext(HttpServletRequest request) {
        this.tableViewBean = (TableViewBean)request.getSession().getAttribute("dataBean");
        if (this.tableViewBean == null) {
            this.tableViewBean = new TableViewBean();
        }
    }

    public void loadBean(boolean all) {
        this.tableViewBean.setString(this.headLine);
        this.tableViewBean.setButton(this.buttontext);
        this.tableViewBean.setButtonQuery(this.buttontextQuery);
        Vector ent = new Vector();
        Vector<String> dataVec = new Vector<String>();
        dataVec.addElement(" ");
        dataVec.addElement("<a href=\"?event=makeSort\" > <img src=\"" + this.getMimeMakeFileName() + "\" border=\"0\">Make</a>");
        dataVec.addElement("<a href=\"?event=modelSort\" > <img src=\"" + this.getMimeModelFileName() + "\" border=\"0\">Model</a>");
        dataVec.addElement("License");
        dataVec.addElement("Engine");
        dataVec.addElement("C");
        dataVec.addElement("V");
        ent.addElement(dataVec);
        ent = ReadWriteEntities.readEntity(ent, this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, all);
        this.tableViewBean.setTableContent(ent);
        this.tableViewBean.setTableRows(ent.size());
        this.tableViewBean.setTableColumns(7);
    }

    private String getMimeMakeFileName() {
        String mime = "mimes/nosort.gif";
        if (this.sort_index == 0) {
            mime = "mimes/ascending.gif";
            if (!this.sort_ascending) {
                mime = "mimes/descending.gif";
            }
        }
        return mime;
    }

    private String getMimeModelFileName() {
        String mime = "mimes/nosort.gif";
        if (this.sort_index == 1) {
            mime = "mimes/ascending.gif";
            if (!this.sort_ascending) {
                mime = "mimes/descending.gif";
            }
        }
        return mime;
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.tableViewBean == null) {
            request.getSession().removeAttribute("dataBean");
        } else {
            request.getSession().setAttribute("dataBean", (Object)this.tableViewBean);
        }
    }

    public void setListPartial() {
        this.listall = false;
        this.buttontext = " List all ";
    }

    public void setListAll() {
        this.listall = true;
        this.buttontext = "Short List";
    }

    private void setFilterOff() {
        this.filter_index = -1;
        this.buttontextQuery = "Set Filter";
    }

    private void setFilterOn(int Index, String filter_string) {
        this.buttontextQuery = "Filter: " + filter_string;
        this.filter_index = 0;
    }
}

