/*
 * Decompiled with CFR 0.152.
 */
package genericsyncexample1;

import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundContainerElement;
import com.sap.ip.me.api.sync.InboundProcessor;
import genericsyncexample1.Constants;
import genericsyncexample1.GenericSyncExample;
import genericsyncexample1.bean.UserInformation;
import java.io.Serializable;

public class InboundProcessing
implements InboundProcessor,
Constants,
Serializable {
    public String getMethodName() {
        return "MDK_USER_INFO_READ";
    }

    public void process(InboundContainer inbound) {
        GenericSyncExample.aLogger.log(70, "CookbookExampleInboundProcessing: Processing incoming data container");
        this.dumpContainer(inbound);
        InboundContainerElement[] userInfos = inbound.getElementsWithFieldName("USER_myUSR03");
        int i = 0;
        while (i < userInfos.length) {
            String info = userInfos[i].getFieldValue();
            UserInformation userInfo = UserInformation.getInstance();
            try {
                userInfo.setMandant(info.substring(0, 3).trim());
                userInfo.setUserName(info.substring(3, 15).trim());
                userInfo.setFirstName(info.substring(15, 45).trim());
                userInfo.setLastName(info.substring(45, 75).trim());
                userInfo.setCompanyName(info.substring(75, 105).trim());
                userInfo.setSalut(info.substring(105, 120).trim());
                userInfo.setBuilding(info.substring(120, 126).trim());
                userInfo.setRoom(info.substring(126, 132).trim());
                userInfo.setCountry(info.substring(132, 135).trim());
                userInfo.setPhone(info.substring(135).trim());
            }
            catch (StringIndexOutOfBoundsException outOfBounds) {
                // empty catch block
            }
            ++i;
        }
        GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing: Processing incoming data container done.");
    }

    private void dumpContainer(InboundContainer container) {
        InboundContainerElement[] elements = container.getAllElements();
        GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing: ************************************************************");
        GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing:  Datacontainer contains {0} Elements", (Object)new Integer(elements.length));
        int i = 0;
        while (i < elements.length) {
            GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing:   {0}. Element: name={1}[{2}]", (Object)new Integer(i), (Object)elements[i].getFieldName(), (Object)elements[i].getLineNumber());
            GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing:            value={0}", (Object)elements[i].getFieldValue());
            ++i;
        }
        GenericSyncExample.aLogger.log(90, "GenericSyncExampleInboundProcessing: ************************************************************");
    }
}

