/*
 * Decompiled with CFR 0.152.
 */
package genericsyncexample1;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.sync.SyncPasswordException;
import genericsyncexample1.Constants;
import genericsyncexample1.InboundProcessing;
import genericsyncexample1.bean.TableViewBean;
import genericsyncexample1.bean.UserInformation;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GenericSyncExample
extends AbstractMEHttpServlet
implements Constants {
    private TableViewBean dataBean;
    private String headLine;
    public static AbstractLogging aLogger = null;

    public String getApplicationName() {
        return "MDK_genericsync_simpleJSP";
    }

    public void doInitialize() throws ServletException {
        ClassLoader cl = this.getClass().getClassLoader();
        aLogger = AppLog.getInstance((String)"MDK_genericsync_simpleJSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
        InboundProcessing ip = new InboundProcessing();
        InboundProcessorRegistry.getInstance().register((InboundProcessor)ip);
        aLogger.log(70, "GenericSyncExample servlet: Inbound processing class for function ''{0}'' registered.", (Object)"MDK_USER_INFO_READ");
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String errorMessage = null;
        String nextJSP = "/jsp/welcome.jsp";
        this.headLine = "Hello. I am a Mobile Infrastructure Client application. Who are you ?";
        if (eventName.equals("name")) {
            String userName = request.getParameter("NAME_OF_USER");
            String syncPassword = request.getParameter("SYNC_PASSWORD");
            this.headLine = "Welcome " + userName.toUpperCase() + ". Here is your current user information from the Web AS:";
            errorMessage = this.getUserInfo(userName, syncPassword);
            if (errorMessage != null) {
                this.headLine = "Welcome " + userName.toUpperCase() + ". The synchronization did fail with error message:";
            }
            nextJSP = "/jsp/tableView.jsp";
        }
        this.getBeansFromContext(request);
        this.loadBean(errorMessage);
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserInfo(String userName, String syncPassword) {
        String errormessage = null;
        aLogger.log(90, "systemInfo.getUserInfo() reads R/3 user information for user: {0}", (Object)userName);
        try {
            try {
                String user = Configuration.getInstance().getProperty("MobileEngine.Sync.User", userName);
                OutboundContainerFactory outfactory = OutboundContainerFactory.getInstance();
                if (outfactory == null) {
                    errormessage = "OutboundContainerFactory.getInstance failed";
                }
                OutboundContainer out = outfactory.createOutboundContainer(VisibilityType.SEPARATED, "MDK_USER_INFO_READ", "R");
                out.addItem("USER_NAME", userName.toUpperCase());
                out.close();
                SyncManager sm = SyncManager.getInstance();
                if (!sm.isSyncCredentialAvailable()) {
                    System.out.println("Sync password not set yet. Set Sync password");
                    sm.setSyncPasswordOfCurrentUser(syncPassword);
                }
                sm.synchronizeWithBackend();
            }
            catch (SyncException ex) {
                errormessage = ex.getMessage();
                Object var9_11 = null;
                aLogger.log(90, "UserInformationManager: Get information from R3 for user done.");
                return errormessage;
            }
            catch (SyncPasswordException e) {
                errormessage = e.getMessage();
                System.out.println("Password could not be set: " + (Object)((Object)e));
                Object var9_12 = null;
                aLogger.log(90, "UserInformationManager: Get information from R3 for user done.");
                return errormessage;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            aLogger.log(90, "UserInformationManager: Get information from R3 for user done.");
            throw throwable;
        }
        aLogger.log(90, "UserInformationManager: Get information from R3 for user done.");
        return errormessage;
    }

    private void getBeansFromContext(HttpServletRequest request) {
        this.dataBean = (TableViewBean)request.getSession().getAttribute("dataBean");
        if (this.dataBean == null) {
            this.dataBean = new TableViewBean();
        }
    }

    public void loadBean(String errorMessage) {
        this.dataBean.setString(this.headLine);
        if (errorMessage == null) {
            UserInformation ui = UserInformation.getInstance();
            int i = 0;
            this.dataBean.setTableContent(i, 0, "Name");
            this.dataBean.setTableContent(i, 1, "Value");
            this.dataBean.setTableContent(++i, 0, "First name");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getFirstName()));
            this.dataBean.setTableContent(++i, 0, "Last name");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getLastName()));
            this.dataBean.setTableContent(++i, 0, "Company");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getCompanyName()));
            this.dataBean.setTableContent(++i, 0, "Building");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getBuilding()));
            this.dataBean.setTableContent(++i, 0, "Country");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getCountry()));
            this.dataBean.setTableContent(++i, 0, "Phone");
            this.dataBean.setTableContent(i, 1, this.stringLoad(ui.getPhone()));
            this.dataBean.setTableRows(++i);
            this.dataBean.setTableColumns(2);
        } else {
            this.dataBean.setTableContent(0, 0, errorMessage);
            this.dataBean.setTableRows(1);
            this.dataBean.setTableColumns(1);
        }
    }

    public String stringLoad(String var) {
        String vartmp = AbstractMEHttpServlet.encodeForHtml((String)var);
        if (vartmp == null || vartmp.length() == 0) {
            vartmp = "<I>Value not found in inbound container</I>";
        }
        return vartmp;
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.dataBean == null) {
            request.getSession().removeAttribute("dataBean");
        } else {
            request.getSession().setAttribute("dataBean", (Object)this.dataBean);
        }
    }
}

