/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample4.bean;

import java.util.Vector;
import persistenceexample4.Constants;

public class TableViewDefinition
implements Constants {
    private int maxPage;
    private Vector tableContent;
    private Vector tableHeader;
    private Vector headerPanel;
    private Vector footerPanel;
    private Vector commandLine;
    private int currentPage;
    private int current_index;
    private int selected_index;
    private int rows_in_dataset;
    private int tablerows;
    private int tablecolumns;
    private String centerPageTitle;
    private String formName;

    public Vector getFooterPanel() {
        return this.footerPanel;
    }

    public String getFooterPanelEntryLeft() {
        return this.footerPanel.elementAt(0).toString();
    }

    public String getFooterPanelEntryRight() {
        return this.footerPanel.elementAt(1).toString();
    }

    public void setFooterPanelEntryLeft(String entry) {
        if (this.footerPanel == null) {
            this.initFooterPanel();
        }
        this.footerPanel.setElementAt(entry, 0);
    }

    public void setFooterPanelEntryRight(String entry) {
        if (this.footerPanel == null) {
            this.initFooterPanel();
        }
        this.footerPanel.setElementAt(entry, 1);
    }

    public void initFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new Vector();
            this.footerPanel.addElement(" ");
            this.footerPanel.addElement(" ");
        }
    }

    public void initHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new Vector();
            this.headerPanel.addElement(" ");
            this.headerPanel.addElement(" ");
        }
    }

    public Vector getHeaderPanel() {
        return this.headerPanel;
    }

    public String getHeaderPanelEntryLeft() {
        return this.headerPanel.elementAt(0).toString();
    }

    public String getHeaderPanelEntryRight() {
        return this.headerPanel.elementAt(1).toString();
    }

    public void setHeaderPanelEntryLeft(String entry) {
        if (this.headerPanel == null) {
            this.initHeaderPanel();
        }
        this.headerPanel.setElementAt(entry, 0);
    }

    public void setHeaderPanelEntryRight(String entry) {
        if (this.headerPanel == null) {
            this.initHeaderPanel();
        }
        this.headerPanel.setElementAt(entry, 1);
    }

    public void setFooterPanel(Vector vector) {
        this.footerPanel = vector;
    }

    public void setHeaderPanel(Vector vector) {
        this.headerPanel = vector;
    }

    public String getHeaderContent(int column) {
        return this.tableHeader.elementAt(column).toString();
    }

    public String getCenterPageTitle() {
        return this.centerPageTitle;
    }

    public void setCenterPageTitle(String title) {
        this.centerPageTitle = title;
    }

    public String getCommandLine(String separator) {
        String commandLineString = "";
        int j = 0;
        while (j < this.commandLine.size()) {
            String dataEntry = (String)this.commandLine.elementAt(j);
            if (commandLineString.length() > 1) {
                commandLineString = commandLineString.concat(separator);
            }
            commandLineString = commandLineString.concat(dataEntry);
            ++j;
        }
        return commandLineString;
    }

    public void setCommandLine(Vector commands) {
        this.commandLine = commands;
    }

    public void addCommand(String command) {
        this.commandLine.addElement(command);
    }

    public void setRowsInDataset(int i) {
        this.rows_in_dataset = i;
    }

    public int getRowsInDataset() {
        return this.rows_in_dataset;
    }

    public boolean isTopPrevPagesAvailable() {
        boolean ret = false;
        if (this.current_index >= 5) {
            ret = true;
        }
        return ret;
    }

    public boolean isNextLastPageAvailable() {
        boolean ret = false;
        if (this.rows_in_dataset > this.tablerows + this.current_index) {
            ret = true;
        }
        return ret;
    }

    public String getTopIcon() {
        String event = "";
        String icon = "mimes/top_off.gif";
        if (this.isTopPrevPagesAvailable()) {
            icon = "mimes/top.gif";
            event = " href=\"?event=navGoTop\"";
        }
        String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"First page\" ></a>";
        return ret;
    }

    public String getBottomIcon() {
        String event = "";
        String icon = "mimes/bottom_off.gif";
        if (this.isNextLastPageAvailable()) {
            icon = "mimes/bottom.gif";
            event = " href=\"?event=navGoBottom\"";
        }
        String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Last page\" ></a>";
        return ret;
    }

    public String getPageupIcon() {
        String event = "";
        String icon = "mimes/pageup_off.gif";
        if (this.isTopPrevPagesAvailable()) {
            icon = "mimes/pageup.gif";
            event = " href=\"?event=navGoPageup\"";
        }
        String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Page up\" ></a>";
        return ret;
    }

    public String getPagedownIcon() {
        String event = "";
        String icon = "mimes/pagedown_off.gif";
        if (this.isNextLastPageAvailable()) {
            icon = "mimes/pagedown.gif";
            event = " href=\"?event=navGoPagedown\"";
        }
        String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Page down\" ></a>";
        return ret;
    }

    public String getGotoIcon() {
        String ret = "<input type=\"image\" value=\"\" class=\"image\" name=\"_event_navGoToPage\" title=\"Go to selected page\" src=\"mimes/run.gif\" alt=\"go to page\" >";
        return ret;
    }

    public Vector getTableHeader() {
        return this.tableHeader;
    }

    public void initTableHeader(int noFields) {
        this.tableHeader = new Vector();
        int i = 0;
        while (i < noFields) {
            this.tableHeader.addElement(" ");
            ++i;
        }
    }

    public void setTableHeader(Vector vector) {
        this.tableHeader = vector;
    }

    public void setTableHeaderEntry(int col, String entry) {
        this.tableHeader.setElementAt(entry, col);
    }

    public int getTableRows() {
        return this.tablerows;
    }

    public void setTableRows(int i) {
        this.tablerows = i;
    }

    public int getTableColumns() {
        return this.tablecolumns;
    }

    public void setTableColumns(int col) {
        this.tablecolumns = col;
    }

    public int getCurrentPage() {
        this.currentPage = this.current_index / 5 + 1;
        return this.currentPage;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    public int getCurrentIndex() {
        return this.current_index;
    }

    public void setCurrentIndex(int i) {
        this.current_index = i;
    }

    public int getMaxPage() {
        this.maxPage = 1;
        if (this.rows_in_dataset != 0) {
            this.maxPage = (this.rows_in_dataset - 1 + 5) / 5;
        }
        return this.maxPage;
    }

    public void setMaxPage(int i) {
        this.maxPage = i;
    }

    public String getFormName() {
        return "MIForm";
    }

    public String getEventID() {
        return "mievt_id";
    }

    public String getEventType() {
        return "mievt_ty";
    }

    public String getEventObject() {
        return "mievt_obj";
    }

    public int getIndexMake() {
        return 1;
    }

    public int getIndexModel() {
        return 2;
    }

    public int getIndexCylinder() {
        return 5;
    }

    public int getIndexEngine() {
        return 4;
    }

    public int getIndexLicense() {
        return 3;
    }

    public int getIndexValves() {
        return 6;
    }

    public int getSelected_index() {
        return this.selected_index;
    }

    public void setSelected_index(int i) {
        this.selected_index = i;
    }
}

