/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample4;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import persistenceexample4.Constants;
import persistenceexample4.bean.BasicDataHandler;
import persistenceexample4.bean.TableViewDefinition;
import persistenceexample4.datafactory.ReadWriteEntities;

public class PersistenceExample
extends AbstractMEHttpServlet
implements Constants {
    public static int idCounter;
    private TableViewDefinition tableViewDefinition;
    private BasicDataHandler dataHandler;
    private String headLine;
    boolean listall;
    private int filter_index;
    private int start_index;
    private int sort_index;
    private boolean sort_ascending;
    private String buttontext;
    private String pageTitle;
    private String currentPageFooter;
    private String buttontextQuery;
    private String filter_string;
    private String current_filter_string;
    private Vector commandLine = new Vector();

    public String getApplicationName() {
        return "MDK_persistence_q_s_miGUI_JSP";
    }

    public void doInitialize() throws ServletException {
        idCounter = 0;
        ReadWriteEntities.setupPersistenceRuntime();
        ReadWriteEntities.writeExampleEntries();
        this.setListPartial();
        this.setFilterOff();
        this.sort_index = 0;
        this.sort_ascending = true;
        ClassLoader cl = this.getClass().getClassLoader();
        AppLog aLogger = AppLog.getInstance((String)"MDK_persistence_q_s_miGUI_JSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
        this.setCommands();
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextJSP = "/jsp/menu.jsp";
        this.pageTitle = "Car Inventory";
        this.currentPageFooter = "menu.jsp";
        this.headLine = "I am a Mobile Infrastructure Client application using the Persistence API";
        this.getBeansFromContext(request);
        if (eventName.equals("listEntries")) {
            if (this.listall) {
                this.setListPartial();
            } else {
                this.setListAll();
            }
        }
        if (eventName.equals("addEntry")) {
            this.pageTitle = "Add car/license";
            this.currentPageFooter = "add.jsp";
            nextJSP = "/jsp/add.jsp";
        }
        if (eventName.equals("queryEntries")) {
            nextJSP = "/jsp/query.jsp";
        }
        if (eventName.equals("delEntry")) {
            nextJSP = this.deleteEntry(request);
        }
        if (eventName.equals("saveChanges")) {
            this.dataHandler.commit();
        }
        if (eventName.equals("makeSort")) {
            this.sort_index = 0;
            this.sort_ascending = !this.sort_ascending;
            this.dataHandler = BasicDataHandler.instance(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this.listall);
        }
        if (eventName.equals("modelSort")) {
            this.sort_index = 1;
            this.sort_ascending = !this.sort_ascending;
            this.dataHandler = BasicDataHandler.instance(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this.listall);
        }
        if (eventName.equals("addEntryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("addEntrySubmit")) {
            nextJSP = this.addEntry(request);
        }
        if (eventName.equals("deleteEntrySubmit")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("queryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("querySubmit")) {
            nextJSP = this.setFilter(request);
        }
        if (eventName.equals("navGoTop")) {
            this.start_index = 0;
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("navGoBottom")) {
            this.start_index = (this.tableViewDefinition.getRowsInDataset() - 1) / 5 * 5;
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("navGoPageup")) {
            if (this.start_index >= 5) {
                this.start_index -= 5;
            }
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("navGoPagedown")) {
            this.start_index += 5;
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.startsWith("navGoToPage")) {
            String inputField = request.getParameter("GOTO_PAGE");
            int number = Integer.parseInt(inputField);
            this.start_index = (number - 1) * 5;
            int max_index = (this.tableViewDefinition.getRowsInDataset() - 1) / 5 * 5;
            if (this.start_index > max_index) {
                this.start_index = max_index;
            }
            if (this.start_index < 0) {
                this.start_index = 0;
            }
            nextJSP = "/jsp/menu.jsp";
        }
        if (this.getDetailPage(eventName)) {
            nextJSP = "/jsp/detail.jsp";
        }
        this.loadBean();
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    private boolean getDetailPage(String eventName) {
        boolean event = false;
        int i = 0;
        while (i < this.tableViewDefinition.getTableRows()) {
            if (eventName.equals(this.dataHandler.getCurrentSubTableContent(i, 0))) {
                event = true;
                this.tableViewDefinition.setSelected_index(i);
            }
            ++i;
        }
        return event;
    }

    private String deleteEntry(HttpServletRequest request) {
        String nextJSP = null;
        boolean aRowWasChecked = false;
        int i = 1;
        while (i < this.tableViewDefinition.getTableRows()) {
            String check = request.getParameter(this.dataHandler.getCurrentSubTableContent(i, 0));
            if (check != null) {
                aRowWasChecked = true;
                String car = this.dataHandler.getCurrentSubTableContent(i, 0);
                if (car.length() > 0) {
                    ReadWriteEntities.deleteEntity(car);
                    this.dataHandler = BasicDataHandler.instance(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this.listall);
                }
            }
            ++i;
        }
        nextJSP = "/jsp/menu.jsp";
        if (!aRowWasChecked) {
            nextJSP = "/jsp/delete.jsp";
        }
        return nextJSP;
    }

    private String addEntry(HttpServletRequest request) {
        String make = request.getParameter("MAKE");
        String model = request.getParameter("MODEL");
        String engine = request.getParameter("ENGINE");
        String cylinders = request.getParameter("CYLINDERS");
        String valves = request.getParameter("VALVES");
        String lic = request.getParameter("LICENSE");
        this.dataHandler.addEntry(make, model, engine, cylinders, valves, lic);
        this.dataHandler = BasicDataHandler.instance(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this.listall);
        return "/jsp/menu.jsp";
    }

    private String setFilter(HttpServletRequest request) {
        this.filter_string = request.getParameter("MAKE");
        if (this.filter_string.length() == 0) {
            this.setFilterOff();
        } else {
            this.setFilterOn(0, this.filter_string);
        }
        return "/jsp/menu.jsp";
    }

    private void getBeansFromContext(HttpServletRequest request) {
        this.tableViewDefinition = (TableViewDefinition)request.getSession().getAttribute("tableViewDefinition");
        if (this.tableViewDefinition == null) {
            this.tableViewDefinition = new TableViewDefinition();
        }
        this.dataHandler = (BasicDataHandler)request.getSession().getAttribute("dataHandler");
        if (this.dataHandler == null) {
            this.dataHandler = BasicDataHandler.instance(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this.listall);
        }
    }

    public void loadBean() {
        this.tableViewDefinition.setHeaderPanelEntryLeft("<a href=\"http://127.0.0.1:4444/me\" > <img src=\"mimes/milogo.gif\" alt=\"MI Home\" ></a>");
        this.tableViewDefinition.setHeaderPanelEntryRight("MDK");
        this.setCommands();
        this.tableViewDefinition.setFooterPanelEntryLeft(this.current_filter_string);
        this.tableViewDefinition.setFooterPanelEntryRight(this.currentPageFooter);
        this.tableViewDefinition.setCommandLine(this.commandLine);
        this.tableViewDefinition.setCenterPageTitle(this.pageTitle);
        this.setTableHeader();
        this.dataHandler.copyDataArrayToSubArray(this.start_index, 5);
        this.tableViewDefinition.setTableRows(5);
        this.tableViewDefinition.setTableColumns(this.dataHandler.getColumns());
        this.tableViewDefinition.setRowsInDataset(this.dataHandler.getDataCount());
        this.tableViewDefinition.setCurrentIndex(this.start_index);
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.tableViewDefinition == null) {
            request.getSession().removeAttribute("tableViewDefintion");
        } else {
            request.getSession().setAttribute("tableViewDefinition", (Object)this.tableViewDefinition);
        }
        if (this.dataHandler == null) {
            request.getSession().removeAttribute("dataHandler");
        } else {
            request.getSession().setAttribute("dataHandler", (Object)this.dataHandler);
        }
    }

    public void setListPartial() {
        this.listall = false;
        this.buttontext = "List all";
    }

    public void setListAll() {
        this.listall = true;
        this.buttontext = "Car list";
    }

    private void setFilterOff() {
        this.filter_index = -1;
        this.buttontextQuery = "Set Filter";
        this.current_filter_string = "No Filter";
    }

    private void setFilterOn(int Index, String filter_string) {
        this.buttontextQuery = "Reset Filter";
        this.current_filter_string = "Filter: " + filter_string;
        this.filter_index = 0;
    }

    private void setCommands() {
        this.commandLine.removeAllElements();
        this.commandLine.addElement("<input type=\"submit\" value=\"Add\" class=\"image\" name=\"_event_addEntry\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"" + this.buttontextQuery + "\" class=\"image\" name=\"_event_" + "queryEntries" + "\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"" + this.buttontext + "\" class=\"image\" name=\"_event_" + "listEntries" + "\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"Delete\" class=\"image\" name=\"_event_delEntry\">");
        this.commandLine.addElement("<input type=\"submit\" value=\"Save\" class=\"image\" name=\"_event_saveChanges\">");
    }

    private void setTableHeader() {
        this.tableViewDefinition.initTableHeader(4);
        this.tableViewDefinition.setTableHeaderEntry(0, "&nbsp;");
        this.tableViewDefinition.setTableHeaderEntry(1, "<a href=\"?event=makeSort\" > <img src=\"" + this.getMimeMakeFileName() + "\" border=\"0\">Make</a>");
        this.tableViewDefinition.setTableHeaderEntry(2, "<a href=\"?event=modelSort\" > <img src=\"" + this.getMimeModelFileName() + "\" border=\"0\">Model</a>");
        this.tableViewDefinition.setTableHeaderEntry(3, "License");
    }

    private String getMimeMakeFileName() {
        String mime = "mimes/nosort.gif";
        if (this.sort_index == 0) {
            mime = "mimes/ascending.gif";
            if (!this.sort_ascending) {
                mime = "mimes/descending.gif";
            }
        }
        return mime;
    }

    private String getMimeModelFileName() {
        String mime = "mimes/nosort.gif";
        if (this.sort_index == 1) {
            mime = "mimes/ascending.gif";
            if (!this.sort_ascending) {
                mime = "mimes/descending.gif";
            }
        }
        return mime;
    }
}

