/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.panel;

import com.sap.ip.me.mdk.api.awt.gui.component.BorderedLabel;
import com.sap.ip.me.mdk.api.awt.gui.component.BorderedPanel;
import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

public class MenuPanel
extends Panel {
    public static final int VERTICAL = 300;
    public static final int HORIZONTAL = 301;
    private BorderedLabel titleLabel = null;
    private static Font textFont = Utilities.fntBold11Dialog;
    private static Color titleBGColor = Utilities.headerBodyBGColor;
    private static Color titleColor = Utilities.headerTextColor;
    private BorderedPanel bp = null;
    private BorderedPanel mnuPanel = null;

    public MenuPanel(String title) {
        this.titleLabel = new BorderedLabel(title);
        this.titleLabel.setFont(textFont);
        this.titleLabel.setForeground(titleColor);
        this.titleLabel.setBackground(titleBGColor);
        double[][] size = new double[][]{{0.0, -1.0}, {-3.0, -2.0, -2.0, -1.0}};
        this.setLayout(new TableLayout(size));
        this.add((Component)this.titleLabel, "1,0");
    }

    public void addMenus(Component[] c) {
        this.mnuPanel = this.createList(c, 300);
        this.addMenuPanel(this.mnuPanel);
    }

    public void removeMenus() {
        this.remove(this.bp);
        this.validate();
    }

    public void addBottomNavPanel(Component[] c) {
        this.addFooterPanel(this.createList(c, 301));
    }

    public void addMenuPanel(Panel p) {
        this.add((Component)p, "1,1");
        this.repaint();
    }

    public void addFooterPanel(Panel p) {
        this.add((Component)p, "1,2");
        this.repaint();
    }

    public void addSyncButton(Component c) {
        if (this.mnuPanel != null) {
            this.mnuPanel.add(c, "2,0");
        }
    }

    public void paint(Graphics g) {
        if (this.isShowing()) {
            g.setColor(Color.gray);
            g.drawRect(0, 0, this.getSize().width, this.getSize().height);
        }
        super.paint(g);
    }

    public BorderedPanel createList(Component[] c, int type) {
        double[] rcCount = new double[c.length];
        int i = 0;
        while (i < rcCount.length) {
            rcCount[i] = -2.0;
            ++i;
        }
        if (type == 300) {
            double[][] size = new double[][]{{0.05, -2.0, -1.0}, rcCount};
            this.bp = new BorderedPanel(new TableLayout(size));
            this.bp.enableBGDraw(true);
            this.bp.setBorderMask("BLR");
            int i2 = 0;
            while (i2 < rcCount.length) {
                this.bp.add(c[i2], "1," + i2);
                ++i2;
            }
        } else if (type == 301) {
            double[][] size = new double[][]{rcCount, {-2.0}};
            this.bp = new BorderedPanel(new TableLayout(size));
            this.bp.enableBGDraw(true);
            this.bp.setBorderMask("BLR");
            int i3 = 0;
            while (i3 < rcCount.length) {
                this.bp.add(c[i3], c.length - 1 - i3 + ",0");
                ++i3;
            }
        }
        this.bp.validate();
        return this.bp;
    }
}

