/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.panel;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.panel.NavPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

public class ImageNavPanel
extends NavPanel {
    public static final int FIRST = 0;
    public static final int PREV = 1;
    public static final int NEXT = 2;
    public static final int LAST = 3;
    TextLabel txtMessage = null;
    LinkButton[] navButtons = null;
    Image[] enableImages = null;
    Image[] disableImages = null;

    public ImageNavPanel(Image[] eImages, Image[] dImages, MouseListener commonListener, String[] targetPages, String[] targetHandlers) {
        this.enableImages = eImages;
        this.disableImages = dImages;
        this.initializeButtons(targetPages);
        this.addToRight(this.navButtons);
        if (commonListener != null) {
            this.setCommonActionHandler(commonListener);
        }
        if (targetPages != null) {
            this.setTargetPage(targetPages);
        }
        if (targetHandlers != null) {
            this.setTargetHandler(targetHandlers);
        }
    }

    private void initializeButtons(String[] actionString) {
        if (this.enableImages != null) {
            this.navButtons = new LinkButton[this.enableImages.length];
            int i = 0;
            while (i < this.navButtons.length) {
                this.navButtons[i] = new LinkButton(this.enableImages[i]);
                ++i;
            }
        } else {
            this.navButtons = new LinkButton[actionString.length];
            int i = 0;
            while (i < this.navButtons.length) {
                this.navButtons[i] = new LinkButton(actionString[i]);
                ++i;
            }
        }
    }

    public void setCommonActionHandler(MouseListener msListener) {
        int i = 0;
        while (i < this.navButtons.length) {
            this.setActionHandler(i, msListener);
            ++i;
        }
    }

    public void disableFirstAndPrevious() {
        this.navButtons[0].setEnabled(false);
        this.navButtons[1].setEnabled(false);
        this.setDisabledImage(0);
        this.setDisabledImage(1);
        this.invalidate();
    }

    public void disableNextAndLast() {
        this.navButtons[2].setEnabled(false);
        this.navButtons[3].setEnabled(false);
        this.setDisabledImage(2);
        this.setDisabledImage(3);
        this.invalidate();
    }

    public void enableFirstAndPrevious() {
        this.navButtons[0].setEnabled(true);
        this.navButtons[1].setEnabled(true);
        this.setEnabledImage(0);
        this.setEnabledImage(1);
        this.invalidate();
    }

    public void enableNextAndLast() {
        this.navButtons[2].setEnabled(true);
        this.navButtons[3].setEnabled(true);
        this.setEnabledImage(2);
        this.setEnabledImage(3);
        this.invalidate();
    }

    public void setActionHandler(int whichButton, MouseListener msListener) {
        if (whichButton <= 3 && whichButton >= 0) {
            this.navButtons[whichButton].addMouseListener(msListener);
        }
    }

    public void setTargetPage(String[] actionString) {
        int i = 0;
        while (i < actionString.length) {
            this.setTargetPage(i, actionString[i]);
            ++i;
        }
    }

    public void setTargetPage(int whichButton, String targetPage) {
        if (whichButton <= 3 && whichButton >= 0) {
            this.navButtons[whichButton].setTargetPage(targetPage);
        }
    }

    public void setTargetHandler(String[] targetHandlers) {
        int i = 0;
        while (i < targetHandlers.length) {
            this.setTargetHandler(i, targetHandlers[i]);
            ++i;
        }
    }

    public void setTargetHandler(int whichButton, String targetHandler) {
        if (whichButton <= 3 && whichButton >= 0) {
            this.navButtons[whichButton].setTargetHandler(targetHandler);
        }
    }

    public void setMessageText(String messageText) {
        if (this.txtMessage == null) {
            this.txtMessage = new TextLabel(messageText);
            Component[] msg = new Component[]{this.txtMessage};
            this.addToLeft(msg);
        } else {
            this.txtMessage.setLabel(messageText);
        }
        super.validate();
    }

    public void setActionAttributes(int whichButton, String targetPage, String targetHandler) {
        this.setTargetPage(whichButton, targetPage);
        this.setTargetHandler(whichButton, targetHandler);
    }

    private void setDisabledImage(int whichButton) {
        if (whichButton <= 3 && whichButton >= 0) {
            this.navButtons[whichButton].setImage(this.disableImages[whichButton]);
        }
    }

    private void setEnabledImage(int whichButton) {
        if (whichButton <= 3 && whichButton >= 0) {
            this.navButtons[whichButton].setImage(this.enableImages[whichButton]);
        }
    }
}

