/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextLabel
extends Component {
    private String label = null;
    private Color textColor = Utilities.labelTextColor;
    private Font textFont = Utilities.fntPlain10Dialog;

    public TextLabel() {
        this(null);
    }

    public TextLabel(String str) {
        this.label = str;
    }

    public TextLabel(String str, Font fnt, Color clr) {
        this.label = str;
        this.textFont = fnt;
        this.textColor = clr;
    }

    public void addNotify() {
        super.addNotify();
        Dimension d = this.getSize();
        if (d.width == 0 || d.height == 0) {
            this.setSize(this.figureMySize(this.getGraphics()));
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setFont(Font f) {
        this.textFont = f;
        this.repaint();
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public synchronized void setLabel(String lab) {
        this.label = lab;
        this.invalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.figureMySize(this.getGraphics());
    }

    protected Dimension figureMySize(Graphics g) {
        int width = 20;
        int height = 20;
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            if (this.label != null) {
                height = fm.getHeight();
                width = Utilities.pixelsWideForString(this.label, fm);
                width += 2;
            }
        }
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        if (this.isShowing() && this.label != null && this.label.length() > 0) {
            g.setColor(this.textColor == null ? this.getForeground() : this.textColor);
            g.setFont(this.textFont);
            int y = (this.getSize().height + g.getFontMetrics().getHeight()) / 2 - g.getFontMetrics().getAscent() / 2 + 1;
            g.drawString(this.label, 3, y);
        }
    }
}

