/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class ComboBox
extends Choice
implements ItemListener {
    private Hashtable dataTable = null;
    private LinkButton[] linkButtons = null;
    public static final String BLANK = "             ";

    public ComboBox() {
        this.addItemListener(this);
        this.dataTable = new Hashtable(1);
    }

    public void addItem(String item, Object data) {
        super.addItem(item);
        this.dataTable.put(item, data);
    }

    public void remove(String item) {
        super.remove(item);
        this.dataTable.remove(item);
    }

    public void remove(int nItem) {
        this.dataTable.remove(this.getItem(nItem));
        this.remove(nItem);
    }

    public void removeAll() {
        super.removeAll();
        this.dataTable.clear();
    }

    public String getItemKey(Object data) {
        if (!this.dataTable.contains(data)) {
            return "";
        }
        Enumeration e = this.dataTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!data.equals(this.dataTable.get(key))) continue;
            return key;
        }
        return "";
    }

    public Object getItemData(String item) {
        if (this.dataTable == null) {
            return null;
        }
        return this.dataTable.get(item);
    }

    public Object getItemData(int nItem) {
        if (this.dataTable == null) {
            return null;
        }
        return this.dataTable.get(this.getItem(nItem));
    }

    public Object getSelectedItemData() {
        return this.getItemData(this.getSelectedItem());
    }

    public void setMandatory(LinkButton[] links) {
        this.linkButtons = links;
    }

    private void disableButtons() {
        if (this.linkButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.linkButtons.length) {
            this.linkButtons[i].setEnabled(false);
            ++i;
        }
    }

    private void enableButtons() {
        if (this.linkButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.linkButtons.length) {
            this.linkButtons[i].setEnabled(true);
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.getSelectedItem().equals("") || this.getSelectedItem().equals(BLANK)) {
            this.disableButtons();
            Utilities.beep();
        } else {
            this.enableButtons();
        }
    }
}

