/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample1.datafactory;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import java.util.Vector;
import persistenceexample1.Constants;
import persistenceexample1.datafactory.Car;
import persistenceexample1.datafactory.ExamplePackagePersistenceMaster;
import persistenceexample1.datafactory.License;

public class ReadWriteEntities
implements Constants {
    private static PersistenceRuntime persistence;
    private static PersistenceManager perManager;
    private static ExamplePackagePersistenceMaster master;
    private static int idCount;

    public static void setupPersistenceRuntime() {
        try {
            persistence = PersistenceRuntime.getInstance();
            master = new ExamplePackagePersistenceMaster();
            persistence.registerPersistenceMaster((PackagePersistenceMaster)master);
            perManager = persistence.getPersistenceManager(VisibilityType.SEPARATED);
            perManager.registerEntityFactory((EntityFactory)master);
            perManager.beginTransaction(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error during startup");
            System.exit(-1);
        }
    }

    public static PersistableEntity createCarEntity(String name) {
        Car car = new Car(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_CAR, name));
        return car;
    }

    public static PersistableEntity createLicenseEntity(String number) {
        License license = new License(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_LICENSE, number));
        return license;
    }

    public static void combineCarLicense(PersistableEntity car, PersistableEntity license) {
        License l = (License)license;
        Car c = (Car)car;
        c.setLicense(l);
    }

    public static void writeEntity(PersistableEntity obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                perManager.update(obj, TreeOptionType.COMPLETE);
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void addEntity(String make, String lic) {
        PersistableEntity ecar = null;
        PersistableEntity elic = null;
        if (make.length() > 0) {
            ecar = ReadWriteEntities.createCarEntity(make);
            ++idCount;
        }
        if (lic.length() > 0) {
            elic = ReadWriteEntities.createLicenseEntity(lic);
        }
        if (elic != null && ecar != null) {
            ReadWriteEntities.combineCarLicense(ecar, elic);
        }
        ReadWriteEntities.writeEntity(ecar);
        ReadWriteEntities.writeEntity(elic);
    }

    public static Vector readEntity(Vector retVector, boolean all) {
        Vector<String> found_entities = null;
        int count = 0;
        PersistenceException e = null;
        try {
            if (perManager == null) {
                System.out.println(" perManager is null");
            } else {
                Object entity;
                ClassDescriptor cdes = master.getClassDescriptor("Car");
                AttributeDescriptor attDesc = cdes.getAttributeDescriptor(0);
                MeIterator entities = perManager.getAll(cdes);
                int j = 0;
                while (entities.hasNext()) {
                    entity = (Car)entities.next();
                    found_entities = new Vector<String>();
                    found_entities.addElement("CHECK" + ++j);
                    found_entities.addElement(((Car)entity).toString());
                    found_entities.addElement(((Car)entity).licToString());
                    System.err.println("got car: " + ((Car)entity).toString() + " : " + ((Car)entity).makeToString());
                    ++count;
                    retVector.addElement(found_entities);
                }
                if (all) {
                    entities = perManager.getAll(ExamplePackagePersistenceMaster.P_CLASS_LICENSE);
                    while (entities.hasNext()) {
                        entity = (License)entities.next();
                        System.err.println("got license: " + entity);
                        found_entities = new Vector();
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(" ");
                        found_entities.addElement(((License)entity).toString());
                        ++count;
                        retVector.addElement(found_entities);
                    }
                }
            }
        }
        catch (PersistenceException e1) {
            e = e1;
            e.printStackTrace();
        }
        return retVector;
    }

    public static void deleteEntity(String obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                PersistableEntity toDel = perManager.get(master.getClassDescriptor("Car"), obj);
                perManager.delete(toDel, TreeOptionType.COMPLETE);
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void commit() {
        try {
            perManager.commit();
        }
        catch (PersistenceException e) {
            System.out.println("Data can not be stored");
            e.printStackTrace();
        }
        try {
            perManager = persistence.getPersistenceManager(VisibilityType.SEPARATED);
            perManager.registerEntityFactory((EntityFactory)master);
            perManager.beginTransaction(true);
        }
        catch (PersistenceException e1) {
            System.out.println("Persistence Manager cannot be started");
            e1.printStackTrace();
        }
    }

    public static void writeExampleEntries() {
        int count = ReadWriteEntities.numberOfEntries();
        if (count == 0) {
            idCount = 0;
            ReadWriteEntities.addEntity("BMW", "HD-JD1234");
            ReadWriteEntities.addEntity("BMW", "HD-JM2345");
            ReadWriteEntities.addEntity("VW", "");
            ReadWriteEntities.addEntity("Opel", "HD-JL3456");
            ReadWriteEntities.addEntity("Toyota", "BRA-XX456");
            ReadWriteEntities.addEntity("Mazda", "SFA-BA456");
            ReadWriteEntities.addEntity("Renault", "F-ME1256");
            ReadWriteEntities.addEntity("Renault", "F-SC 5478");
            ReadWriteEntities.addEntity("Ford", "K-MO 1239");
            ReadWriteEntities.addEntity("Peugeot", "AA-X 139");
        }
    }

    private static int numberOfEntries() {
        idCount = -1;
        int count = 0;
        try {
            MeIterator entities = perManager.getAll(master.getClassDescriptor("Car"));
            while (entities.hasNext()) {
                ++count;
                Car entity = (Car)entities.next();
                int id = Integer.parseInt(entity.toString());
                if (id <= idCount) continue;
                idCount = id;
            }
            ++idCount;
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return count;
    }
}

