/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample1;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import persistenceexample1.Constants;
import persistenceexample1.bean.TableViewBean;
import persistenceexample1.datafactory.ReadWriteEntities;

public class PersistenceExample
extends AbstractMEHttpServlet
implements Constants {
    private TableViewBean tableViewBean;
    private String headLine;
    private boolean listall;
    private String buttontext;

    public String getApplicationName() {
        return "MDK_persistence_simpleJSP";
    }

    public void doInitialize() throws ServletException {
        ReadWriteEntities.setupPersistenceRuntime();
        ReadWriteEntities.writeExampleEntries();
        this.setListPartial();
        ClassLoader cl = this.getClass().getClassLoader();
        AppLog aLogger = AppLog.getInstance((String)"MDK_persistence_simpleJSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextJSP = "/jsp/menu.jsp";
        this.headLine = "I am a Mobile Infrastructure Client application using the Persistence API";
        this.getBeansFromContext(request);
        if (eventName.equals("addEntry")) {
            nextJSP = "/jsp/add.jsp";
        }
        if (eventName.equals("listEntries")) {
            if (this.listall) {
                this.setListPartial();
            } else {
                this.setListAll();
            }
        }
        if (eventName.equals("delEntry")) {
            nextJSP = this.deleteEntry(request);
        }
        if (eventName.equals("saveEntries")) {
            ReadWriteEntities.commit();
        }
        if (eventName.equals("addEntryCancel")) {
            nextJSP = "/jsp/menu.jsp";
        }
        if (eventName.equals("addEntrySubmit")) {
            nextJSP = this.addEntry(request);
        }
        if (eventName.equals("deleteEntrySubmit")) {
            nextJSP = "/jsp/menu.jsp";
        }
        this.loadBean(this.listall);
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    private String addEntry(HttpServletRequest request) {
        String car = request.getParameter("CAR");
        String lic = request.getParameter("LICENSE");
        ReadWriteEntities.addEntity(car, lic);
        return "/jsp/menu.jsp";
    }

    private String deleteEntry(HttpServletRequest request) {
        boolean aRowWasChecked = false;
        int i = 1;
        while (i < this.tableViewBean.getTableRows()) {
            String check = request.getParameter(this.tableViewBean.getTableContent(i, 0));
            if (check != null) {
                aRowWasChecked = true;
                String car = this.tableViewBean.getTableContent(i, 1);
                if (car.length() > 0) {
                    ReadWriteEntities.deleteEntity(car);
                }
            }
            ++i;
        }
        String nextJSP = "/jsp/menu.jsp";
        if (!aRowWasChecked) {
            nextJSP = "/jsp/delete.jsp";
        }
        return nextJSP;
    }

    private void getBeansFromContext(HttpServletRequest request) {
        this.tableViewBean = (TableViewBean)request.getSession().getAttribute("dataBean");
        if (this.tableViewBean == null) {
            this.tableViewBean = new TableViewBean();
        }
    }

    public void loadBean(boolean all) {
        this.tableViewBean.setString(this.headLine);
        this.tableViewBean.setButton(this.buttontext);
        Vector ent = new Vector();
        Vector<String> dataVec = new Vector<String>();
        dataVec.addElement(" ");
        dataVec.addElement("Car");
        dataVec.addElement("License");
        ent.addElement(dataVec);
        ent = ReadWriteEntities.readEntity(ent, all);
        this.tableViewBean.setTableContent(ent);
        this.tableViewBean.setTableRows(ent.size());
        this.tableViewBean.setTableColumns(3);
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.tableViewBean == null) {
            request.getSession().removeAttribute("dataBean");
        } else {
            request.getSession().setAttribute("dataBean", (Object)this.tableViewBean);
        }
    }

    public void setListPartial() {
        this.listall = false;
        this.buttontext = " List all ";
    }

    public void setListAll() {
        this.listall = true;
        this.buttontext = "Short List";
    }
}

