/*
 * Decompiled with CFR 0.152.
 */
package example2;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import example2.Constants;
import example2.bean.TableViewBean;
import example2.dataHandler.BasicDataHandler;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SystemInfo
extends AbstractMEHttpServlet
implements Constants {
    private TableViewBean dataBean;
    private String headLine;

    public String getApplicationName() {
        return "MDK_configExampleEventJSP";
    }

    public void doInitialize() throws ServletException {
        ClassLoader cl = this.getClass().getClassLoader();
        AppLog aLogger = AppLog.getInstance((String)"MDK_configExampleEventJSP");
        aLogger.log(90, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (Object)(cl == null ? "(null)" : cl.toString()));
    }

    public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextJSP = "/jsp/welcome.jsp";
        this.headLine = "Hello. I am a Mobile Infrastructure Client application. Who are you ?";
        if (eventName.equals("name")) {
            this.headLine = "Welcome " + request.getParameter("NAME_OF_USER") + ". Here is some information about your Mobile Infrastructure Client installation:";
            nextJSP = "/jsp/tableView.jsp";
        }
        this.getBeansFromContext(request);
        this.loadBean(request);
        this.putBeansIntoContext(request);
        return nextJSP;
    }

    private void getBeansFromContext(HttpServletRequest request) {
        this.dataBean = (TableViewBean)request.getSession().getAttribute("dataBean");
        if (this.dataBean == null) {
            this.dataBean = new TableViewBean();
        }
    }

    public void loadBean(HttpServletRequest request) {
        this.dataBean.setString(this.headLine);
        BasicDataHandler bdh = BasicDataHandler.instance();
        bdh.setMiHomeFolder(AbstractMEHttpServlet.getMIHome());
        Vector data = bdh.getDataArray();
        this.dataBean.setTableContent(data);
        this.dataBean.setTableRows(bdh.getDataCount());
        this.dataBean.setTableColumns(bdh.getColumns());
    }

    public String stringLoad(String var) {
        String vartmp = var;
        if (vartmp == null) {
            vartmp = "<I>Not specified</I>";
        }
        return vartmp;
    }

    private void putBeansIntoContext(HttpServletRequest request) {
        if (this.dataBean == null) {
            request.getSession().removeAttribute("dataBean");
        } else {
            request.getSession().setAttribute("dataBean", (Object)this.dataBean);
        }
    }
}

