/*
 * Decompiled with CFR 0.152.
 */
import com.sap.ip.me.api.runtime.awt.AWTConfigurationUI;
import com.sap.ip.me.api.runtime.awt.AwtApplication;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class TicTacToe
extends Applet
implements MouseListener,
AwtApplication {
    public static final String homeMenuEntry = "home";
    static final int[] moves = new int[]{4, 0, 2, 6, 8, 1, 3, 5, 7};
    static final int DONE = 511;
    static final int OK = 0;
    static final int WIN = 1;
    static final int LOSE = 2;
    static final int STALEMATE = 3;
    static boolean[] won = new boolean[512];
    int white;
    int black;
    boolean first = true;
    Image notImage;
    Image crossImage;

    public void initApplication() {
        this.addMouseListener(this);
    }

    public void destroy() {
        this.removeMouseListener(this);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        int xoff = d.width / 3;
        int yoff = d.height / 3;
        int xab = d.width / 12;
        int yab = d.height / 12;
        g.drawLine(xoff, 0, xoff, d.height);
        g.drawLine(2 * xoff, 0, 2 * xoff, d.height);
        g.drawLine(0, yoff, d.width, yoff);
        g.drawLine(0, 2 * yoff, d.width, 2 * yoff);
        int i = 0;
        int r = 0;
        while (r < 3) {
            int c = 0;
            while (c < 3) {
                if ((this.white & 1 << i) != 0) {
                    g.drawOval(c * xoff + xab, r * yoff + yab, xoff - 2 * xab, yoff - 2 * yab);
                } else if ((this.black & 1 << i) != 0) {
                    g.drawLine(c * xoff + xab, r * yoff + yab, (c + 1) * xoff - xab, (r + 1) * yoff - yab);
                    g.drawLine((c + 1) * xoff - xab, r * yoff + yab, c * xoff + xab, (r + 1) * yoff - yab);
                }
                ++c;
                ++i;
            }
            ++r;
        }
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.status()) {
            case 1: 
            case 2: 
            case 3: {
                this.black = 0;
                this.white = 0;
                if (this.first) {
                    this.white |= 1 << (int)(Math.random() * 9.0);
                }
                this.first = !this.first;
                this.repaint();
                return;
            }
        }
        Dimension d = this.getSize();
        int c = x * 3 / d.width;
        int r = y * 3 / d.height;
        if (this.yourMove(c + r * 3)) {
            this.repaint();
            block3 : switch (this.status()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    if (!this.myMove()) break;
                    this.repaint();
                    switch (this.status()) {
                        case 1: {
                            break block3;
                        }
                        case 2: {
                            break block3;
                        }
                        case 3: {
                            break block3;
                        }
                    }
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public String getAppletInfo() {
        return "TicTacToe by Arthur van Hoff";
    }

    public Panel getRootPanel() {
        return this;
    }

    public void activateApplication() {
    }

    public void deactivateApplication() {
    }

    public void destroyApplication() {
    }

    public void actionMenuItem(MenuItem menuItem) {
        if (homeMenuEntry.equals(menuItem.getLabel())) {
            AWTConfigurationUI.goHome();
        }
    }

    public String getApplicationName() {
        String MI_APPLICATION_NAME = "MDK_TicTacToeAWT";
        return MI_APPLICATION_NAME;
    }

    static void isWon(int pos) {
        int i = 0;
        while (i < 511) {
            if ((i & pos) == pos) {
                TicTacToe.won[i] = true;
            }
            ++i;
        }
    }

    int bestMove(int white, int black) {
        int bestmove = -1;
        int i = 0;
        while (i < 9) {
            block9: {
                int mw = moves[i];
                if ((white & 1 << mw) == 0 && (black & 1 << mw) == 0) {
                    int pw = white | 1 << mw;
                    if (won[pw]) {
                        return mw;
                    }
                    int mb = 0;
                    while (mb < 9) {
                        int pb;
                        if ((pw & 1 << mb) != 0 || (black & 1 << mb) != 0 || !won[pb = black | 1 << mb]) {
                            ++mb;
                            continue;
                        }
                        break block9;
                    }
                    if (bestmove == -1) {
                        bestmove = mw;
                    }
                }
            }
            ++i;
        }
        if (bestmove != -1) {
            return bestmove;
        }
        int i2 = 0;
        while (i2 < 9) {
            int mw = moves[i2];
            if ((white & 1 << mw) == 0 && (black & 1 << mw) == 0) {
                return mw;
            }
            ++i2;
        }
        return -1;
    }

    boolean yourMove(int m) {
        if (m < 0 || m > 8) {
            return false;
        }
        if (((this.black | this.white) & 1 << m) != 0) {
            return false;
        }
        this.black |= 1 << m;
        return true;
    }

    boolean myMove() {
        if ((this.black | this.white) == 511) {
            return false;
        }
        int best = this.bestMove(this.white, this.black);
        this.white |= 1 << best;
        return true;
    }

    int status() {
        if (won[this.white]) {
            return 1;
        }
        if (won[this.black]) {
            return 2;
        }
        if ((this.black | this.white) == 511) {
            return 3;
        }
        return 0;
    }

    static {
        TicTacToe.isWon(7);
        TicTacToe.isWon(56);
        TicTacToe.isWon(448);
        TicTacToe.isWon(73);
        TicTacToe.isWon(146);
        TicTacToe.isWon(292);
        TicTacToe.isWon(273);
        TicTacToe.isWon(84);
    }
}

