/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample4;

import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.awt.AwtApplication;
import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.panel.FooterPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.HeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.BorderLayout;
import java.awt.MenuItem;
import java.awt.Panel;
import persistenceexample4.Constants;
import persistenceexample4.datafactory.ReadWriteEntities;
import persistenceexample4.page.CenterPage;

public class PersistenceExample
extends Panel
implements AwtApplication,
Constants {
    public static int idCounter;
    private int filter_index;
    private String filter_string;
    private int sort_index;
    private boolean sort_ascending;
    private String buttontext;
    private String buttontextQuery;
    private String current_filter_string;
    private static HeaderPanel chp;
    private static FooterPanel cfp;
    private static ControllerPage cmp;

    public String getApplicationName() {
        return "MDK_persistence_q_s_miGUI_AWT";
    }

    public Panel getRootPanel() {
        return this;
    }

    public void actionMenuItem(MenuItem selectedItem) {
    }

    public void initApplication() {
        idCounter = 0;
        ReadWriteEntities.setupPersistenceRuntime();
        ReadWriteEntities.writeExampleEntries();
        this.setFilterOff();
        this.sort_index = 0;
        this.sort_ascending = true;
        Utilities.setALogger((AbstractLogging)AppLog.getInstance((String)"MDK_persistence_q_s_miGUI_AWT"));
    }

    public void activateApplication() {
        this.setLayout(new BorderLayout());
        chp = new HeaderPanel(ComponentConstants.getImage("milogo.gif"));
        chp.setWelcomeText("MDK");
        cfp = new FooterPanel("Peristence API");
        cfp.setPlaceInfo("Car inventory");
        cmp = new CenterPage(this.filter_index, this.sort_index, this.sort_ascending, this.filter_string, this, cfp);
        this.add("North", chp);
        this.add("South", cfp);
        this.add("Center", cmp);
        cmp.updateCurrentPage();
    }

    public void deactivateApplication() {
        cmp.commit();
    }

    public void destroyApplication() {
        cmp.commit();
    }

    private void setFilterOff() {
        this.filter_index = -1;
        this.buttontextQuery = "Set Filter";
        this.current_filter_string = "No Filter";
    }

    private void setFilterOn(int Index, String filter_string) {
        this.buttontextQuery = "Reset Filter";
        this.current_filter_string = "Filter: " + filter_string;
        this.filter_index = 0;
    }

    static {
        chp = null;
        cfp = null;
        cmp = null;
    }
}

