/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.util;

import com.sap.ip.me.api.logging.AbstractLogging;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class Utilities {
    public static AbstractLogging aLogger;
    private static SimpleDateFormat sdf;
    public static final String _ISO8859 = "ISO-8859-1";
    public static final String _SHIFTJIS = "Shift_JIS";
    public static final String _UTF8 = "UTF8";
    public static final String _UTF16 = "UTF16";
    public static final String _EUC = "EUC";
    public static final int n_UTF16 = 3;
    public static final int n_EUC = 4;
    public static final int n_ISO8859 = 0;
    public static final int n_UTF8 = 2;
    public static final int n_SJIS = 1;
    private static int ENCTYPE;
    public static boolean DBCS_ENC;
    private static int _startIndex;
    private static int _listCount;
    private static int _recCount;
    private static String LD_DECIMAL_PT;
    private static String FT_DATEMODIFIED;
    private static String FT_TEMPKEY;

    public static boolean isNumber(String t) {
        if (t == null || t.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(t);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static AbstractLogging getALogger() {
        return aLogger;
    }

    public static void setALogger(AbstractLogging logging) {
        aLogger = logging;
    }

    public static void print(String output) {
        aLogger.log(70, output);
    }

    public static void setEncType(int enc) {
        ENCTYPE = enc;
    }

    public static int getEncType() {
        return ENCTYPE;
    }

    public static boolean toggleDBCSEncoding(boolean val) {
        DBCS_ENC = val;
        return DBCS_ENC;
    }

    public static String encodeString(String inString) {
        if (inString == null) {
            return null;
        }
        if (!DBCS_ENC) {
            return inString;
        }
        String res = "";
        switch (ENCTYPE) {
            case 1: {
                res = Utilities.encodeString(inString, _ISO8859, _SHIFTJIS);
                break;
            }
            case 2: {
                res = Utilities.encodeString(inString, _ISO8859, _UTF8);
                break;
            }
            case 0: {
                res = Utilities.encodeString(inString, _ISO8859, _ISO8859);
                break;
            }
            case 4: {
                res = Utilities.encodeString(inString, _ISO8859, _EUC);
                break;
            }
            default: {
                res = inString;
            }
        }
        return res;
    }

    private static String encodeString(String inString, String fromEnc, String toEnc) {
        if (inString == null) {
            return null;
        }
        String tString = "";
        try {
            tString = fromEnc == null ? new String(inString.getBytes(), toEnc).trim() : new String(inString.getBytes(fromEnc), toEnc).trim();
        }
        catch (UnsupportedEncodingException uee) {
            Utilities.print("CU: UnsupportedEncoding! (" + toEnc + ")");
        }
        return tString;
    }

    public static String encodeString(String inString, String toEnc) {
        return Utilities.encodeString(inString, null, toEnc);
    }

    public static String byteToString(byte[] inByte, String enc) {
        String tString = "";
        try {
            tString = new String(inByte, enc).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return tString;
    }

    public static String byteToString(byte[] inByte) {
        return Utilities.byteToString(inByte, Utilities.getEncodingType());
    }

    public static String byteToString(byte[] inByte, int from, int len) {
        String tString = "";
        try {
            tString = new String(inByte, from, len, Utilities.getEncodingType()).trim();
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        return tString;
    }

    public static String encodeToDefaultEnc(String inString) {
        return Utilities.encodeString(inString, null, Utilities.getEncodingType());
    }

    public static String getEncodingType() {
        String enc = "";
        switch (ENCTYPE) {
            case 1: {
                enc = _SHIFTJIS;
                break;
            }
            case 2: {
                enc = _UTF8;
                break;
            }
            case 0: {
                enc = _ISO8859;
                break;
            }
            case 4: {
                enc = _EUC;
                break;
            }
            default: {
                enc = _SHIFTJIS;
            }
        }
        return enc;
    }

    public static int getStartIndex() {
        return _startIndex;
    }

    public static void setStartIndex(int nIndex) {
        _startIndex = nIndex;
    }

    public static void set_recCount(int i) {
        _recCount = i;
    }

    public static int getListCount() {
        if (_listCount > _recCount - _startIndex) {
            return _recCount - _startIndex;
        }
        return _listCount;
    }

    public static int getPageLineCount() {
        return _listCount;
    }

    public static void setListCount(int nCount) {
        _listCount = nCount;
    }

    public static int getPageCount() {
        if (_recCount == 0) {
            return 1;
        }
        return (_recCount - 1 + _listCount) / _listCount;
    }

    public static int getCurrentPageNumber() {
        return _startIndex / _listCount + 1;
    }

    public static void setTopPageIndex() {
        _startIndex = 0;
    }

    public static void setPrevPageIndex() {
        if (_startIndex >= _listCount) {
            _startIndex -= _listCount;
        }
    }

    public static void setNextPageIndex() {
        _startIndex += _listCount;
    }

    public static void setLastPageIndex() {
        _startIndex = (_recCount - 1) / _listCount * _listCount;
    }

    public static void setDesiredPage(int pgNum) {
        _startIndex = (pgNum - 1) * _listCount;
    }

    public static boolean isTopPrevPagesAvailable() {
        return _startIndex >= _listCount;
    }

    public static boolean isNextLastPageAvailable() {
        return _recCount > _listCount + _startIndex;
    }

    public static String getDecimalPointCharacter() {
        return LD_DECIMAL_PT;
    }

    public static void setDecimalPointCharacter(String decChar) {
        LD_DECIMAL_PT = decChar;
    }

    public static String getCurrentDateTime() {
        sdf = new SimpleDateFormat(FT_DATEMODIFIED);
        return sdf.format(new Date());
    }

    public static String getLocalTempKey() {
        sdf = new SimpleDateFormat(FT_TEMPKEY);
        return sdf.format(new Date());
    }

    public static String createLeftFixedString(String inString, char prefix, int length) {
        return Utilities.fixedString(inString, prefix, length, true);
    }

    public static String createRightFixedString(String inString, char prefix, int length) {
        return Utilities.fixedString(inString, prefix, length, false);
    }

    public static String[] splitString(String inString, String del) {
        StringTokenizer st = new StringTokenizer(inString, del);
        String[] res = new String[st.countTokens() + 1];
        int i = 0;
        while (i <= st.countTokens()) {
            res[i] = st.nextToken();
            ++i;
        }
        return res;
    }

    private static String fixedString(String in, char pre, int len, boolean leftPos) {
        if (in == null) {
            return "";
        }
        if (in.getBytes().length >= len) {
            return in.substring(0, len);
        }
        StringBuffer sb = new StringBuffer(in);
        int i = in.getBytes().length;
        while (i < len) {
            if (leftPos) {
                sb.insert(0, pre);
            } else {
                sb.append(pre);
            }
            ++i;
        }
        return sb.toString();
    }

    public static Date stringToDate(String strDate) {
        Date d = null;
        if (strDate.length() == 8) {
            try {
                int yyyy = Integer.parseInt(strDate.substring(0, 4));
                int mm = Integer.parseInt(strDate.substring(4, 6));
                int dd = Integer.parseInt(strDate.substring(6, 8));
                Calendar cal = Calendar.getInstance();
                cal.set(yyyy, mm, dd);
                d = cal.getTime();
            }
            catch (NumberFormatException nfe) {
                Utilities.print("Invalid dateString:" + strDate);
            }
        }
        return d;
    }

    public static Calendar stringToCalendar(String strDate) {
        Calendar c = null;
        if (strDate.length() == 8) {
            try {
                int yyyy = Integer.parseInt(strDate.substring(0, 4));
                int mm = Integer.parseInt(strDate.substring(4, 6));
                if (mm > 0) {
                    --mm;
                }
                int dd = Integer.parseInt(strDate.substring(6, 8));
                Calendar cal = Calendar.getInstance();
                cal.set(yyyy, mm, dd);
                c = cal;
                Utilities.print("stringToCalendar: " + strDate + " ->" + c.getTime().toString());
            }
            catch (NumberFormatException nfe) {
                Utilities.print("Invalid dateString:" + strDate);
            }
        }
        return c;
    }

    static {
        sdf = null;
        ENCTYPE = 0;
        DBCS_ENC = false;
        _startIndex = 0;
        _listCount = 5;
        _recCount = 0;
        LD_DECIMAL_PT = ".";
        FT_DATEMODIFIED = "yyyy.MM.dd hh:mm:ss";
        FT_TEMPKEY = "MMddhhmmss";
    }
}

