/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.page;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListHeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.BasicPage;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.RecordNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

public abstract class DetailPage
extends BasicPage {
    public LinkButton homeLink = null;
    private String[] detailTargets = new String[]{"firstRecord", "prevRecord", "nextRecord", "lastRecord"};
    private LinkButton listLink = null;
    private LinkButton deleteLink = null;
    private ListPanel listTable = null;
    private ListHeaderPanel listHeaderTable = null;
    private RecordNavPanel recordNav = null;
    protected MouseListener actionHandler = null;
    protected static Image imgDel = ComponentConstants.getImage("ntrash.gif");
    protected static Image imgList = ComponentConstants.getImage("ncustlist.gif");
    protected static Image imgTop = ComponentConstants.getImage("jgtop.gif");

    private DetailPage() {
    }

    public DetailPage(MouseListener actionHandler) {
        this.actionHandler = actionHandler;
        this.homeLink = new LinkButton("Back...");
        this.homeLink.setTargetPage("DetailList");
        this.homeLink.setTargetHandler("showHome");
        this.homeLink.addMouseListener(this.actionHandler);
        TopNavLink topLink = new TopNavLink();
        topLink.setLinks(new LinkButton[]{this.homeLink});
        topLink.addMouseListener(actionHandler);
        this.setTopLink(topLink);
        this.setTopLinkCommand("DetailList", "showHome");
        this.deleteLink = new LinkButton(imgDel);
        this.deleteLink.addMouseListener(actionHandler);
        this.listLink = new LinkButton(imgList);
        this.listLink.addMouseListener(actionHandler);
        this.setActionBarLinks(new LinkButton[]{this.deleteLink});
        this.listTable = new ListPanel();
        this.setBody(this.listTable);
        this.listHeaderTable = new ListHeaderPanel();
        this.setBody(this.listHeaderTable);
        this.recordNav = new RecordNavPanel();
        this.recordNav.setCommonActionHandler(actionHandler);
        this.recordNav.setTargetHandler(this.detailTargets);
        this.setFooterNavBar(this.recordNav);
    }

    public void setListActionAttributes(String targetPage, String targetHandler) {
        this.listLink.setTargetPage(targetPage);
        this.listLink.setTargetHandler(targetHandler);
    }

    public void setDeleteActionAttributes(String targetPage, String targetHandler) {
        this.deleteLink.setTargetPage(targetPage);
        this.deleteLink.setTargetHandler(targetHandler);
    }

    public void setDeleteActionButtonImage(Image icon) {
        this.deleteLink.setImage(icon);
    }

    public void setRecordNavHandlers(String[] handlerNames) {
        this.recordNav.setTargetHandler(handlerNames);
    }

    public void setTopLinkCommand(String targetPage, String handlerName) {
        this.homeLink.setTargetPage(targetPage);
        this.homeLink.setTargetHandler(handlerName);
    }

    public void setFooterMessage(String msgText) {
        this.recordNav.setMessageText(msgText);
    }

    public void setList(TextLabel[] label, TextLabel[] fields) {
        this.listTable.removeAll();
        int count = label.length < fields.length ? label.length : fields.length;
        int i = 0;
        while (i < count) {
            this.listTable.appendLine((Component)label[i], fields[i]);
            ++i;
        }
        this.listTable.validate();
    }

    public abstract void initializePage();

    public abstract void destroyPage();

    public abstract void updatePage();
}

