/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;

public class BorderedPanel
extends Panel {
    private boolean bDrawBorder = true;
    private boolean bDrawBackGround = true;
    protected Color bgColor = ComponentConstants.menuBodyBGColor;
    private String lineMask = "TBLR";

    public BorderedPanel() {
    }

    public BorderedPanel(LayoutManager lm) {
        super(lm);
    }

    public void setBackgroundColor(Color c) {
        this.bgColor = c;
    }

    public void enableBGDraw(boolean st) {
        this.bDrawBackGround = st;
    }

    public void enableBorderDraw(boolean st) {
        this.bDrawBorder = st;
    }

    public void setBorderMask(String mask) {
        this.lineMask = mask;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.bDrawBackGround) {
            g.setColor(this.bgColor);
            g.fillRect(1, 1, this.getSize().width, this.getSize().height);
        }
        if (this.bDrawBorder) {
            g.setColor(Color.gray);
            if (this.lineMask.indexOf("T") > -1) {
                this.drawTopLine(g);
            }
            if (this.lineMask.indexOf("B") > -1) {
                this.drawBottomLine(g);
            }
            if (this.lineMask.indexOf("R") > -1) {
                this.drawRightLine(g);
            }
            if (this.lineMask.indexOf("L") > -1) {
                this.drawLeftLine(g);
            }
        }
        super.paint(g);
    }

    private void drawTopLine(Graphics g) {
        g.drawLine(0, 0, this.getSize().width, 0);
    }

    private void drawBottomLine(Graphics g) {
        g.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
    }

    private void drawLeftLine(Graphics g) {
        g.drawLine(0, 0, 0, this.getSize().height - 1);
    }

    private void drawRightLine(Graphics g) {
        g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height);
    }
}

