# ===================================================================
# AWK Filter for conversion of Sherlok.log files to CSV format
#
# Source are all lines from the input with given structure
#          GC|NrGC=nn|TimeStamp=nnn|Objects=nnn|Space=nnn|Total=nnn
# elem[n]   1       2             3           4         5         6              
#
# ===================================================================


BEGIN {
    
    SHERLOK_SEPAR = "|";
    CSV_SEPAR      = ";";
    CSV_LINE_SEPAR = "\n";
    

    // Include Table header 
    printf("%s%s%s%s%s%s%s%s", 
           "GCNr", 
           CSV_SEPAR,
           "#objs",
           CSV_SEPAR,
           "mem used (bytes)",
           CSV_SEPAR,
           "total space (bytes)",
           CSV_LINE_SEPAR );
}


/^GC/ {

    split($0,elem,SHERLOK_SEPAR);
    
    // Include Table line
    printf("%s%s%s%s%s%s%s%s", 
           StripInput(elem[2]),
           CSV_SEPAR,
           StripInput(elem[4]),
           CSV_SEPAR,
           StripInput(elem[5]),
           CSV_SEPAR,
           StripInput(elem[6]),
           CSV_LINE_SEPAR );
           
}    
    

function StripInput(s){
  result = s;
  sub(/[^=]*=/,"",result); 
  return result;
}
