/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.TopStruct;

class TopList {
    protected TopStruct[] topList;
    private Object[] resultList;
    private long minValue;
    private long minValueOrig;
    private int size;
    private int nextEntry;

    protected TopList(int nrOfElem, long minValueParam) {
        this.topList = new TopStruct[nrOfElem];
        this.size = nrOfElem;
        this.nextEntry = 0;
        this.minValueOrig = this.minValue = minValueParam - 1L;
        this.resultList = new Object[nrOfElem + 1];
    }

    protected TopStruct insertElem(TopStruct topStruct) {
        long value = topStruct.value;
        TopStruct returnElem = null;
        int insertIndex = this.nextEntry;
        if (value > this.minValue) {
            int rank = this.nextEntry + 1;
            int i = 0;
            while (i < this.nextEntry) {
                if (this.topList[i].rank != 0) {
                    if (value > this.topList[i].value) {
                        if (rank > this.topList[i].rank) {
                            rank = this.topList[i].rank;
                        }
                        if (this.topList[i].rank == this.size - 1) {
                            this.minValue = this.topList[i].value;
                        }
                        if (this.topList[i].rank == this.size) {
                            insertIndex = i;
                        }
                        ++this.topList[i].rank;
                    }
                } else if (insertIndex == this.nextEntry) {
                    insertIndex = i;
                }
                ++i;
            }
            returnElem = new TopStruct();
            if (this.nextEntry == this.size && this.topList[insertIndex].obj != null) {
                returnElem.obj = this.topList[insertIndex].obj;
            } else {
                returnElem.obj = null;
                if (insertIndex == this.nextEntry) {
                    this.topList[insertIndex] = new TopStruct();
                    ++this.nextEntry;
                }
            }
            this.topList[insertIndex].rank = rank;
            this.topList[insertIndex].value = value;
            this.topList[insertIndex].objName = topStruct.objName;
            this.topList[insertIndex].obj = topStruct.obj;
            if (rank == this.size) {
                this.minValue = value;
            }
        }
        return returnElem;
    }

    protected Object[] searchElems(String namePattern, int maxResults) {
        boolean wildcard;
        String namePrefix = null;
        int foundResults = 0;
        boolean noRestrict = namePattern == null || namePattern.compareTo("*") == 0;
        boolean bl = wildcard = namePattern != null && namePattern.endsWith("*");
        if (wildcard && !noRestrict) {
            namePrefix = namePattern.substring(0, namePattern.length() - 1);
        }
        int i = 0;
        while (i < this.nextEntry) {
            if (this.topList[i].obj != null) {
                if (noRestrict) {
                    ++foundResults;
                    this.resultList[this.topList[i].rank] = this.topList[i].obj;
                } else if (wildcard) {
                    if (this.topList[i].objName.startsWith(namePrefix)) {
                        ++foundResults;
                        this.resultList[this.topList[i].rank] = this.topList[i].obj;
                    }
                } else if (this.topList[i].objName.compareTo(namePattern) == 0) {
                    ++foundResults;
                    this.resultList[this.topList[i].rank] = this.topList[i].obj;
                }
            }
            ++i;
        }
        if (foundResults > maxResults) {
            foundResults = maxResults;
        }
        if (foundResults <= 0) {
            return null;
        }
        Object[] returnObjs = new Object[foundResults];
        int i2 = 1;
        int j = 0;
        while (i2 <= this.nextEntry) {
            if (this.resultList[i2] != null) {
                if (j < foundResults) {
                    returnObjs[j] = this.resultList[i2];
                    ++j;
                }
                this.resultList[i2] = null;
            }
            ++i2;
        }
        return returnObjs;
    }

    protected void resetAll() {
        int i = 0;
        while (i < this.nextEntry) {
            this.topList[i].obj = null;
            this.topList[i] = null;
            ++i;
        }
        this.nextEntry = 0;
        this.minValue = this.minValueOrig;
    }

    protected TopStruct getElem(int getIndex) {
        if (getIndex < this.nextEntry && getIndex >= 0) {
            return this.topList[getIndex];
        }
        return null;
    }
}

