/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ConfMonitor;

class MonitorConsumer {
    protected static MonitorConsumer firstConsumer;
    protected static MonitorConsumer lastConsumer;
    protected int consumerSwitch;
    protected String name;
    protected String className;
    protected int restart;
    protected long lastStart;
    protected MonitorConsumer succ;

    protected MonitorConsumer(String consName) {
        this(0, consName, null, 0);
    }

    protected MonitorConsumer(int consSwitch, String consName, String consClass, int consRestart) {
        this.consumerSwitch = consSwitch;
        this.name = consName;
        this.className = consClass;
        this.restart = consRestart;
    }

    protected boolean checkAndStart(long currentTS) {
        boolean consumerStarted = false;
        if (this.consumerSwitch == 1 && this.className != null && (this.lastStart == 0L || this.restart > 0 && this.lastStart + (long)(this.restart * 1000) < currentTS)) {
            consumerStarted = true;
            this.lastStart = currentTS;
            try {
                Class<?> consumerClass = Class.forName(this.className);
                Thread consumerThread = new Thread((Runnable)consumerClass.newInstance(), ConfMonitor.threadPrefix + this.name);
                consumerThread.start();
            }
            catch (Exception exp) {
                consumerStarted = false;
            }
        }
        return consumerStarted;
    }
}

