/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.bc.krn.perf.PerfTimes;
import com.sap.util.monitor.jarm.IJarmDataRecipient;
import com.sap.util.monitor.jarm.JarmRegistration;
import com.sap.util.monitor.jarm.MonitorConsumer;
import com.sap.util.monitor.jarm.MonitorException;
import com.sap.util.monitor.jarm.RmiMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.AccessControlException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ConfMonitor {
    public static final long UNDEFTIME = -1L;
    public static final int UNDEFDATA = -1;
    public static final String UNDEFNAME = "nameNotDefined";
    public static final String NAMENOTSET = " ";
    public static final int NUMBERNOTSET = 0;
    public static final String NOCOMPACTIVE = "noComponentActive";
    public static final int TOPGROSSTIME = 0;
    public static final int TOPNETTIME = 1;
    public static final int TOPOUTDATA = 2;
    public static final int TOPCALLNUM = 3;
    public static final int TOPGROSSCPUTIME = 4;
    public static final int TOPNETCPUTIME = 5;
    public static final int RESETALL = 0;
    public static final int RESETREQUESTS = 1;
    public static final int RESETCOMPONENTS = 2;
    public static final int REQOK = 0;
    public static final int REQCOMPNOTCLOSED = 1;
    public static final int REQCOMPTOOMANYLOW = 2;
    public static final int REQCOMPTOOMANYHIGH = 3;
    public static final int REQOVERVIEWNONE = 0;
    public static final int REQOVERVIEWALL = 1;
    public static final String MONITORPREFIX = "jarm/";
    public static final String CONSUMERPREFIX = "jarm/consumer/";
    public static final String CONSUMERSWITCH = "/switch";
    public static final String CONSUMERCLASS = "/class";
    public static final String CONSUMERRESTART = "/restart";
    public static final String KEYMONITOR = "jarm/switch";
    public static final String KEYMAXREQCOMPLOW = "jarm/maxreqcomplow";
    public static final String KEYMAXREQCOMPHIGH = "jarm/maxreqcomphigh";
    public static final String KEYVERSION = "jarm/version";
    public static final String TRACESWITCH = "jarm/tracemode/switch";
    public static final String RMIPREFIX = "jarm/rmi/";
    public static final String RMISWITCH = "jarm/rmi/switch";
    public static final String RMISTARTREGISTRY = "jarm/rmi/startregistry";
    public static final String RMIPORT = "jarm/rmi/port";
    private static final String RMISTARTSECMAN = "jarm/rmi/startsecman";
    private static final String KEYINSTRCHECK = "jarm/instrumentation/check";
    private static final String KEYPARTNEREXCL = "jarm/partner/exclude";
    public static final String VALUEON = "on";
    public static final String VALUEOFF = "off";
    public static final String VALUEALL = "all";
    public static final String VALUENONE = "none";
    protected static final int SWITCHOFF = 0;
    protected static final int SWITCHON = 1;
    protected static final int STATESTARTED = 1;
    protected static final int STATEENDED = 2;
    protected static final int STATECONDENSED = 3;
    protected static final int STATEREMOVE = 4;
    protected static final int STARTCOMPONENT = 0;
    protected static final int ENDCOMPONENT = 1;
    protected static final int STARTREQUEST = 2;
    protected static final int ENDREQUEST = 3;
    private static final int THREADNUM = 200;
    private static final int NRTOPS = 100;
    private static final int MAXCOMPRET = 5000;
    private static final int FREECOMPNUM = 50;
    private static final int MAXFREECOMPNUM = 200;
    private static final int CONDENSESLEEP = 10000;
    private static final int CONDENSEPAUSESLEEP = 1000;
    private static final int CONDENSESTART = 60000;
    private static final int CONDENSECOMPLIMIT = 25000;
    private static final int MAXREQCOMPLOW = 500;
    private static final int MAXREQCOMPHIGH = 600;
    private static final String DEFAULTPROFILE = "profile" + File.separator + "jarm.properties";
    private static final int RMISTATUSINIT = 0;
    private static final int RMISTATUSACTIVE = 1;
    private static final int RMISTATUSSUSPEND = 2;
    private static final int RMISTATUSERROR = 3;
    private static final String PARAMETER = "Parameter: ";
    private static final String WRONGPARAMETER = "Wrong parameter: ";
    private static final String WRONGVALUE = " Wrong value: ";
    private static final String VERSION = "2.1.0";
    protected static final int RECIPFIXEDVARS = 3;
    private static final int RECIPINITVECTOR = 5;
    private static final String LOGFILE = "jarm.log";
    public static int initNrTops = 100;
    public static int initMaxCompRet = 5000;
    public static RmiMonitor rmiObject;
    protected static int initMonitorSwitch;
    protected static int initTraceSwitch;
    protected static int initPartnerExcl;
    protected static int initThreadNum;
    protected static int initFreeCompNum;
    protected static int initMaxFreeCompNum;
    protected static int initCondenseSleep;
    protected static int initCondensePauseSleep;
    protected static int initCondenseStart;
    protected static int initCondenseCompLimit;
    protected static int initMaxReqCompLow;
    protected static int initMaxReqCompHigh;
    protected static int initRmiSwitch;
    protected static int initRmiStartRegistry;
    protected static int initRmiPort;
    private static int initRmiStartSecMan;
    protected static int initInstrCheck;
    protected static String threadPrefix;
    protected static String threadCondenseSuffix;
    protected static boolean availCpuTime;
    protected static boolean availElapsedTimeUs;
    protected static boolean initTimingReady;
    private static boolean profileRead;
    private static int newRmiSwitch;
    private static int newRmiStartRegistry;
    private static int newRmiPort;
    private static int newRmiStartSecMan;
    private static int rmiStatus;
    private static int recipCount;
    private static IJarmDataRecipient recip_1;
    private static IJarmDataRecipient recip_2;
    private static IJarmDataRecipient recip_3;
    private static Vector recipVector;
    private static Object recipLock;
    private static boolean logOpened;
    private static PrintWriter out;
    private static Object lockLog;
    private static PerfTimes perfTimes;

    public static void setMonitorOn() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        initMonitorSwitch = 1;
    }

    public static void setMonitorOff() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        initMonitorSwitch = 0;
    }

    public static boolean getMonitorSwitch() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        return initMonitorSwitch == 1;
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        props.setProperty(KEYMONITOR, initMonitorSwitch == 1 ? VALUEON : VALUEOFF);
        props.setProperty(TRACESWITCH, initTraceSwitch == 1 ? VALUEON : VALUEOFF);
        props.setProperty(KEYPARTNEREXCL, initPartnerExcl == 0 ? VALUENONE : VALUEALL);
        props.setProperty(KEYVERSION, VERSION);
        props.setProperty(KEYMAXREQCOMPLOW, Integer.toString(initMaxReqCompLow));
        props.setProperty(KEYMAXREQCOMPHIGH, Integer.toString(initMaxReqCompHigh));
        MonitorConsumer nextConsumer = MonitorConsumer.firstConsumer;
        while (nextConsumer != null) {
            props.setProperty(CONSUMERPREFIX + nextConsumer.name + CONSUMERSWITCH, nextConsumer.consumerSwitch == 1 ? VALUEON : VALUEOFF);
            props.setProperty(CONSUMERPREFIX + nextConsumer.name + CONSUMERCLASS, nextConsumer.className);
            props.setProperty(CONSUMERPREFIX + nextConsumer.name + CONSUMERRESTART, Integer.toString(nextConsumer.restart));
            nextConsumer = nextConsumer.succ;
        }
        props.setProperty(RMISWITCH, initRmiSwitch == 1 ? VALUEON : VALUEOFF);
        props.setProperty(RMISTARTREGISTRY, initRmiStartRegistry == 1 ? VALUEON : VALUEOFF);
        props.setProperty(RMIPORT, Integer.toString(initRmiPort));
        return props;
    }

    public static synchronized void setProperties(Properties props) throws MonitorException {
        String wrongKey = null;
        String wrongValue = null;
        int tmpInitMaxReqCompLow = initMaxReqCompLow;
        int tmpInitMaxReqCompHigh = initMaxReqCompHigh;
        boolean initMaxReqCompLowSet = false;
        boolean initMaxReqCompHighSet = false;
        boolean rmiError = false;
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        if (props == null) {
            return;
        }
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            int keyLength = key.length();
            String value = props.getProperty(key);
            try {
                if (keyLength < MONITORPREFIX.length() || MONITORPREFIX.compareToIgnoreCase(key.substring(0, MONITORPREFIX.length())) != 0) continue;
                if (key.compareToIgnoreCase(KEYMONITOR) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        initMonitorSwitch = 1;
                        continue;
                    }
                    if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        initMonitorSwitch = 0;
                        continue;
                    }
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    wrongValue = value;
                    continue;
                }
                if (key.compareToIgnoreCase(TRACESWITCH) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        initTraceSwitch = 1;
                        continue;
                    }
                    if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        initTraceSwitch = 0;
                        continue;
                    }
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    wrongValue = value;
                    continue;
                }
                if (key.compareToIgnoreCase(KEYPARTNEREXCL) == 0) {
                    if (value.compareToIgnoreCase(VALUENONE) == 0) {
                        initPartnerExcl = 0;
                    } else if (value.compareToIgnoreCase(VALUEALL) == 0) {
                        initPartnerExcl = 1;
                    } else if (wrongKey == null) {
                        wrongKey = key;
                        wrongValue = value;
                        continue;
                    }
                    JarmRegistration.adjustPartners(initPartnerExcl);
                    continue;
                }
                if (key.compareToIgnoreCase(KEYMAXREQCOMPLOW) == 0) {
                    block61: {
                        try {
                            tmpInitMaxReqCompLow = Integer.decode(value);
                        }
                        catch (NumberFormatException exc) {
                            if (wrongKey != null) break block61;
                            wrongKey = key;
                            wrongValue = value;
                        }
                    }
                    initMaxReqCompLowSet = true;
                    continue;
                }
                if (key.compareToIgnoreCase(KEYMAXREQCOMPHIGH) == 0) {
                    block62: {
                        try {
                            tmpInitMaxReqCompHigh = Integer.decode(value);
                        }
                        catch (NumberFormatException exc) {
                            if (wrongKey != null) break block62;
                            wrongKey = key;
                            wrongValue = value;
                        }
                    }
                    initMaxReqCompHighSet = true;
                    continue;
                }
                if (key.compareToIgnoreCase(RMISWITCH) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        newRmiSwitch = 1;
                        continue;
                    }
                    if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        newRmiSwitch = 0;
                        continue;
                    }
                    rmiError = true;
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    wrongValue = value;
                    continue;
                }
                if (key.compareToIgnoreCase(RMISTARTREGISTRY) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        newRmiStartRegistry = 1;
                    } else if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        newRmiStartRegistry = 0;
                    } else {
                        rmiError = true;
                        if (wrongKey == null) {
                            wrongKey = key;
                            wrongValue = value;
                        }
                    }
                    if (rmiStatus == 0 || newRmiStartRegistry == initRmiStartRegistry) continue;
                    rmiError = true;
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    continue;
                }
                if (key.compareToIgnoreCase(RMIPORT) == 0) {
                    block63: {
                        try {
                            newRmiPort = Integer.decode(value);
                        }
                        catch (NumberFormatException exc) {
                            rmiError = true;
                            if (wrongKey != null) break block63;
                            wrongKey = key;
                            wrongValue = value;
                        }
                    }
                    if (rmiStatus == 0 || newRmiPort == initRmiPort) continue;
                    rmiError = true;
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    continue;
                }
                if (key.compareToIgnoreCase(RMISTARTSECMAN) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        newRmiStartSecMan = 1;
                    } else if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        newRmiStartSecMan = 0;
                    } else {
                        rmiError = true;
                        if (wrongKey == null) {
                            wrongKey = key;
                            wrongValue = value;
                        }
                    }
                    if (rmiStatus == 0 || newRmiStartSecMan == initRmiStartSecMan) continue;
                    rmiError = true;
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    continue;
                }
                if (key.compareToIgnoreCase(KEYINSTRCHECK) == 0) {
                    if (value.compareToIgnoreCase(VALUEON) == 0) {
                        initInstrCheck = 1;
                        ConfMonitor.logInit();
                        continue;
                    }
                    if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                        initInstrCheck = 0;
                        continue;
                    }
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    wrongValue = value;
                    continue;
                }
                if (keyLength >= CONSUMERPREFIX.length() && CONSUMERPREFIX.compareToIgnoreCase(key.substring(0, CONSUMERPREFIX.length())) == 0) {
                    MonitorConsumer consumer;
                    if (keyLength >= CONSUMERSWITCH.length() && CONSUMERSWITCH.compareToIgnoreCase(key.substring(keyLength - CONSUMERSWITCH.length())) == 0) {
                        consumer = ConfMonitor.getConsumer(key, CONSUMERSWITCH);
                        if (value.compareToIgnoreCase(VALUEON) == 0) {
                            consumer.consumerSwitch = 1;
                            continue;
                        }
                        if (value.compareToIgnoreCase(VALUEOFF) == 0) {
                            consumer.consumerSwitch = 0;
                            continue;
                        }
                        if (wrongKey != null) continue;
                        wrongKey = key;
                        wrongValue = value;
                        continue;
                    }
                    if (keyLength >= CONSUMERCLASS.length() && CONSUMERCLASS.compareToIgnoreCase(key.substring(keyLength - CONSUMERCLASS.length())) == 0) {
                        consumer = ConfMonitor.getConsumer(key, CONSUMERCLASS);
                        consumer.className = value;
                        continue;
                    }
                    if (keyLength >= CONSUMERRESTART.length() && CONSUMERRESTART.compareToIgnoreCase(key.substring(keyLength - CONSUMERRESTART.length())) == 0) {
                        consumer = ConfMonitor.getConsumer(key, CONSUMERRESTART);
                        try {
                            consumer.restart = Integer.decode(value);
                        }
                        catch (NumberFormatException exc) {
                            if (wrongKey != null) continue;
                            wrongKey = key;
                            wrongValue = value;
                        }
                        continue;
                    }
                    if (wrongKey != null) continue;
                    wrongKey = key;
                    continue;
                }
                if (wrongKey != null) continue;
                wrongKey = key;
            }
            catch (IndexOutOfBoundsException exc) {
                if (wrongKey != null) continue;
                wrongKey = key;
            }
        }
        if (initMaxReqCompLowSet || initMaxReqCompHighSet) {
            if (tmpInitMaxReqCompHigh < tmpInitMaxReqCompLow) {
                if (wrongKey == null) {
                    if (initMaxReqCompLowSet) {
                        wrongKey = KEYMAXREQCOMPLOW;
                        wrongValue = Integer.toString(tmpInitMaxReqCompLow);
                    } else {
                        wrongKey = KEYMAXREQCOMPHIGH;
                        wrongValue = Integer.toString(tmpInitMaxReqCompHigh);
                    }
                }
            } else {
                initMaxReqCompLow = tmpInitMaxReqCompLow;
                initMaxReqCompHigh = tmpInitMaxReqCompHigh;
            }
        }
        if (rmiError) {
            newRmiSwitch = initRmiSwitch;
        }
        ConfMonitor.initRmi();
        if (wrongKey != null) {
            if (wrongValue != null) {
                throw new MonitorException(PARAMETER + wrongKey + WRONGVALUE + wrongValue);
            }
            throw new MonitorException(WRONGPARAMETER + wrongKey);
        }
    }

    public static boolean isCpuMeasured() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        return availCpuTime;
    }

    public static boolean registerDataRecipient(IJarmDataRecipient dataRecip) {
        boolean noError = true;
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        Object object = recipLock;
        synchronized (object) {
            switch (recipCount) {
                case 0: {
                    recip_1 = dataRecip;
                    break;
                }
                case 1: {
                    if (recip_1 != dataRecip) {
                        recip_2 = dataRecip;
                        break;
                    }
                    noError = false;
                    break;
                }
                case 2: {
                    if (recip_1 != dataRecip && recip_2 != dataRecip) {
                        recip_3 = dataRecip;
                        break;
                    }
                    noError = false;
                    break;
                }
                default: {
                    if (recip_1 != dataRecip && recip_2 != dataRecip && recip_3 != dataRecip) {
                        int i = 3;
                        int j = 0;
                        while (i < recipCount) {
                            if ((IJarmDataRecipient)recipVector.elementAt(j) == dataRecip) {
                                noError = false;
                                break;
                            }
                            ++i;
                            ++j;
                        }
                        if (!noError) break;
                        if (recipVector == null) {
                            recipVector = new Vector(5);
                        }
                        recipVector.addElement(dataRecip);
                        break;
                    }
                    noError = false;
                }
            }
            if (noError) {
                ++recipCount;
            }
        }
        return noError;
    }

    public static boolean deRegisterDataRecipient(IJarmDataRecipient dataRecip) {
        boolean found = false;
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        Object object = recipLock;
        synchronized (object) {
            if (recipCount > 0) {
                if (recip_1 == dataRecip) {
                    found = true;
                    recip_1 = recip_2;
                    recip_2 = recip_3;
                } else if (recipCount > 1 && recip_2 == dataRecip) {
                    found = true;
                    recip_2 = recip_3;
                } else if (recipCount > 2 && recip_3 == dataRecip) {
                    found = true;
                }
                if (found) {
                    if (recipCount > 3) {
                        recip_3 = (IJarmDataRecipient)recipVector.elementAt(0);
                        recipVector.removeElementAt(0);
                    }
                } else {
                    int i = 0;
                    while (i < recipCount - 3) {
                        if ((IJarmDataRecipient)recipVector.elementAt(i) == dataRecip) {
                            recipVector.removeElementAt(i);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (found) {
                --recipCount;
            }
        }
        return found;
    }

    protected static synchronized void setPropertiesInternal() {
        if (profileRead) {
            return;
        }
        profileRead = true;
        ConfMonitor.initTiming();
        try {
            InputStream inStream = ClassLoader.getSystemResourceAsStream(DEFAULTPROFILE);
            if (inStream != null) {
                Properties props = new Properties();
                props.load(inStream);
                ConfMonitor.setProperties(props);
            }
        }
        catch (IOException exc) {
        }
        catch (MonitorException monitorException) {
            // empty catch block
        }
        try {
            ConfMonitor.initRmi();
        }
        catch (MonitorException monitorException) {
            // empty catch block
        }
    }

    protected static void copyDataRecipients(TaskMonitor task) {
        Object object = recipLock;
        synchronized (object) {
            task.recipCount = recipCount;
            if (recipCount > 0) {
                task.recip_1 = recip_1;
                if (recipCount > 1) {
                    task.recip_2 = recip_2;
                    if (recipCount > 2) {
                        task.recip_3 = recip_3;
                        int i = 3;
                        int j = 0;
                        while (i < recipCount) {
                            if (task.recipVector == null) {
                                task.recipVector = new Vector(5);
                            }
                            task.recipVector.addElement(recipVector.elementAt(j));
                            ++i;
                            ++j;
                        }
                    }
                }
            }
        }
    }

    protected static void logWriteInfo(String outStr) {
        ConfMonitor.logWrite("INFO:  " + outStr);
    }

    protected static void logWriteError(String outStr) {
        ConfMonitor.logWrite("ERROR: " + outStr);
    }

    protected static synchronized void initTiming() {
        boolean error = false;
        if (!initTimingReady) {
            try {
                perfTimes = new PerfTimes();
                availCpuTime = perfTimes.cpuTimePerThread();
                availElapsedTimeUs = true;
            }
            catch (UnsatisfiedLinkError exc) {
                error = true;
            }
            catch (NoClassDefFoundError exc) {
                error = true;
            }
            catch (Exception exc) {
                error = true;
            }
            if (error) {
                availElapsedTimeUs = false;
                availCpuTime = false;
            }
            initTimingReady = true;
        }
    }

    protected static long getCpuTime() {
        if (!initTimingReady) {
            ConfMonitor.initTiming();
        }
        if (availCpuTime) {
            return perfTimes.cpuTimeUs();
        }
        return -1L;
    }

    protected static long getElapsedTime() {
        if (!initTimingReady) {
            ConfMonitor.initTiming();
        }
        if (availElapsedTimeUs) {
            return perfTimes.elapsed();
        }
        return System.currentTimeMillis();
    }

    protected static long getTimeDifference(boolean elapsedTime, long startTime, long endTime) {
        if (!initTimingReady) {
            ConfMonitor.initTiming();
        }
        long result = elapsedTime ? (availElapsedTimeUs ? perfTimes.getDelta2Us(startTime, endTime) / 1000L : endTime - startTime) : (availCpuTime ? perfTimes.getDelta2Us(startTime, endTime) / 1000L : -1L);
        return result;
    }

    private static void logInit() {
        if (logOpened) {
            return;
        }
        File fp = new File(LOGFILE);
        if (fp != null) {
            try {
                fp.createNewFile();
                out = new PrintWriter((Writer)new FileWriter(fp), true);
                ConfMonitor.logWriteInfo("Log file 'jarm.log' opened");
                logOpened = true;
            }
            catch (IOException exc) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private static void logWrite(String outStr) {
        Object object = lockLog;
        synchronized (object) {
            if (out != null) {
                out.print(new Date().toString() + NAMENOTSET);
                out.println(outStr);
            }
        }
    }

    private static MonitorConsumer getConsumer(String key, String consumerSuffix) throws IndexOutOfBoundsException {
        boolean found = false;
        String tmpName = key.substring(CONSUMERPREFIX.length());
        String name = tmpName.substring(0, tmpName.length() - consumerSuffix.length());
        MonitorConsumer nextConsumer = MonitorConsumer.firstConsumer;
        while (!found && nextConsumer != null) {
            found = name.compareToIgnoreCase(nextConsumer.name) == 0;
            if (found) continue;
            nextConsumer = nextConsumer.succ;
        }
        if (!found) {
            nextConsumer = new MonitorConsumer(name);
            if (MonitorConsumer.firstConsumer == null) {
                MonitorConsumer.lastConsumer = MonitorConsumer.firstConsumer = nextConsumer;
            } else {
                MonitorConsumer.lastConsumer.succ = nextConsumer;
                MonitorConsumer.lastConsumer = nextConsumer;
            }
        }
        return nextConsumer;
    }

    private static void initRmi() throws MonitorException {
        switch (rmiStatus) {
            case 0: {
                if (newRmiSwitch == 1) {
                    try {
                        ConfMonitor.startRmi();
                    }
                    catch (MonitorException exc) {
                        ConfMonitor.resetRmiValues();
                        rmiStatus = 3;
                        throw exc;
                    }
                    initRmiSwitch = 1;
                    rmiStatus = 1;
                }
                initRmiStartRegistry = newRmiStartRegistry;
                initRmiStartSecMan = newRmiStartSecMan;
                initRmiPort = newRmiPort;
                break;
            }
            case 1: {
                if (newRmiSwitch != 0) break;
                try {
                    ConfMonitor.stopRmi();
                }
                catch (MonitorException exc) {
                    ConfMonitor.resetRmiValues();
                    rmiStatus = 3;
                    throw exc;
                }
                initRmiSwitch = 0;
                rmiStatus = 2;
                break;
            }
            case 2: {
                if (newRmiSwitch != 1) break;
                try {
                    ConfMonitor.resumeRmi();
                }
                catch (MonitorException exc) {
                    ConfMonitor.resetRmiValues();
                    rmiStatus = 3;
                    throw exc;
                }
                initRmiSwitch = 1;
                rmiStatus = 1;
                break;
            }
            default: {
                ConfMonitor.resetRmiValues();
                throw new MonitorException("RMI: Status Error (is not recoverable)");
            }
        }
        ConfMonitor.resetRmiValues();
    }

    private static void startRmi() throws MonitorException {
        if (newRmiStartSecMan == 1) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (SecurityException exc) {
                throw new MonitorException("RMI: Start of Security Manager failed");
            }
        }
        if (newRmiStartRegistry == 1) {
            try {
                LocateRegistry.createRegistry(newRmiPort);
            }
            catch (RemoteException exc) {
                throw new MonitorException("RMI: Creation of Registry failed; Port = " + Integer.toString(newRmiPort));
            }
        }
        try {
            rmiObject = new RmiMonitor();
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Creation of rmi object failed");
        }
        try {
            Naming.bind("//:" + Integer.toString(newRmiPort) + "/RmiMonitor", rmiObject);
        }
        catch (AlreadyBoundException exc) {
            throw new MonitorException("RMI: Bind object: AlreadyBoundException");
        }
        catch (MalformedURLException exc) {
            throw new MonitorException("RMI: Bind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Bind object: RemoteException");
        }
        catch (AccessControlException exc) {
            throw new MonitorException("RMI: Bind object: AccessControlException");
        }
    }

    private static void stopRmi() throws MonitorException {
        try {
            Naming.unbind("//:" + Integer.toString(initRmiPort) + "/RmiMonitor");
        }
        catch (NotBoundException exc) {
            throw new MonitorException("RMI: Unbind object: NotBoundException");
        }
        catch (MalformedURLException exc) {
            throw new MonitorException("RMI: Unbind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Unbind object: RemoteException");
        }
        catch (AccessControlException exc) {
            throw new MonitorException("RMI: Unbind object: AccessControlException");
        }
        rmiObject = null;
    }

    private static void resumeRmi() throws MonitorException {
        try {
            rmiObject = new RmiMonitor();
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Creation of rmi object failed");
        }
        try {
            Naming.bind("//:" + Integer.toString(initRmiPort) + "/RmiMonitor", rmiObject);
        }
        catch (AlreadyBoundException exc) {
            throw new MonitorException("RMI: Bind object: AlreadyBoundException");
        }
        catch (MalformedURLException exc) {
            throw new MonitorException("RMI: Bind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Bind object: RemoteException");
        }
        catch (AccessControlException exc) {
            throw new MonitorException("RMI: Bind object: AccessControlException");
        }
    }

    private static void resetRmiValues() {
        newRmiSwitch = initRmiSwitch;
        newRmiStartRegistry = initRmiStartRegistry;
        newRmiStartSecMan = initRmiStartSecMan;
        newRmiPort = initRmiPort;
    }

    static {
        initMonitorSwitch = 1;
        initTraceSwitch = 1;
        initPartnerExcl = 0;
        initThreadNum = 200;
        initFreeCompNum = 50;
        initMaxFreeCompNum = 200;
        initCondenseSleep = 10000;
        initCondensePauseSleep = 1000;
        initCondenseStart = 60000;
        initCondenseCompLimit = 25000;
        initMaxReqCompLow = 500;
        initMaxReqCompHigh = 600;
        initRmiSwitch = 0;
        initRmiStartRegistry = 1;
        initRmiPort = 1099;
        initRmiStartSecMan = 0;
        initInstrCheck = 0;
        threadPrefix = "Jarm";
        threadCondenseSuffix = "Condense";
        initTimingReady = false;
        profileRead = false;
        newRmiSwitch = 0;
        newRmiStartRegistry = initRmiStartRegistry;
        newRmiPort = initRmiPort;
        newRmiStartSecMan = initRmiStartSecMan;
        rmiStatus = 0;
        recipLock = new Object();
        logOpened = false;
        out = null;
        lockLog = new Object();
    }
}

