/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ActionOverview;
import com.sap.util.monitor.jarm.CompSingleOverviewExt;
import com.sap.util.monitor.jarm.CompSingleOverviewSat;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;

class CompSingleMonitor {
    protected CompSingleMonitor pred;
    protected CompSingleMonitor succ;
    protected long sequenceNumber;
    protected TaskMonitor mon;
    protected CompSingleMonitor parentComp;
    protected CompSingleMonitor nextMainComp;
    protected String compName;
    protected boolean childComplete;
    protected boolean foreignComp;
    protected long startElapsedTS;
    protected long startCpuTS;
    protected long subTime;
    protected long subCpuTime;
    protected long grossTime;
    protected long grossCpuTime;
    protected int compOutData;
    private int level;
    private boolean closed;
    private boolean complete;
    private long startTS;
    private long endElapsedTS;
    private long endCpuTS;
    private int actionCount;
    private ActionOverview actionList;
    private ActionOverview actionEndOfList;

    protected CompSingleMonitor(long seqNumber) {
        this.sequenceNumber = seqNumber;
    }

    protected boolean endRequest() {
        CompSingleMonitor hlpComp = this;
        boolean complete = true;
        do {
            if (!hlpComp.closed) {
                hlpComp.checkSubComponents();
                hlpComp.closed = true;
                hlpComp.complete = false;
                if (this.mon.partnersSize >= 0) {
                    this.mon.informPartners(1, this.mon.reqNameLocal, hlpComp.compName, true);
                }
            }
            if (!complete || hlpComp.complete) continue;
            complete = false;
        } while ((hlpComp = hlpComp.nextMainComp) != null);
        return complete;
    }

    protected int startComponent(TaskMonitor monParam, String compNameParam, boolean foreign, long currentTS, long elapsedTS, long cpuTS) {
        CompSingleMonitor hlpComp = this.pred;
        while (hlpComp != null && hlpComp.closed) {
            hlpComp = hlpComp.pred;
        }
        if (hlpComp != null) {
            this.level = hlpComp.level + 1;
            this.parentComp = hlpComp;
        } else {
            this.parentComp = null;
            this.level = 0;
        }
        this.complete = false;
        this.closed = false;
        this.childComplete = true;
        this.foreignComp = foreign;
        this.compName = compNameParam;
        this.startTS = currentTS;
        this.startElapsedTS = elapsedTS;
        this.startCpuTS = cpuTS;
        this.grossTime = -1L;
        this.subTime = -1L;
        this.endElapsedTS = -1L;
        this.grossCpuTime = -1L;
        this.subCpuTime = -1L;
        this.endCpuTS = -1L;
        this.compOutData = -1;
        this.nextMainComp = null;
        this.actionCount = 0;
        this.actionEndOfList = null;
        this.actionList = null;
        this.mon = monParam;
        return this.level;
    }

    protected CompSingleMonitor endComponent(String compNameParam, int dataLength, long elapsedTS, long cpuTS) {
        CompSingleMonitor hlpComp = this;
        boolean compFound = false;
        hlpComp = this.findComponent(compNameParam);
        if (hlpComp != null) {
            hlpComp.updateComponent(dataLength, elapsedTS, cpuTS);
            if (hlpComp.parentComp != null) {
                hlpComp.parentComp.updateParentComponent(hlpComp.grossTime, hlpComp.grossCpuTime);
            }
        }
        return hlpComp;
    }

    protected CompSingleMonitor findComponent(String compNameParam) {
        CompSingleMonitor hlpComp = this;
        boolean compFound = false;
        while (true) {
            if (hlpComp != null && hlpComp.compName.compareTo(compNameParam) != 0) {
                hlpComp = hlpComp.parentComp != null && hlpComp == this ? hlpComp.parentComp : hlpComp.pred;
                continue;
            }
            if (hlpComp != null) {
                if (!hlpComp.closed) {
                    compFound = true;
                } else {
                    hlpComp = hlpComp.pred;
                }
            }
            if (compFound || hlpComp == null) break;
        }
        return hlpComp;
    }

    protected void updateComponent(int dataLength, long elapsedTS, long cpuTS) {
        this.complete = this.checkSubComponents();
        this.closed = true;
        if (this.mon.partnersSize >= 0) {
            this.mon.informPartners(1, this.mon.reqNameLocal, this.compName, false);
        }
        this.endElapsedTS = elapsedTS;
        this.grossTime = ConfMonitor.getTimeDifference(true, this.startElapsedTS, this.endElapsedTS);
        this.endCpuTS = cpuTS;
        this.grossCpuTime = ConfMonitor.getTimeDifference(false, this.startCpuTS, this.endCpuTS);
        this.compOutData = dataLength;
    }

    protected void updateParentComponent(long childGrossTime, long childGrossCpuTime) {
        if (this.childComplete) {
            if (childGrossTime != -1L) {
                this.subTime = this.subTime == -1L ? childGrossTime : (this.subTime += childGrossTime);
            } else {
                this.childComplete = false;
                this.subTime = -1L;
            }
            this.subCpuTime = childGrossCpuTime != -1L ? (this.subCpuTime == -1L ? childGrossCpuTime : (this.subCpuTime += childGrossCpuTime)) : -1L;
        }
    }

    protected boolean checkSubComponents() {
        CompSingleMonitor hlpComp = this.succ;
        boolean ok = true;
        while (hlpComp != null && hlpComp.level > this.level) {
            if (this.level == hlpComp.level - 1) {
                if (!hlpComp.closed) {
                    ok = false;
                    this.updateParentComponent(-1L, -1L);
                    hlpComp.checkSubComponents();
                    hlpComp.closed = true;
                    hlpComp.complete = false;
                    if (this.mon.partnersSize >= 0) {
                        this.mon.informPartners(1, this.mon.reqNameLocal, hlpComp.compName, true);
                    }
                } else if (!hlpComp.complete) {
                    ok = false;
                }
            }
            hlpComp = hlpComp.succ;
        }
        return ok;
    }

    protected CompSingleOverviewExt getCompOverview(boolean provideTrace) {
        CompSingleOverviewSat compOver = new CompSingleOverviewSat();
        compOver.compName = this.compName;
        compOver.level = this.level;
        compOver.compStartTS = this.startTS;
        compOver.compGrossTime = this.grossTime;
        compOver.compGrossCpuTime = this.grossCpuTime;
        if (this.grossTime != -1L && this.childComplete) {
            compOver.compNetTime = this.subTime != -1L ? this.grossTime - this.subTime : this.grossTime;
            compOver.compNetCpuTime = this.grossCpuTime != -1L && this.subCpuTime != -1L ? this.grossCpuTime - this.subCpuTime : (this.grossCpuTime != -1L ? this.grossCpuTime : -1L);
        } else {
            compOver.compNetCpuTime = -1L;
            compOver.compNetTime = -1L;
        }
        compOver.compOutData = this.compOutData;
        if (provideTrace && this.actionCount > 0) {
            ActionOverview hlpAction = this.actionList;
            compOver.actionOverview = new ActionOverview[this.actionCount];
            int i = 0;
            while (i < this.actionCount) {
                compOver.actionOverview[i] = hlpAction;
                hlpAction = hlpAction.next;
                ++i;
            }
            this.actionCount = 0;
            this.actionEndOfList = null;
            this.actionList = null;
        } else {
            compOver.actionOverview = null;
        }
        return compOver;
    }

    protected void addAction(String compNameParam, String action) {
        long actTS = System.currentTimeMillis();
        ActionOverview actOverview = new ActionOverview();
        if (this.actionCount == 0) {
            this.actionList = this.actionEndOfList = actOverview;
        } else {
            this.actionEndOfList.next = actOverview;
            this.actionEndOfList = actOverview;
        }
        actOverview.actionText = action;
        actOverview.actionCompName = compNameParam;
        actOverview.actionTS = actTS;
        ++this.actionCount;
    }
}

