<!--
 Desc: 
				Code which uses Novell`s ActiveX
       	controls NWDir and NWAuth in Microsoft`s ASP environment.
        The code shows how - using ActiveX controls - remote users 
        can be verified against their objectID/password pairs in NDS.
    
        Global.asa is used to create instances of application objects
        for Novell controls and for creating authenticated service
        connection to the NDS. Login information, needed for this service 
        connection, is hard-coded into the file, which keeps the code simple.
        Service connection is created only once and remains valid until
        the application has finished.

   History:

		When						Who										What
		===========================================================================
		November 2002		Andrew Lavespere			Wrapper functions for use with Portal

----------------------------------------------------------------------------->

<% Language=VBScript %>


<SCRIPT LANGUAGE=VBScript RUNAT=Server>

'**********************************************************************
' getNDSName
'
' Function to retrieve the fully qualified DS name based on a userName
'**********************************************************************
 Function getNDSName( userName )
'**********************************************************************

	dim nwDir, ndsName, userContext, ContextUser, pos

	set nwDir = Application( "nwdir" )
	
	' The ContextUser was set in the global.asa file to be used for the user
	' context. Returns values in the format: "user.people.portal" 
	ContextUser = Application("NDSContext" )

	userContext = nwDir.ContextFromFullName( ContextUser )
	
	' Strip out the context leaving the context minus the user: ex: "people.portal"
	pos = instr(1,userContext,".")
	userContext = mid( userContext, pos+1, len(userContext) - pos )

	ndsName= nwdir.TreeFromFullName(ContextUser)
	ndsName= nwdir.FullNameFromTreeAndContext(ndsName,username & "." & userContext)

	'Response.Write( ndsName )
	'Response.End
	'userName = mid(userName,1,instr(1,userName, ".")-1)
	
	GetNDSName = ndsName
	
end Function
'**********************************************************************
' getFieldValue
'
' Function to retrieve specified field value
'**********************************************************************
 function getFieldValue( userName, Field )
'**********************************************************************

	dim nwdir, entry, ndsName

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	if entry is nothing then
		GetFieldValue = "User Not Found"
	else
		GetFieldValue = entry.GetFieldValue( field,"notfound" )
	end if
		
	on error goto 0
	
end Function
'**********************************************************************
' intruderLockout
'
' Wrapper Function to retrieve intruder lockout status
'**********************************************************************
Function intruderLockout( username )
'**********************************************************************
	dim ret

	ret = getFieldValue( userName, "Locked By Intruder" )

	if ret = "notfound" then
		intruderLockout = false
	else
		intruderLockout = cBool( ret )
	end if

end function  
'**********************************************************************
' getErrorMessage
'
' Wrapper Function to retrieve error message text
'**********************************************************************
Function getErrorMessage( errCode )
'**********************************************************************'
	dim errMsg
	
	if errCode = "401" then
		errMsg = "The logon credentials supplied were incorrect. Make sure your user name and password are correct, and then try again."
	elseif errCode = "901" then
		errMsg = "This account has been disabled. Please contact the help desk for assistance."
	elseif errCode = "902" then
		errMsg = "This account has been locked out."
		errMsg = errMsg & "<br><br>Server time is: <b>" & FormatDateTime(now,3) & " on " & FormatDateTime(now,1)
		errMsg = errMsg & "</b><br><br>Try again:<br><br><b>" & lockoutResetTime(request("user")) & "</b>"
	elseif errCode = "903" then
		errMsg = "This password has expired. Please contact the help desk for assistance."
	elseif errCode = "904" then
		errMsg = "New password and Confirmed password do not match. Try again."
	elseif errCode = "905" then
		errMsg = "New password must be different than your current password. Try again."
	elseif mid(errCode,1,3) = "906" then
		errMsg = "Password must be at least " & mid(errCode,4) & " characters."
	elseif errCode = "907" then
		errMsg = "Change password failed."
	elseif errCode = "908" then
		errMsg = "Password changed Successfully!"
	elseif errCode = "909" then
		errMsg = "Password change not allowed!"
	elseif errCode = "910" then
		errMsg = "User does not exist."
	elseif errCode = "911" then
		errMsg = "Reset Password Failed."
	elseif errCode = "912" then
		errMsg = "Reset Password Successful."
	elseif errCode = "913" then
		errMsg = "Password not required."
	else
		errMsg = "Error: " & errCode & " not found"
	end if

	getErrorMessage = errMsg

end function
'**********************************************************************
' accountDisabled
'
' Wrapper Function to retrieve account disabled status
'**********************************************************************
Function accountDisabled( username )
'**********************************************************************
	dim ret

	ret = getFieldValue(username, "Login Disabled" )
	
	if ret = "notfound" then
		accountDisabled = false
	else
		accountDisabled = cBool(ret)
	end if

end function  
'**********************************************************************
' lockoutResetTime
'
' Wrapper Function to retrieve lockout reset time
'**********************************************************************
Function lockoutResetTime( username )
'**********************************************************************
	dim ResetTime

	if intruderLockout(username) then
		resetTime = getFieldValue( userName, "Login Intruder Reset Time" )
		lockoutResetTime = FormatDateTime(resetTime,1) & " at " & FormatDateTime(resetTime, 3) & " - (" & datediff("n", now, cDate(resettime)) & " Minutes" & ")"
	else
		lockoutResetTime = "Not Locked"
	end if
	
end function  

'**********************************************************************
' lastLoginTime
'
' Wrapper Function to retrieve last login time
'**********************************************************************
Function lastLoginTime( username )
'**********************************************************************
	lastLoginTime = getFieldValue( userName, "Last Login Time" )
end function  

'**********************************************************************
' passwordRequired
'
' Wrapper Function to retrieve last login time
'**********************************************************************
Function passwordRequired( username )
'**********************************************************************
	dim ret
	
	ret = getFieldValue( userName, "Password Required" )
	
	if ret = "notfound" then
		passwordRequired = false
	else
		passwordRequired = cBool(ret)
	end if
	
end function  
'**********************************************************************
' allowPasswordChange
'
' Wrapper Function to retrieve last login time
'**********************************************************************
Function allowPasswordChange( username )
'**********************************************************************
	dim ret
	
	ret = getFieldValue( userName, "Password Allow Change" )
	
	if ret = "notfound" then
		allowPasswordChange = false
	else
		allowPasswordChange = cBool(ret)
	end if
	
end function  

'**********************************************************************
' passwordExpires
'
' Wrapper Function 
'**********************************************************************
Function passwordExpires( username )
'**********************************************************************
	dim expireDate
	
	expireDate = getFieldValue( username, "Password Expiration Time" )
	passwordExpires = datediff( "d", now(), cDate( expireDate ) )

end function
'**********************************************************************
' passwordInterval
'
' Wrapper Function 
'**********************************************************************
Function passwordInterval( username )
'**********************************************************************
	dim ret
	
	ret = getFieldValue( userName, "Password Expiration Interval" ) 
	
	if ret = "notfound" then
		ret = 0
	else
		ret = ret / 60 / 60 / 24
	end if
	
	passwordInterval = ret
	
end function
'**********************************************************************
' passwordHasExpired
'
' Wrapper Function 
'**********************************************************************
Function passwordHasExpired( username )
'**********************************************************************

	if passwordInterval(username) > 0 then
		if passwordExpires(username) < 1 then
			passwordHasExpired = true
		else
			passwordHasExpired = false
		end if
	else
		passwordHasExpired = false
	end if
end function  

'**********************************************************************
' minimumPasswordLength
'
' Wrapper Function 
'**********************************************************************
Function minimumPasswordLength( username )
'**********************************************************************
	minimumPasswordLength = getFieldValue( userName, "Password Minimum Length" )
end function
'**********************************************************************
' VerifyPassword
'
' Function to retrieve specified login attribute
'**********************************************************************
 function VerifyPassword( userName, Password )
'**********************************************************************

	dim nwdir, entry, ndsName, retcode

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	
	if entry is nothing then
		VerifyPassword = false
	else
		VerifyPassword = entry.ValidatePassword(password)
	end if
		
	on error goto 0
	
end Function
'*************************************************************************
' userExists
'*************************************************************************
function userExists( username )
'*************************************************************************
	dim nwdir, entry, ndsName

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	if entry is nothing then
		if lcase(username) <> "admin" then
			userExists = false
		else
			userExists = true
		end if
	else
		userExists = true
	end if

end function
'*************************************************************************
' ValidateResetPassword
'
' Function to check that password meets all criteria
'*************************************************************************
function ValidateResetPassword( userName, password, confirmed)
'*************************************************************************
	dim errorCode, minLength

	' Check to see if any password requirements have been set
	if not userExists( userName ) then
			errorCode = "910"
	elseif passwordRequired(username) then

		minLength =  getFieldValue( userName, "Password Minimum Length" )
	
		if password <> confirmed then
			errorCode = "904"
		elseif (minLength > 0) and (len(password) < minLength) then
			errorCode = "906" & cstr(minLength)
		end if
		
	else
		errorCode = "913"
	end if

	ValidateResetPassword = errorCode

end function
'*************************************************************************
' ValidatePasswordCriteria
'
' Function to check that password meets all criteria
'*************************************************************************
function ValidatePasswordCriteria( userName, password, confirmed, old )
'*************************************************************************
	dim errorCode, minLength

	minLength =  getFieldValue( userName, "Password Minimum Length" )
	
	if not VerifyPassword( username, old ) then
		errorCode = "401"
	elseif password <> confirmed then
		errorCode = "904"
	elseif password = old then
		errorCode = "905"
	elseif len(password) < cInt(minLength) then
		errorCode = "906" & minLength
	end if

	ValidatePasswordCriteria = errorCode

end function
'**********************************************************************
' SetPassword
'
' Function to retrieve specified login attribute
'**********************************************************************
 function SetPassword( userName, Password, old )
'**********************************************************************

	dim nwdir, entry, ndsName, expires, interval

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	if entry is nothing then
		SetPassword = false
	else
		if entry.ValidatePassword(old) then
			interval = getFieldValue( userName, "Password Expiration Interval" ) / 60 / 60 / 24
			expires = dateAdd( "d", interval, now() )
			
			'Set the password
			call entry.SetPassword(password)
			entry.update
			
			'Set the expiration date
			call entry.SetFieldValue( "Password Expiration Time", cstr(expires) )
			entry.update
			
			SetPassword = true
			
		else
			SetPassword = false
		end if
		
	end if
		
	on error goto 0
	
end Function

'**********************************************************************
' ResetPassword
'
' ResetPassword to be used by Helpdesk
'**********************************************************************
 function ResetPassword( userName, Password )
'**********************************************************************

	dim nwdir, entry, ndsName, expires, interval

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	if entry is nothing then
		SetPassword = "911"
	else
		interval = getFieldValue( userName, "Password Expiration Interval" ) / 60 / 60 / 24
		expires = dateAdd( "d", cint(interval), now() )
			
		'Set the password
		call entry.SetPassword(password)
		entry.update
			
		'Set the expiration date
		call entry.SetFieldValue( "Password Expiration Time", cstr(expires) )
		entry.update
			
		ResetPassword = ""
			
	end if
		
	on error goto 0
	
end Function
'**********************************************************************
' ListFieldValues
'
' Function to retrieve specified login attribute
'**********************************************************************
 function ListFieldValues( userName )
'**********************************************************************

	dim nwdir, entry, ndsName, ret, i

	set nwdir  = Application("nwdir")

	ndsName = getNDSName( userName )
	
	on error resume next
	
	set entry = nwDir.findEntry(ndsName)

	if entry is nothing then
		GetFieldValue = "Entry is nothing"
	else
		ret = entry.GetFieldValue( "","",true )
		for i = 1 to ubound(ret)
			Response.Write( ret(i) & ": " & entry.GetFieldValue( ret(i) ) & "<br>")
		next
	end if
		
	on error goto 0
	
end Function

function testFunctions(username, password)

	call ListFieldValues( username )
	
	Response.Write( "<br><br>User NDS Name: " & getNDSName(username) & "<br><br>" )
	Response.Write( "User Exists: " & UserExists(username) & "<br>" )
	Response.Write( "Intruder Lockout: " & intruderLockout(username) & "<br>" )
	Response.Write( "Account Disabled: " & accountDisabled(username) & "<br>" )
	Response.Write( "Lockout Reset Time: " & lockoutResetTime(username) & "<br>" )
	Response.Write( "Last Login Time: " & lastLoginTime(username) & "<br>" )
	Response.Write( "Password Required: " & passwordRequired(username) & "<br>" )
	Response.Write( "Allow Password Change: " & allowPasswordChange(username) & "<br>" )
	Response.Write( "Password Expires: " & passwordExpires(username) & "<br>" )
	Response.Write( "Password Has Expired: " & passwordHasExpired(username) & "<br>" )
	Response.Write( "Minimun Password Length: " & minimumPasswordLength(username) & "<br>" )
	Response.Write( "Verify Password: " & VerifyPassword(username,password) & "<br>" )
	Response.Write( "Validate Password Reset: " & ValidateResetPassword(username,password,"fds") & "<br>" )
	Response.Write( "Validate Password Criteria: " & ValidatePasswordCriteria(username, "new1", "new1", "fdsa") & "<br>" )
	Response.end
end function
</SCRIPT>






