<%@page isErrorPage="false" errorPage="/jsp/internal/errorpage.jsp" %>
<%@taglib uri="/jsp/sap.ur.tld" prefix="page" %>
<%@include file="/jsp/internal/init.jsp" %>

<page:setResourceBundle name="previewtexts" />

<page:render>
      <ur:singleColumnLayout ur:id="scl1">
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c1">
          <ur:textView method="setContent" ur:design="HEADER1" ur:text="InputTokenizer"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c2">
          <ur:textView method="setContent" ur:text="Use the InputTokenizer to provide users a way to enter data tokens and validate them against a predefined list of values. These tokens will be separated by a delimiter value and will be tested as complete data values against the list of values in the referenced InputTokenList."/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells">
          <ur:textView method="setContent" ur:text="Valid values for the examples below are:"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c5">
          <ur:itemList method="setContent">
            <ur:itemListItem method="addItems" ur:text="Martin Schaus"/>
            <ur:itemListItem method="addItems" ur:text="Barbara Hartel"/>
            <ur:itemListItem method="addItems" ur:text="Mandana Samii"/>
          </ur:itemList>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells">
          <ur:textView method="setContent" ur:text="The Button is not part of the InputTokenizer control but serves to demonstrate its behaviour."/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells" ur:id="scl1c3">
          <ur:horizontalDivider method="setContent" ur:ruleDisplay="NONE" ur:separationHeight="LARGE"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells">
          <ur:textView method="setContent" ur:text="InputTokenizer (default settings)"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c5" ur:wrapping="false">
          <ur:matrixLayout method="setContent">
            <ur:matrixLayoutRow method="addRows">
              <ur:matrixLayoutCell method="addCells">
                <ur:inputTokenizer method="setContent" ur:caseSensitive="false" ur:id="myTokenizer" ur:tokenListId="List01" ur:tooltip="This is a tooltip" ur:validateButton="btnVal" ur:width="330px">
                  <ur:inputToken method="addTokens" ur:id="Thomas_Morrus" ur:status="UNVALIDATED" ur:text="Thomas Morrus"/>
                  <ur:inputToken method="addTokens" ur:id="Ina_Deter" ur:status="UNVALIDATED" ur:text="Ina Deter"/>
                </ur:inputTokenizer>
              </ur:matrixLayoutCell>
              <ur:matrixLayoutCell method="addCells">
                <ur:button method="setContent" ur:bUTTONCLICK="myFunction" ur:id="btnVal" ur:text="Validate"/>
              </ur:matrixLayoutCell>
              <ur:matrixLayoutCell method="addCells">
                <ur:inputTokenList method="setContent" ur:id="List01">
                  <ur:inputToken method="addTokens" ur:id="Barbara_Hartel" ur:text="Barbara Hartel"/>
                  <ur:inputToken method="addTokens" ur:id="Mandana_Samii" ur:text="Mandana Samii"/>
                </ur:inputTokenList>
              </ur:matrixLayoutCell>
            </ur:matrixLayoutRow>
          </ur:matrixLayout>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells" ur:id="scl1c3">
          <ur:horizontalDivider method="setContent" ur:ruleDisplay="NONE"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells">
          <ur:textView method="setContent" ur:text="Disabled InputTokenizer"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c5" ur:wrapping="false">
          <ur:matrixLayout method="setContent">
            <ur:matrixLayoutRow method="addRows">
              <ur:matrixLayoutCell method="addCells">
                <ur:inputTokenizer method="setContent" ur:caseSensitive="false" ur:enabled="false" ur:id="myTokenizer2" ur:tokenListId="List01" ur:tooltip="This is a tooltip" ur:validateButton="btnVal2" ur:width="330px">
                  <ur:inputToken method="addTokens" ur:id="Thomas_Morrus" ur:status="UNVALIDATED" ur:text="Thomas Morrus"/>
                  <ur:inputToken method="addTokens" ur:id="Ina_Deter" ur:status="UNVALIDATED" ur:text="Ina Deter"/>
                </ur:inputTokenizer>
              </ur:matrixLayoutCell>
            </ur:matrixLayoutRow>
          </ur:matrixLayout>
        </ur:singleColumnLayoutCell>
      </ur:singleColumnLayout>
    </page:render>
<script>
function myFunction(id){
	sapUrMapi_InputTokenizer_markValidTokens('myTokenizer');
}
</script>
<%@include file="/jsp/internal/end.jsp" %>
