/*-------------------------------------*/
/*  Global Control Services            */
/*  (c) 2002 SAP AG                    */
/*-------------------------------------*/
  
/*----------------------------------------------------------------------*/
/*  General                                                             */
/*----------------------------------------------------------------------*/
// domainrelaxing
  // domainrelaxing
  
  /*var  strDomainRelaxScript  = '<S'+'CRIPT> var liBehindFirstDot = document.domain.indexOf( "." ) + 1;';
       strDomainRelaxScript += 'if (liBehindFirstDot > 0) {';
       strDomainRelaxScript += 'document.domain = document.domain.substr( liBehindFirstDot );';
       strDomainRelaxScript += '}</S'+'CRIPT>';
  */
  strDomainRelaxScript  = "";  
  var docBody = null;  
//------------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Popup Object                                                        
//----------------------------------------------------------------------------
//Events provided by this Object 
// onbeforerender  = use that event to set other positions than the precalculated;
// onblur          = fired when the popup blurs, use to hide it
//----------------------------------------------------------------------------

//consts enums 
  
//----------------------------------------------------------------------------
// sapPopupSizeBehavior used with attribute o.sizebehaviour
// o.sizebehaviour.USER    - you can set the size of the popup, 
//                           use o.size.width,o.size.height
//                         
// o.sizebehaviour.CONTENT - the popup will automatically adjust to the the
//                           size of its content
//----------------------------------------------------------------------------
  sapPopupSizeBehavior     = { CONTENT : "CONTENT", USER : "USER" };
//----------------------------------------------------------------------------
if(ur_system.emptyhoverurl==null) ur_system.emptyhoverurl = ur_system.mimepath+"emptyhover.html";
document.write("<div id='urFrames'><iframe id=\"sapPopupMainId_X0\" name=\"sapPopupMainId_X0\" src=\""+ur_system.emptyhoverurl+"\" style=\"z-index:1001;display:block;position:absolute;top:-5000;width:0;height:0\"  frameborder=\"0\" border=\"no\" scrolling=\"no\" tabindex=\"-1\"></iframe></div>");
  
//----------------------------------------------------------------------------
// sapPopupPositionBehavior used with attribute o.positionbehaviour
// o.positionbehaviour.MENULEFT      - popup shows left aligned under the 
//                                     source element.
// o.positionbehaviour.MENURIGHT     - popup shows right aligned under the 
//                                     source element.
// o.positionbehaviour.BROWSERCENTER - popup shows centered in the browser 
//                                     window. 
// o.positionbehaviour.USER          - you can set the position
//                                     use o.position.left, o.position.top
//----------------------------------------------------------------------------
  
  sapPopupPositionBehavior = { MENULEFT : "MENULEFT", MENURIGHT : "MENURIGHT", BROWSERCENTER : "BROWSERCENTER", USER : "USER", SUBMENU : "SUBMENU",EVENT:"EVENT" }
//----------------------------------------------------------------------------

  var sapPopupMainId = "sapPopupMainId_X";

//Variables
  var sapPopupStore = new Array(); 
  var sapOpenLevel  = false; 
  
/*----------------------------------------------------------------------*/
/*  Constructor                                                         */
/*----------------------------------------------------------------------*/
// desc : create a new popup
// in   : sourcewindow   : DOM window object - caller window
//        stylesheets    : Array             - stylesheet urls to use in the popup
//        contentobject  : DOM element       - that contains the html to show in the popup
//        sourceobject   : DOM element       - source element to align the popup
//        sourceevent    : DOM event object  - fired on the sourceobject to position the popup
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
  function sapPopup(sourcewindow,stylesheets,contentobject,sourceobject,sourceevent,level) {
    //Attributes
    this.level = level;
    this.sizebehaviour = sapPopupSizeBehavior.CONTENT;
    this.positionbehavior = sapPopupPositionBehavior.MENULEFT;
    
    this.position = { left: -1, top: -1, right: -1, bottom: -1 };
    this.size     = { width: -1, height: -1 };
    if (document.getElementById(sapPopupMainId+(level+1))==null) {
    	 var oFramesContainer = document.getElementsByTagName("BODY").item(0);
    	 for (var f=level+1;f<level+3;f++) {
    	 	 var oFrame = document.createElement("IFRAME");
    	 	 oFrame.setAttribute("id",sapPopupMainId+(f));
    	 	 oFrame.setAttribute("name",sapPopupMainId+(f));
    	 	 oFrame.setAttribute("src",ur_system.emptyhoverurl);
    	 	 oFrame.setAttribute("style","width:0;height:0;z-index:1001;display:block;position:absolute;top:-5000;");
    	 	 oFrame.setAttribute("tabindex","-1");
    	 	 oFrame.setAttribute("frameborder","0");
    	 	 oFrame.setAttribute("border","no");
    	 	 oFrame.setAttribute("scrolling","no");
    	   oFramesContainer.appendChild(oFrame);
    	 }
    }
    
    this.frame = { object: document.getElementById(sapPopupMainId+level), 
                   window: window.frames[sapPopupMainId+level]};
    
    this.content = { html: contentobject.innerHTML,
                     size: contentobject.childNodes[0] };
    //store information about the source of that popuprequest
    this.source = { event:sourceevent, 
                    object:sourceobject, 
                    window: sourcewindow, 
                    document:sourcewindow.document, 
                    body: sourcewindow.document.getElementsByTagName("BODY").item(0) };
    
    this.canrender   = true;
    this.domainrelax = true;
    this.scrolling   = true; 
    this.stylesheets = stylesheets;

    //Methods
    this.write   = sapPopup_write;
    this.show    = sapPopup_show;
    this.showOld = sapPopup_showOld;
    this.hide    = sapPopup_hide;
    this.poscalc = sapPopup_poscalc;
    
    //Events
    this.onbeforerender  = null;
    this.onblur          = null;
        
    //define a global variable with the body element for all popups once
    if (!docBody) docBody = window.document.getElementsByTagName("BODY")[0];

    //if relative urls are used for styles try to absolute them
    for (var n=0; n<this.stylesheets.length;n++) {
      this.stylesheets[n]=relativeToAbsolutePath(this.stylesheets[n],sourcewindow.location.href);
    }

    //set a variable inside sourcewindow to itself, used to refer events back
    this.source.window.me = this.source.window;
	  if (this.source.window.ur_system.domainrelaxing==this.source.window.sapUrDomainRelaxing.MINIMAL) {
      strDomainRelaxScript  = "<s"+"cript>try{parent.document.domain} catch(e){var hostname = document.domain; var posBehindFirstDot = hostname.indexOf(\".\") + 1;if (posBehindFirstDot>0) {document.domain=hostname.substr(posBehindFirstDot);}};</scri"+"pt>";
	  } else {
	      if (this.source.window.ur_system.domainrelaxing==this.source.window.sapUrDomainRelaxing.MAXIMAL){
	      strDomainRelaxScript  = "<s"+"cript>try {parent.document.domain} catch(e){var nameparts=document.domain.split(\".\"); if (nameparts.length > 2) document.domain = nameparts.slice(nameparts.length - 2).join(\".\"); };</scri"+"pt>";
	    }
	  }
    
    sapPopupStore[this.level] = this;
    return this; 
 }
 

/*----------------------------------------------------------------------*/
/*  Methods                                                               */
/*----------------------------------------------------------------------*/
//----------------------------------------------------------------------------
// method write
//----------------------------------------------------------------------------
// desc : writes the popup into its iframe
//        internal use only
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_write(bDoNotAutoFocus) {
  //potentially this is faster with dom operations but what about relaxing domains?
  strContent = "<html><head>";
  //add domain relaxing
  if (this.domainrelax) strContent += strDomainRelaxScript;
  if(bDoNotAutoFocus)
		strContent += "<sc"+"ript>me=parent.sapPopupStore["+this.level+"].source.window;mylevel="+this.level+";</scr"+"ipt>";
	else
		strContent += "<sc"+"ript>me=parent.sapPopupStore["+this.level+"].source.window; window.focus();mylevel="+this.level+";</scr"+"ipt>";
      
  //add stylesheets
  for (var n=0; n<this.stylesheets.length;n++) {
    strContent+= "<link rel=\"stylesheet\" href=\""+this.stylesheets[n]+"\" type=\"text/css\">";
  }
    
  //add the content and the rest
  strContent+= "</head><body class='urBdyStd' scroll=";
  strContent+= this.scrolling?"'no'":"'auto'";
  if(this.object!=null && this.object.getAttribute("ct")!="ComboBox"){  
		strContent+= " onload='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],1);'";
		if (this.level==0) {
			strContent+= " onfocus='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],2);' onblur='if ((parent.sapPopupStore[mylevel]) && (!parent.sapOpenLevel)) {parent.sapPopupStore[mylevel].onblur();}'";
		} else {
			strContent+= " onfocus='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],2);' onblur='if ((parent.sapPopupStore[mylevel]) && (!parent.sapOpenLevel)) {parent.sapPopupStore[mylevel].onblur();}'";
		}
	}
  strContent+= " style='margin:0;border:none;'>"+this.content.html+"</body></html>";
  //write it!
  //this.frame.window.document.open();
  this.frame.window.document.write(strContent);
  this.frame.window.document.close();
}

var intLeftFramePx;
var intTopFramePx;

//----------------------------------------------------------------------------
// method poscalc
//----------------------------------------------------------------------------
// desc : calculates the position of the popup depending on 
//        - sizebehaviour
//        - positionbehavior
//        changes the position if right or/and bottom might be 
//        not in the visible area to ensure the whole popup is visible
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_poscalc() {
  //set the size of the frame depending on its content
  if (this.sizebehaviour==sapPopupSizeBehavior.CONTENT) {
    this.size.width  = this.content.size.offsetWidth;
    this.size.height = this.content.size.offsetHeight;
  } else {
    if ((this.size.width<=0) || (this.size.height<=0)) {
      showError("Please set\n   int sapPopup.size.width\n   int sapPopup.size.height\n to a value > 0.");
      this.canrender = false
    }
  } 
  //find relative position to sourceobject;
  var sourceoffset    = getAbsolutePosition(this.source.object);
  var sourcesize      = getElementSize(this.source.object);
  //event object is available
  if ( this.positionbehavior.indexOf("MENU")>-1) {
      this.position.left = sourceoffset.left;
      this.position.top  = sourceoffset.top + sourcesize.height;
      if (this.positionbehavior == sapPopupPositionBehavior.MENURIGHT) {
	      this.position.left = this.position.left + sourcesize.width - this.size.width;
      }
      //calculate right and bottom
      if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
	    this.position.left = this.position.left + sourcesize.width;
	    this.position.top  = this.position.top - sourcesize.height;
        if (this.level>0) { 
          this.position.left = this.position.left+sapPopupStore[this.level-1].position.left;
          this.position.top = this.position.top+sapPopupStore[this.level-1].position.top;
        } 
      }
      //calculate right and bottom
      this.position = setPosBottomRight(window, this.position, this.size);
      
      // if submenue does not fit on usual place,
      // try to position on other side of parent menu,
      // but only, of there is enough space available
      var setsubmenubelow=false;
      if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
        if (this.position.right<0) {
          if (this.position.left-(sourcesize.width)+7-this.size.width>window.pageXOffset) {
            this.position.left=this.position.left-(sourcesize.width)+7-this.size.width;
          } else {
            this.position.top = this.position.top + sourcesize.height;
            setsubmenubelow=true;
          }
          //calculate right and bottom 
          this.position = setPosBottomRight(window, this.position, this.size)
        } 
      } 
      
      //reposition horizontally
      if (this.position.right<0) this.position.left  = window.innerWidth + window.pageXOffset - this.size.width;
      if (this.position.left-window.pageXOffset<0) this.position.left  = 0 + window.pageXOffset;
      // reposition vertically
      if (this.position.bottom<0) {											 //too bottom
        if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
          if (setsubmenubelow) 
            this.position.top = this.position.top - sourcesize.height - this.size.height; 
          else  
            this.position.top = this.position.top + sourcesize.height - this.size.height; 
        }  
        if ((this.positionbehavior == sapPopupPositionBehavior.MENULEFT) ||
            (this.positionbehavior == sapPopupPositionBehavior.MENURIGHT)) {
          this.position.top = this.position.top - sourcesize.height - this.size.height;  
        }
      }  
      if (this.position.top-window.pageYOffset<0) this.position.top  = 0 + window.pageYOffset;
        
      //recalculate right and bottom according to changed values
      this.position = setPosBottomRight(window, this.position, this.size)
      
    } else if ( this.positionbehavior == sapPopupPositionBehavior.BROWSERCENTER ) {
	  this.position.left = Math.floor((window.innerWidth/2)-(this.size.width/2)) + this.source.window.pageXOffset;
	  this.position.top  = Math.floor((window.innerHeight/2)-(this.size.height/2)) + this.source.window.pageYOffset;
      this.position.right   = window.innerWidth  - this.position.left - this.size.width + window.pageXOffset;
	  this.position.bottom  = window.innerHeight - this.position.top  - this.size.height + window.pageYOffset;
	  
  } else if (this.positionbehavior == sapPopupPositionBehavior.EVENT) {
	  this.position.left = this.source.event.pageX+window.pageXOffset;
	  this.position.top  = this.source.event.pageY+window.pageYOffset;
      this.position.right   = window.innerWidth  - this.position.left - this.size.width + window.pageXOffset;
      this.position.bottom  = window.innerHeight - this.position.top  - this.size.height + window.pageYOffset;
      
      //repositioning
      if (this.position.right<0) this.position.left  = this.position.left - this.size.width;
      if (this.position.bottom<0) this.position.top  = this.position.top - this.size.height;
      if (this.position.left-window.pageXOffset<0) this.position.left  = 0 + window.pageXOffset;
      if (this.position.top-window.pageYOffset<0) this.position.top  = 0 + window.pageYOffset;
	  //recalculate right and bottom
      this.position = setPosBottomRight(window, this.position, this.size)
   } else if ((this.position.top<0) || (this.position.left<0)) {
      showError("Please set\n   int sapPopup.position.left\n   int sapPopup.position.top\n to a value > 0.");
      this.canrender = false
  }

  if ((this.position.left-window.pageXOffset<0) || (this.position.right<0)) {
     this.position.left  = window.pageXOffset;
  }
  if ((this.position.top-window.pageYOffset<0) || (this.position.bottom<0)){
      if (this.canrender) this.scrolling=true;
      this.position.top  = window.pageYOffset;
  }
}
//----------------------------------------------------------------------------
// method show
//----------------------------------------------------------------------------
// desc : shows the popup
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_show(noRecalc,bDoNotAutoFocus) {
  //creating another child 
  sapOpenLevel = true;
  this.poscalc();
  if (this.onbeforerender) { if (!this.onbeforerender(this)) return; }
  if (!this.canrender) { showError("Cannot render Popup. Sizes and positions are not set."); return; }
  try {  	
		if (this.frame.window.mylevel==null) {
		  this.write(bDoNotAutoFocus);
		} else {
		  this.frame.window.document.getElementsByTagName("BODY").item(0).innerHTML=this.content.html;
		  window.sapUrMapi_PopupMenu_setEvents(this,1);
		}
  } catch (e){
    this.write(bDoNotAutoFocus);
  }
  //show the menu
  
  this.frame.object.style.left   = this.position.left;
  this.frame.object.style.top    = this.position.top;
  this.frame.object.style.width  = this.size.width;
  this.frame.object.style.height = this.size.height;

  activePopup = this;
  this.oldresize = window.onresize;
  //window.onresize = top.hidePopups;
  return true;
}
//----------------------------------------------------------------------------
// method showOld
//----------------------------------------------------------------------------
// desc : shows the popup, does not calculate the position and does not
//        write the content
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_showOld() {
  sapOpenLevel = true;
  this.frame.object.style.left   = this.position.left;
  this.frame.object.style.top    = this.position.top;
  this.frame.object.style.width  = this.size.width;
  this.frame.object.style.height = this.size.height;
  activePopup = this;
  this.oldresize = window.onresize;
  return true;
}
//----------------------------------------------------------------------------
// method hide
//----------------------------------------------------------------------------
// desc : hides the popup
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_hide() {
  //hide the menu
  this.frame.object.style.top="-5001";
  if (this.level<sapPopupStore.length-1) {
  	sapPopupStore[this.level+1].hide();
  }
  sapPopupStore[this.level] = null; 
  var sapPopNew = new Array();
  for (var n=0;n<sapPopupStore.length;n++) {
  	if (sapPopupStore[n]!=null) {
  		sapPopNew[sapPopNew.length]=sapPopupStore[n];
  	}
  }
  sapPopupStore = sapPopNew;
  return true;
}
function hidePopupMenu(level) {
  if (sapPopupStore[0]) {
    sapPopupStore[0].hide();
  }
}

/*----------------------------------------------------------------------*/
/*  Helpers                                                             */
/*----------------------------------------------------------------------*/
//----------------------------------------------------------------------------
// function setPosBottomRight
//----------------------------------------------------------------------------
// desc : returns Right and Bottom  relative from a oBody DOM Body
// in   : oWindow  - windowobject, oPos - object - Position Object , oSize
// out  : oPos   - object Position Object
// brw  : NN6>
//----------------------------------------------------------------------------
function setPosBottomRight ( oWindow, oPos, oSize) {
  oPos.right   = oWindow.innerWidth - oPos.left - oSize.width + oWindow.pageXOffset;
  oPos.bottom  = oWindow.innerHeight - oPos.top - oSize.height + oWindow.pageYOffset;
  return oPos;
}   

//----------------------------------------------------------------------------
// function getAbsolutePosition
//----------------------------------------------------------------------------
// desc : returns position object x.left, x.right and x.top from a dom element 
//        absolute to the left, right and top borders of the document. 
// in   : obj  - object
// out  : position - object 
// brw  : top and left: IE5+, NN6+  right: IE5+
//----------------------------------------------------------------------------
function getAbsolutePosition (obj) {
  if (obj)
	  return sapUrMapi_getAbsolutePosition (obj);
}  

//----------------------------------------------------------------------------
// function getElementSize
//----------------------------------------------------------------------------
// desc : returns size object .width and .height on a dom element
// in   : obj  - object
// out  : size - object 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function getElementSize (obj) {
  if (obj)
	  return { height : obj.offsetHeight, width: obj.offsetWidth };
}

//----------------------------------------------------------------------------
// function relativeToAbsolutePath
//----------------------------------------------------------------------------
// desc : returns the absolute url of strRel from an absolute url strAbs
// in   : strRel - string
//        strAbs - string
// out  : absolute path - string 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function relativeToAbsolutePath(strRel,strAbs) {
  if (strRel.lastIndexOf("./")==-1) return strRel; //no relative path
  var strRelDots      = strRel.substring(0,strRel.lastIndexOf("./")+2);
  var strAbsPath      = strAbs.substring(0,strAbs.lastIndexOf("/")); 
  while(strRelDots.lastIndexOf("..")>-1) { //erase all double dots
    strAbsPath = strAbsPath.substring(0,strAbsPath.lastIndexOf("/")); 
    strRelDots = strRelDots.substring(0,strRelDots.lastIndexOf(".."))+"/";
  }
  if (strRelDots.lastIndexOf("./")>-1) {
    //erase last dots slash
    strRelDots = strRelDots.substring(0,strRelDots.lastIndexOf("./"))+"/";
    if (strRelDots.lastIndexOf("./")>-1) { 
      showError (strRel+" is not a valid relative url.");
    }
  }
  //build absolut path
  strNewAbsPath = strAbsPath + strRelDots + strRel.substring(strRel.lastIndexOf("./")+2,strRel.length);
  return strNewAbsPath;
}  
//----------------------------------------------------------------------------
// function showError
//----------------------------------------------------------------------------
// desc : shows an error text strTxt in an alert window could be replaces 
//        in the futur to display nicer messages
// in   : strTxt - string
// out  : none 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function showError(strTxt) {
  alert("Error:"+strTxt);
}
  





      var ptrActiveXArray=new Array();
      function ptrRegisterActiveXComponent(sourceWindow,enable,ptrFunction)
      {
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.sourceWindow==sourceWindow && item.enable==enable){
            item.isActive=true;
            item.ptrFunction=ptrFunction;
            break;
          }
        }
        if(i>=ptrActiveXArray.length){
          ptrActiveXArray[ptrActiveXArray.length]={sourceWindow:sourceWindow,
                                                                       enable:enable,
                                                                       ptrFunction:ptrFunction,
                                                                       isActive:true};
        }
      }

      function ptrUnregisterActiveXComponent(sourceWindow)
      {
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.sourceWindow==sourceWindow){
            item.isActive=false;
          }
        }
      }

      function ptrGetPopupWindow()
      {
        var rtrPopup=window;
        var parentWindow=window;
        while(parentWindow!=parentWindow.parent){
          parentWindow=parentWindow.parent;
          if(typeof(parentWindow.ptrBlendOpacity)!="undefined"){
            rtrPopup=parentWindow;
          }
        }
        return rtrPopup;
      }
      var ptrPopup=ptrGetPopupWindow();
      var ptrPopupMimepath=ur_system.mimepath+"popup/";
      var ptrPopupMimepath1x1=ur_system.mimepath;
      if(ptrPopupMimepath.indexOf("com.sap.portal.design")>=0){
        var appUrl="";
        var urlMimepathArray=ur_system.mimepath.split("/");
        if(urlMimepathArray[0].toLowerCase()=="http:"||urlMimepathArray[0].toLowerCase()=="https:"){
          appUrl=ur_system.mimepath.substr(0,ur_system.mimepath.indexOf(urlMimepathArray[3])-1);
        }
        ptrPopupMimepath=appUrl+"/irj/portalapps/com.sap.portal.htmlb/jslib/";
        if(ur_system.direction=="rtl"){
          ptrPopupMimepath+="r_";
        }
      }
      window.addEventListener("load",ptrAppendImage,false);

      function ptrCancelAction()
      {
        return false; 
      }

      function ptrAppendImage()
      {
        if(typeof ptrCancelAction=="undefined")return;

        var div1x1ImageObj=document.getElementById("div1x1Image");
        if(div1x1ImageObj!=null)
          return;
        var documentBody=document.getElementsByTagName("BODY")[0];
	var divBlock=document.createElement("DIV");
        divBlock.id="div1x1Image";
        divBlock.style.position="absolute";
        //divBlock.style.backgroundColor="#999999";
        divBlock.style.MozOpacity=0.5;
        divBlock.style.left="0";
        divBlock.style.top="0";
        divBlock.style.display="none";
        divBlock.style.width="100%";
        divBlock.style.height="100%";
        divBlock.style.zIndex="4999";
        divBlock.addEventListener("click",ptrCenterPopupWindow,false);
        divBlock.addEventListener("contextmenu",ptrCancelAction,false);
	var imageBlock=document.createElement("IMG");
        imageBlock.src=ptrPopupMimepath1x1+"1x1.gif";
        imageBlock.style.width="100%";
        imageBlock.style.height="100%";
        imageBlock.addEventListener("contextmenu",ptrCancelAction,false);
        imageBlock.addEventListener("mousedown",ptrCancelAction,false);
        divBlock.appendChild(imageBlock);
        documentBody.appendChild(divBlock);

	var divBlockMove=document.createElement("DIV");
        divBlockMove.id="div1x1MoveImage";
        divBlockMove.className="urTxtEmph";
        divBlockMove.style.width="100%";
        divBlockMove.style.height="18px";
        divBlockMove.style.zIndex="5999";
        divBlockMove.style.display="none";
        divBlockMove.style.position="absolute";
        divBlockMove.style.fontSize="11px";
        divBlockMove.style.color="#FFFFFF";
        divBlockMove.style.backgroundColor="#999999";
        divBlockMove.style.left="0";
        divBlockMove.style.top="0";
        divBlockMove.style.overflow="hidden";
        divBlockMove.style.paddingTop="2px";
        divBlockMove.style.paddingLeft="5px";
        documentBody.appendChild(divBlockMove);
      }

      var ptrBlendOpacity=40;
      var ptrPopupArray=new Array();

      function ptrCenterPopupWindow()
      {
        var left=0,top=0;
        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          left=document.body.scrollLeft+(document.body.offsetWidth-ptrPopupArray[ptrPopupArray.length-1].MIDWidth)/2;
          top=document.body.scrollTop+(document.body.offsetHeight-ptrPopupArray[ptrPopupArray.length-1].MIDHeight)/2;
        }
        else{
          left=ptrPopupArray[ptrPopupArray.length-2].left+30;
          top=ptrPopupArray[ptrPopupArray.length-2].top+30;
        } 
        ptrPopupArray[ptrPopupArray.length-1].left=left;
        ptrPopupArray[ptrPopupArray.length-1].top=top;

        try{ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.window.document.getElementById('iframePopupDivHeaderA').focus();}catch(e){}

        var iframePopupObj = ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.object;
        iframePopupObj.style.left = ptrPopupArray[ptrPopupArray.length-1].left;
        iframePopupObj.style.top = ptrPopupArray[ptrPopupArray.length-1].top;
        if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
          var iframeInnerPopupObj = ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.object;
          iframeInnerPopupObj.style.left = ptrPopupArray[ptrPopupArray.length-1].left+2;
          iframeInnerPopupObj.style.top = ptrPopupArray[ptrPopupArray.length-1].top+20;
          if(ptrPopupArray[ptrPopupArray.length-1].type.length>0){
            iframeInnerPopupObj.style.left=ptrPopupArray[ptrPopupArray.length-1].left+2+50;
          }
        }
      }

      var ptrFrameTimeout=false;

      function ptrResizeBlockImage()
      {
        if(ptrPopupArray.length==0 || ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          window.removeEventListener("resize",ptrResizeBlockImage,false);
          return;
        }
        var bodyScrollHeight=0;
        var bodyScrollWidth=0;
        var bodyClientHeight=0;
        var bodyClientWidth=0;

        bodyScrollHeight=document.body.scrollHeight;
        bodyScrollWidth=document.body.scrollWidth;
        bodyClientHeight=document.body.clientHeight;
        bodyClientWidth=document.body.clientWidth;
        var div1x1ImageObj = document.getElementById("div1x1Image");
        div1x1ImageObj.style.height=bodyScrollHeight>bodyClientHeight?bodyScrollHeight:bodyClientHeight;
        div1x1ImageObj.style.width=bodyScrollWidth>bodyClientWidth?bodyScrollWidth:bodyClientWidth;
      }

      var ptrInitialLevel=0;
      function ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton,hasTimeout)
      {
        var ptrLevel=sapPopupStore.length;
        if(typeof hasTimeout=="undefined"){
          hasTimeout=false;
          if(ptrLevel<ptrInitialLevel)
            ptrLevel=ptrInitialLevel;
        }

        if (document.getElementById(sapPopupMainId+(ptrLevel+2))==null){
          var oFramesContainer = document.getElementById("urFrames");
          for (var f=ptrLevel;f<ptrLevel+3;f++) {
            if (document.getElementById(sapPopupMainId+(f))!=null)
              continue;
            var oFrame = document.createElement("IFRAME");
            oFrame.setAttribute("id",sapPopupMainId+(f));
            oFrame.setAttribute("name",sapPopupMainId+(f));
            oFrame.setAttribute("src",ur_system.emptyhoverurl);
            oFrame.setAttribute("style","width:0;height:0;z-index:1001;display:block;position:absolute;top:-5000;");
            oFrame.setAttribute("tabindex","0");
            oFrame.setAttribute("frameborder","0");
            oFrame.setAttribute("border","no");
            oFrame.setAttribute("scrolling","auto");
            oFramesContainer.appendChild(oFrame);
          }
          ptrFrameTimeout=true;
          ptrInitialLevel=ptrLevel+2;
        }
        else{
          try{
            for (var f=ptrLevel;f<ptrLevel+3;f++) {
              window.frames[sapPopupMainId+f].window.document.domain;
            }
          }
          catch(e){
            ptrFrameTimeout=false;
            return;
          }
        }

        var urlArray=sourceWindow.location.href.split("/");
        if(url.split("/")[0].toLowerCase()!="http:"&&url.split("/")[0].toLowerCase()!="https:"){
          if(url.length>0 && url.indexOf("/")==-1){
            var appUrl=sourceWindow.location.href.substr(0,sourceWindow.location.href.indexOf(urlArray[urlArray.length-1]));
            url=appUrl+url;
          }
          else if(url.length>0){
            var appUrl=sourceWindow.location.href.substr(0,sourceWindow.location.href.indexOf(urlArray[3])-1);
            url=appUrl+url;
          }
        }

        if(ptrFrameTimeout==true && hasTimeout==false){
          window.setTimeout(function(){ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton,true);},0);
          return;
        }
        ptrFrameTimeout=false;
        ptrInitialLevel=0;

        if(ptrPopupArray.length>0 && modless==true){
          if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"||
              ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modal"){
            alert("Permission denied!\n\nModeless Dialog over Modal Dialog(s).");
            return;
          }
        }
        var div1x1ImageObj = document.getElementById("div1x1Image");
        if(div1x1ImageObj==null){
          ptrAppendImage();
          div1x1ImageObj = document.getElementById("div1x1Image");
        }
        //Block ActiveX Controls...
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.isActive==true && item.enable==false){
            try{
              item.ptrFunction();
            }
            catch(e){}
          }
        }

        var dialogMode="";
        if(modless==true){
          dialogMode="modless";
        }
        else if(ptrPopupArray.length==0||ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          dialogMode="startModal";
        }
        else{
          dialogMode="modal";
        }

        ptrPopupArray[ptrPopupArray.length]={sourceWindow:sourceWindow,
                                             left:0,
                                             top:0,
                                             width:0,
                                             MIDWidth:0,
                                             height:0,
                                             MIDHeight:0,
                                             oPopup:null,
                                             isInitial:true,
                                             oInnerPopup:null,
                                             mode:"MAX",
                                             isFix:isFix,
                                             type:type,
                                             overflow:ptrPopup.document.body.style.overflow,
                                             showDialog:true,
                                             dialogMode:dialogMode,
                                             popupId:ptrPopupArray.length};
        var stylesheets=new Array();

        var urlArray=window.location.href.split("/");
        var appUrl=window.location.href.substr(0,window.location.href.indexOf(urlArray[2])+urlArray[2].length);

        var urlMimepathArray=ur_system.stylepath.split("/");
        if(urlMimepathArray[0].toLowerCase()=="http:"||urlMimepathArray[0].toLowerCase()=="https:"){
          appUrl="";
        }
        stylesheets[stylesheets.length]=appUrl+ur_system.stylepath+"ur_"+ur_system.browser_abbrev+".css";

        var iLevel=-1;
        for (var n=0;n<ptrPopupArray.length;n++) {
          iLevel++;
          if(ptrPopupArray[n].oInnerPopup!=null)iLevel++;
        }
        if(sapPopupStore.length>iLevel)
          iLevel=sapPopupStore.length;
        ptrPopupArray[ptrPopupArray.length-1].oPopup = new sapPopup(window,stylesheets,div1x1ImageObj,null,null,iLevel);
        ptrPopupArray[ptrPopupArray.length-1].oPopup.mouseover=true;
        if(popupId.length>0){
          ptrPopupArray[ptrPopupArray.length-1].popupId=popupId;
        }
        if(typeof(sourceWindow.ptrDialogObj)!="undefined" && sourceWindow.ptrDialogObj!=null){
          ptrInitModalDialogLabels(sourceWindow.ptrDialogObj,ptrPopupArray.length-1);
        }
        
        var oPopup=ptrPopupArray[ptrPopupArray.length-1].oPopup;
        var iframePopupObj=oPopup.frame.object;
        iframePopupObj.style.zIndex=4999+2*ptrPopupArray.length;
        oPopup.size.height=height;
        oPopup.size.width=width;
        iframePopupObj.style.width=width;
        iframePopupObj.style.height=height;

        var bodyScrollHeight=0;
        var bodyScrollWidth=0;
        var bodyClientHeight=0;
        var bodyClientWidth=0;
        var bodyScrollLeft=0;
        var bodyScrollTop=0;
        var left=0;
        var top=0;

        bodyScrollHeight=document.body.scrollHeight;
        bodyScrollWidth=document.body.scrollWidth;
        bodyClientHeight=document.body.clientHeight;
        bodyClientWidth=document.body.clientWidth;
        bodyScrollTop=document.body.scrollTop;
        bodyScrollLeft=document.body.scrollLeft;

        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          div1x1ImageObj.style.height=bodyScrollHeight>bodyClientHeight?bodyScrollHeight:bodyClientHeight;
          div1x1ImageObj.style.width=bodyScrollWidth>bodyClientWidth?bodyScrollWidth:bodyClientWidth;
          div1x1ImageObj.style.display="block";
          div1x1ImageObj.style.cursor="progress";//progress wait
          ptrPopup.document.body.style.overflow="hidden";

          window.addEventListener("resize",ptrResizeBlockImage,false);
        }

        if(ptrPopupArray.length==1&&ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          left=bodyScrollLeft+10;
          top=bodyScrollTop+10;
        }
        else if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          left=bodyScrollLeft+(bodyClientWidth-width)/2;
          top=bodyScrollTop+(bodyClientHeight-height)/2;
        }
        else{
          left=ptrPopupArray[ptrPopupArray.length-2].left+30;
          top=ptrPopupArray[ptrPopupArray.length-2].top+30;
        }
        if(ptrPopupArray.length>1 && ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modal"){
          ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex=
           parseInt(ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex)-100;
          if(ptrPopupArray[ptrPopupArray.length-2].oInnerPopup!=null)
            ptrPopupArray[ptrPopupArray.length-2].oInnerPopup.frame.object.style.zIndex=
             parseInt(ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex)+1;
        }
        else if(ptrPopupArray.length>1 && ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          for(var i=0;i<=ptrPopupArray.length-2;i++){
            ptrPopupArray[i].oPopup.frame.object.style.zIndex=
             parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)-100;
            ptrPopupArray[i].oInnerPopup.frame.object.style.zIndex=
             parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)+1;
          }
        }

        ptrPopupArray[ptrPopupArray.length-1].left=left;
        ptrPopupArray[ptrPopupArray.length-1].top=top;
        ptrPopupArray[ptrPopupArray.length-1].width=width;
        ptrPopupArray[ptrPopupArray.length-1].height=height;

        if(url.length==0){
          ptrPopupArray[ptrPopupArray.length-1].MIDWidth=ptrPopupArray[ptrPopupArray.length-1].width;
          ptrPopupArray[ptrPopupArray.length-1].MIDHeight=ptrPopupArray[ptrPopupArray.length-1].height;
        }

        oPopup.size.left=left;
        oPopup.size.top=top;
        if(url.length==0){
          iframePopupObj.style.left=left;
          iframePopupObj.style.top=top;
          oPopup.frame.object.style.display="block";
        }
        else{
          iframePopupObj.style.left=0;
          iframePopupObj.style.top=-5000;
          oPopup.frame.object.style.display="none";
          width=90;
          height=90;
        }

        var windowIframePopupObj=ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.window;

        var strDocument = "";
        if (ur_system.direction=="rtl")
          strDocument = "<html dir=\"rtl\"><head>";
        else
          strDocument = "<html><head>";
        if(ur_system.domainrelaxing!=sapUrDomainRelaxing.NONE)
          strDocument += strDomainRelaxScript;
        for(var n=0;n<oPopup.stylesheets.length;n++) {
          strDocument+= "<link rel=\"stylesheet\" href=\""+oPopup.stylesheets[n]+"\">";
        }
        strDocument += "<sc"+"ript>var me=null;if(parent.sapPopupStore["+oPopup.level+"]){me=parent.sapPopupStore["+oPopup.level+"].source.window;}"+"</sc"+"ript>";
        strDocument += "</head>";
        strDocument += "<body id=\"iframePopupBody\" oncontextmenu=\"return false;\" class=\"urBdyStd\" style=\"margin:0;overflow:hidden\">";

        width=width-2;
        height=height-2;

        var headerWidth=width-40<40?width:width-40;
        strDocument += "<a href=\"javascript:void(0)\" tabindex=\"0\" onfocus=\"document.getElementById('iframePopupDivHeaderA').focus();\"></a>";
        strDocument += "<div id=\"iframePopupDivOuterFrame\" class=\"urMnu urMnuRowOff\" style=\"border-width:1px;position:absolute;left:0;top:0;width:"+width+";height:"+height+";\">";
        strDocument += "<div id=\"iframePopupDivHeader\" class=\"urTbsLabelOn\" style='cursor:default;'>";
        strDocument +=  "<table width='100%' class=\"urGrpWhlBox\" style='font-size:11px;' cellspacing='0' cellpadding='0' border='0'><tr>";
        strDocument +=  "<td style='width:100%;padding-top:2px' onmousedown='me.ptrStartPopup(event,"+(ptrPopupArray.length-1)+","+mode+");return false;'";
        if(resize==true){
          strDocument += " ondblclick=\"me.ptrToggleModalDialog(event,"+(ptrPopupArray.length-1)+",document.getElementById('ptrPopupToggleIconId'));return false;\"";
        }
        strDocument +=  "><div id=\"iframePopupDivHeaderText\" class=\"urTxtEmph\" style='font-size:11px;white-space:nowrap;width:"+headerWidth+";color:white;overflow:hidden;' title='"+title+"'><a href='javascript:void(0);' tabindex='0' id='iframePopupDivHeaderA'></a>&nbsp;"+title+"</div></td>";
        if(resize==true){
          strDocument += "<td align='right' style='padding-right:2px;padding-top:2px'>";
          strDocument += "<a tabindex=\"0\" href='javascript:me.ptrToggleModalDialog(null,"+(ptrPopupArray.length-1)+",document.getElementById(\"ptrPopupToggleIconId\"))'><img border='0' id='ptrPopupToggleIconId' mode='MAX' src='"+ptrPopupMimepath+"maximize.gif' style='vertical-align:middle;cursor:pointer'></a></td>";
        }
        if(hasCloseButton==true){
          strDocument +=  "<td align='right' style='padding-right:2px;padding-top:2px'><a tabindex=\"0\" id=\"headerCancel\" href=\"javascript:me.ptrHideModalDialog(null,'CANCEL',"+(ptrPopupArray.length-1)+")\"><img border='0' src='"+ptrPopupMimepath+"close.gif' style='vertical-align:middle;cursor:pointer'></a></td>";
        }
        strDocument +=  "</tr></table>";
        strDocument += "</div>";

        height-=42;
        width-=4;

        if(url.length>0){
          var arr=new Array();
          ptrPopupArray[ptrPopupArray.length-1].oInnerPopup = new sapPopup(window,arr,div1x1ImageObj,null,null,iLevel+1);
          var oInnerPopup=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup;
          var iframeInnerPopupObj=oInnerPopup.frame.object;
          iframeInnerPopupObj.style.zIndex=parseInt(iframePopupObj.style.zIndex)+1;

          oInnerPopup.size.height=height;
          oInnerPopup.size.width=width;
          iframeInnerPopupObj.style.width="50px";
          iframeInnerPopupObj.style.height="50px";

          oInnerPopup.size.left=left+2;
          oInnerPopup.size.top=top+20;
          if(isFix==true)
            oInnerPopup.frame.object.style.display="block";
          else
            oInnerPopup.frame.object.style.display="none";
          iframeInnerPopupObj.style.left=0;
          iframeInnerPopupObj.style.top=-5000;

          var windowIframeInnerPopupObj=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.window;
          var strContent = "";
          if (ur_system.direction=="rtl")
            strContent = "<html dir=\"rtl\"><head>";
          else
            strContent = "<html><head>";
          if(ur_system.domainrelaxing!=sapUrDomainRelaxing.NONE)
            strContent += strDomainRelaxScript;

          strContent += "</head>";
          strContent += "<body id=\"ptrBodyLoading\" oncontextmenu=\"return false;\" style=\"background:white !imortant;margin:0;overflow:hidden\">";
          strContent += "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"height:100%;width:100%;\">";
          strContent += "<tbody><tr><td align=\"center\" style=\"font-family:Arial\"><span style=\"font-size:0.8em\">Loading...</span></table>";
          strContent += "<sc"+"ript>window.setTimeout(function(){location.href='"+url+"';},0);"+"</sc"+"ript>";
          strContent += "</body></html>";
          windowIframeInnerPopupObj.document.clear();
          windowIframeInnerPopupObj.document.write(strContent);
          windowIframeInnerPopupObj.document.close();
        }

        var messageIcon="";
        if(type.length>0){
          /*
            ptrMessageBox Types:
            PTR_WARNING     :A warning appears in the messagebox.
            PTR_INFORMATION :The information sign appears in the messagebox.
            PTR_QUESTION    :A question mark appears in the messagebox.
            PTR_ERROR       :A error sign appears in the messagebox.
            PTR_STOPP       :A stop sign appears in the messagebox.
          */
          if(type=="PTR_WARNING")
            messageIcon=ptrPopupMimepath+"s_m_warn.gif";
          else if(type=="PTR_INFORMATION")
            messageIcon=ptrPopupMimepath+"s_m_info.gif";
          else if(type=="PTR_QUESTION")
            messageIcon=ptrPopupMimepath+"s_m_ques.gif";
          else if(type=="PTR_ERROR")
            messageIcon=ptrPopupMimepath+"s_m_erro.gif";
          else if(type=="PTR_STOPP")
            messageIcon=ptrPopupMimepath+"s_m_crit.gif";
          else
            messageIcon=ptrPopupMimepath1x1+"1x1.gif";
        }

        if(messageIcon.length>0){
          strDocument += "<table width='100%' class=\"urGrpWhlBox\" style=\"table-layout:fixed;\" cellspacing='0' cellpadding='0' border='0'><tr>";
          strDocument += "<td width='50' align='center'";
          if(messageIcon!=(ptrPopupMimepath1x1+"1x1.gif"))
            strDocument += " class='urCellBgFill2'";
          strDocument += "><img src='"+messageIcon+"' alt=''></td>";
          if(url.length==0){
            var align=type.length>0?"left":"center";
            height-=20;if(height<20)height=20;
            strDocument += "<td style='padding:10;text-align:"+align+";vertical-align:middle;overflow:auto;'>";
            strDocument += "<div id='iframePopupDivInnerFrame' style='overflow:auto;height:"+height+";'>";
            strDocument += "<table class=\"urGrpWhlBox\" style='height:100%' cellspacing='0' cellpadding='0' border='0'><tr><td><div class='urTxtStd'>"+text+"</div></td></tr></table>";
            strDocument += "</div></td>";
          }
          else{
            strDocument += "<td><div id=\"iframePopupDivInnerFrame\"><a href='javascript:void(0)' tabindex=\"0\" onfocus=\"me.ptrPopupArray["+(ptrPopupArray.length-1)+"].oInnerPopup.frame.window.document.getElementById('ptrFocusStart2').focus();\"></a></div></td>";
          }
          strDocument += "</tr></table>";
        }
        else{
          strDocument += "<div id=\"iframePopupDivInnerFrame\" style=\"overflow:auto;position:relative;left:2px;top:1px;width:"+width+";height:"+height+";\"><a href='javascript:void(0)' tabindex=\"0\" onfocus=\"me.ptrPopupArray["+(ptrPopupArray.length-1)+"].oInnerPopup.frame.window.document.getElementById('ptrFocusStart2').focus();\"></a>";
          if(url.length==0){
            strDocument+=text;
          }
          strDocument+="</div>";
        }

        if(url.length>0){
          strDocument += "<a href='javascript:void(0);;' tabindex=\"0\" id=\"ptrToolbar\"></a>";
        }

        /*
        ptrMessageBox Styles:
        PTR_ABORTRETRYIGNORE :The messagebox contains Abort, Retry, and Ignore buttons.
        PTR_OK               :The messagebox contains OK button.
        PTR_NONE             :The messagebox contains Cancel button.
        PTR_CLOSE            :The messagebox contains Close button.
        PTR_OKCANCEL         :The messagebox contains OK and Cancel buttons.
        PTR_RETRYCANCEL      :The messagebox contains Retry and Cancel buttons.
        PTR_YESNO            :The messagebox contains Yes and No buttons.
        PTR_YESNOCANCEL      :The messagebox contains Yes, No, and Cancel buttons.
        */
        if(style.length>0){
          strDocument += '<table cellpadding="0" border="0" cellspacing="0" width="100%" class="urTbarDummy urTbarWhlEmph" style="margin-top:1px;font-size:11px;height:23px">';
          strDocument += '<tbody>';
          strDocument += '<tr>';
          strDocument += '<td valign="bottom" nowrap id="tb1" ct="Toolbar">';
          strDocument += '<img class="urTbarImg" src="'+ptrPopupMimepath1x1+'1x1.gif">';
          if(style=="PTR_ABORTRETRYIGNORE")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"ABORT","Abort");
          if(style=="PTR_CLOSE")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"CLOSE","Close");
          if(style=="PTR_ABORTRETRYIGNORE"||style=="PTR_RETRYCANCEL")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"RETRY","Retry");
          if(style=="PTR_ABORTRETRYIGNORE")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"IGNORE","Ignore");
          if(style=="PTR_OK"||style=="PTR_OKCANCEL")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"OK","OK");
          if(style=="PTR_YESNO"||style=="PTR_YESNOCANCEL")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"YES","Yes");
          if(style=="PTR_YESNO"||style=="PTR_YESNOCANCEL")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"NO","No");
          if(style=="PTR_OKCANCEL"||style=="PTR_RETRYCANCEL"||style=="PTR_YESNOCANCEL")
            strDocument += ptrToolbarButton(ptrPopupArray.length-1,"CANCEL","Cancel");
          strDocument += '<img class="urTbarImg" src="'+ptrPopupMimepath1x1+'1x1.gif">';
          strDocument += '<td valign="top" align="right" nowrap="nowrap">';
          strDocument += '<img class="urTbarImg" src="'+ptrPopupMimepath1x1+'1x1.gif">';
          if(resize==true){
            var align="right";
            if(ur_system.direction=="rtl"){
              align="left";
            }
            strDocument += '<td valign="bottom" align="'+align+'" nowrap="nowrap" style="width:16;padding:0;background-image:url('+ptrPopupMimepath+'resize.gif);background-position:bottom right;background-repeat:no-repeat;">';
            var cursorIcon="nw-resize";
            if(ur_system.direction=="rtl")
              cursorIcon="sw-resize";
            strDocument += '<img id="ptrPopupResizeIconId1" onmousedown="me.ptrStartPopup(event,'+(ptrPopupArray.length-1)+',false,true);return false;" style="cursor:'+cursorIcon+';width:16;height:16" src="'+ptrPopupMimepath1x1+'1x1.gif">';
            strDocument += '<img id="ptrPopupResizeIconId2" onmousedown="return false;" style="display:none;cursor:default;width:16;height:16" src="'+ptrPopupMimepath1x1+'1x1.gif">';
          }
          strDocument += '</table>';
        }
        strDocument += "</div><a href='javascript:void(0)' tabindex=\"0\" onfocus=\"document.getElementById('iframePopupDivHeaderA').focus();\"></a>";

        strDocument += "</body></html>";

        windowIframePopupObj.document.clear();
        windowIframePopupObj.document.write(strDocument);
        windowIframePopupObj.document.close();

        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal" && url.length==0){
          if(logout==true){
            ptrBlenLogoff(70);
          }
          else{
            ptrBlenLogoff();
          }
          var isOK=true;
          try{
            windowIframePopupObj.document.getElementById("OK").focus();
          }catch(e){isOK=false;}
          if(isOK==false){
            try{
              windowIframePopupObj.document.getElementById("headerCancel").focus();
            }catch(e){}
          }
        }
      }

      function ptrToolbarButton(index,id,text)
      {
        var strDocument = '<span class="urTbarItmBtn" id="'+id+'-r" show="true" cancollapse="false">';
        strDocument += '<a tabindex="0" onmouseover="window.status=\'\';return true;" href="javascript:void(0);" onclick="me.ptrHideModalDialog(event,\''+id+'\','+index+');" ';
        strDocument += 'class="urTbarBtnStd" style="font-size:11px;" id="'+id+'" ct="ToolbarButton" title="'+text+'">';
        strDocument += '<span style="white-space:nowrap;">'+text+'</span>';
        strDocument += '</a>';
        strDocument += '</span>';
        return strDocument;
      }

      var ptrToggle=false;
      function ptrBlenLogoff(blend)
      {
        if(typeof blend=="undefined")
          blend=ptrBlendOpacity;
        var div1x1ImageObj = document.getElementById("div1x1Image");
        if(ur_system.is508==false)
          div1x1ImageObj.style.MozOpacity=blend/100.0;
        div1x1ImageObj.style.backgroundColor="#999999";
      }

      function ptrMessageBox(sourceWindow,text,title,style,type)
      {
        if(typeof(type)=="undefined"||type.length==0)type="PTR_NONE";
        ptrShowModalDialog(sourceWindow,text,title,style,type);
      }

      function ptrModalDialogUrl(sourceWindow,url,title,style,width,height)
      {
        if(style.length==0)style="PTR_OKCANCEL";
        if(title.length==0)title="SAP Modal Dialog";
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=1024;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=660;
        ptrShowModalDialog(sourceWindow,'',title,style,'',width,height,url,false,false,true,false,'',true);
      }

      function ptrModalDialogWdr(sourceWindow,popupId,url,title,style,type,width,height,hasCloseButton)
      {
        if(style.length==0)style="PTR_OKCANCEL";
        if(title.length==0)title="SAP Webdynpro";
        if(typeof(type)=="undefined")type='';
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string");width=1024;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string");height=660;
        if(typeof(hasCloseButton)!="boolean")hasCloseButton=true;
        ptrShowModalDialog(sourceWindow,'',title,style,type,width,height,url,false,false,true,false,popupId,false,hasCloseButton);
      }

      function ptrModlessDialogUrl(sourceWindow,url,title,style,width,height)
      {
        if(style.length==0)style="PTR_OKCANCEL";
        if(title.length==0)title="SAP Modless Dialog";
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=1024;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=660;
        ptrShowModalDialog(sourceWindow,'',title,style,'',width,height,url,false,true,true,true,'',true);
      }

      function ptrModalDialog(sourceWindow,text,title,style,width,height)
      {
        ptrShowModalDialog(sourceWindow,text,title,style,'',width,height,'',false,false,true);
      }

      function ptrLogout(sourceWindow,text,title)
      {
        ptrShowModalDialog(sourceWindow,text,title,"PTR_YESNO","PTR_QUESTION",'250','95','',true,true);
      }

      function ptrShowModalDialog(sourceWindow,text,title,style,type,width,height,url,logout,mode,resize,modless,popupId,isFix,hasCloseButton)
      {
        if(typeof(sourceWindow)!="object")
          return;

        if(typeof(text)=="undefined"){
          text="Your request is beeing processed!";
        }
        if(typeof(title)=="undefined"){
          title="Please wait...";
        }
        if(typeof(style)=="undefined"){
          style="PTR_OK";
        }
        if(typeof(type)=="undefined"){
          type="";
        }
        if(typeof(width)=="undefined"){
          width=300;
        }
        if(typeof(height)=="undefined"){
          height=100;
        }
        if(typeof(url)=="undefined"){
          url="";
        }
        if(typeof(logout)=="undefined"){
          logout=false;
        }
        if(typeof(mode)=="undefined"){
          mode=false;
        }
        if(typeof(resize)=="undefined"){
          resize=false;
        }
        if(typeof(modless)=="undefined"){
          modless=false;
        }
        if(typeof(popupId)=="undefined"){
          popupId="";
        }
        if(typeof(isFix)=="undefined"){
          isFix=false;
        }
        if(typeof(hasCloseButton)=="undefined"){
          hasCloseButton=true;
        }

        ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton);
      }

      function ptrToggleModalDialog(event,index,imgObj)
      {
        if(imgObj.getAttribute("mode")=="MAX"){
          ptrToggle=true;
        }
        var windowIframePopupObj=ptrPopupArray[index].oPopup.frame.window;
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeader");
        var div1x1MoveImageObj=document.getElementById("div1x1MoveImage");
        div1x1MoveImageObj.innerHTML=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText").innerHTML;
          
        var height=iframePopupDivHeaderTextObj.clientHeight;
        var leftStart=0,leftEnd=0;     
        var rightStart=0,rightEnd=0;     
        var topStart=0,topEnd=0; 
        leftEnd=document.body.scrollLeft;
        leftStart=ptrPopupArray[index].left;
 
        widthEnd=document.body.clientWidth;
        widthStart=ptrPopupArray[index].MIDWidth;
        topEnd=document.body.scrollTop;
        topStart=ptrPopupArray[index].top; 

        window.setTimeout(function(){ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,10,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height);},0);
      }

      function ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,countAnimation,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height)
      {
        var left=0;
        var width=0;
        var top=0;
        var countAnimationBasis=parseInt(countAnimation)+1;

        div1x1MoveImageObj.style.display="block";

        var factor=imgObj.getAttribute("mode")=="MAX"?countAnimationBasis-countAnimation:countAnimation;
        if(countAnimation>0){
          left=leftStart-parseInt(((leftStart-leftEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          left=leftEnd;
        }
        else{
          left=leftStart;
        }

        if(countAnimation>0){
          width=widthStart-parseInt(((widthStart-widthEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          width=widthEnd;
        }
        else{
          width=widthStart;
        }

        if(countAnimation>0){
          top=topStart-parseInt(((topStart-topEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          top=topEnd;
        }
        else{
          top=topStart;
        }

        div1x1MoveImageObj.style.top=top;
        div1x1MoveImageObj.style.left=left;
        div1x1MoveImageObj.style.width=width;
        div1x1MoveImageObj.style.height=height;//"16px";

        countAnimation--;
        if(countAnimation>=0){
          window.setTimeout(function(){ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,countAnimation,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height);},0);
        }
        else{
          window.setTimeout(function(){ptrInitModalDialog(null,imgObj);},0);
          ptrToggle=false;
        }        
      }

      function ptrResizeModalDialog(popupId)
      {
        var currentIndex=ptrPopupArray.length-1;
        var translationObj=null;
        if(typeof(popupId)!="undefined" && popupId.length>0){
          for(var i=0;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].popupId==popupId){
              currentIndex=i;
              translationObj={popupId:popupId};
            }
          }
        }
      
        if(ptrPopupArray[currentIndex].oInnerPopup==null){
          return;
        }
        var ptrBodyLoadingObj=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body;
        if(ptrBodyLoadingObj.id=="ptrBodyLoading"){
          return;
        }
        if(ptrPopupArray[currentIndex].oInnerPopup!=null){
          ptrCheckFocus(currentIndex);
        }
        var imgObj=ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupToggleIconId");
        if(imgObj.getAttribute("mode")=="MAX"){
          ptrInitModalDialog(translationObj,null,true);
        }
      }

      function ptrInitModalDialogLabels(translationObj,currentIndex)
      {
        if(typeof(translationObj.ABORT)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ABORT")!=null){
          if(typeof(translationObj.ABORT.title)!="undefined"||typeof(translationObj.ABORT.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ABORT").title=typeof(translationObj.ABORT.title)!="undefined"?translationObj.ABORT.title:translationObj.ABORT.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ABORT").innerHTML='<span style="white-space:nowrap;">'+translationObj.ABORT.text+'</span>';
        }
        if(typeof(translationObj.CLOSE)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CLOSE")!=null){
          if(typeof(translationObj.CLOSE.title)!="undefined"||typeof(translationObj.CLOSE.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CLOSE").title=typeof(translationObj.CLOSE.title)!="undefined"?translationObj.CLOSE.title:translationObj.CLOSE.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CLOSE").innerHTML='<span style="white-space:nowrap;">'+translationObj.CLOSE.text+'</span>';
        }
        if(typeof(translationObj.RETRY)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("RETRY")!=null){
          if(typeof(translationObj.RETRY.title)!="undefined"||typeof(translationObj.RETRY.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("RETRY").title=typeof(translationObj.RETRY.title)!="undefined"?translationObj.RETRY.title:translationObj.RETRY.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("RETRY").innerHTML='<span style="white-space:nowrap;">'+translationObj.RETRY.text+'</span>';
        }
        if(typeof(translationObj.IGNORE)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("IGNORE")!=null){
          if(typeof(translationObj.IGNORE.title)!="undefined"||typeof(translationObj.IGNORE.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("IGNORE").title=typeof(translationObj.IGNORE.title)!="undefined"?translationObj.IGNORE.title:translationObj.IGNORE.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("IGNORE").innerHTML='<span style="white-space:nowrap;">'+translationObj.IGNORE.text+'</span>';
        }
        if(typeof(translationObj.OK)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("OK")!=null){
          if(typeof(translationObj.OK.title)!="undefined"||typeof(translationObj.OK.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("OK").title=typeof(translationObj.OK.title)!="undefined"?translationObj.OK.title:translationObj.OK.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("OK").innerHTML='<span style="white-space:nowrap;">'+translationObj.OK.text+'</span>';
        }
        if(typeof(translationObj.YES)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("YES")!=null){
          if(typeof(translationObj.YES.title)!="undefined"||typeof(translationObj.YES.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("YES").title=typeof(translationObj.YES.title)!="undefined"?translationObj.YES.title:translationObj.YES.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("YES").innerHTML='<span style="white-space:nowrap;">'+translationObj.YES.text+'</span>';
        }
        if(typeof(translationObj.NO)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("NO")!=null){
          if(typeof(translationObj.NO.title)!="undefined"||typeof(translationObj.NO.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("NO").title=typeof(translationObj.NO.title)!="undefined"?translationObj.NO.title:translationObj.NO.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("NO").innerHTML='<span style="white-space:nowrap;">'+translationObj.NO.text+'</span>';
        }
        if(typeof(translationObj.CANCEL)!="undefined"&&ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CANCEL")!=null){
          if(typeof(translationObj.CANCEL.title)!="undefined"||typeof(translationObj.CANCEL.tooltip)!="undefined")
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CANCEL").title=typeof(translationObj.CANCEL.title)!="undefined"?translationObj.CANCEL.title:translationObj.CANCEL.tooltip;
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("CANCEL").innerHTML='<span style="white-space:nowrap;">'+translationObj.CANCEL.text+'</span>';
        }

        if(typeof(translationObj.title)!="undefined"){
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("iframePopupDivHeaderText").innerHTML=translationObj.title;
        }
      }
      
      function ptrInitModalDialog(translationObj,imgObj,resize)
      {
        if(ptrPopupArray.length==0)return;

        var currentIndex=ptrPopupArray.length-1;
        var isFix=ptrPopupArray[currentIndex].isFix;
        if(typeof(translationObj)!="undefined" && translationObj!=null){
          if(typeof(translationObj.popupId)!="undefined"){
            for(var i=0;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].popupId==translationObj.popupId){
                currentIndex=i;
                isFix=ptrPopupArray[currentIndex].isFix;
              }
            }
          }
          ptrInitModalDialogLabels(translationObj,currentIndex);
        }

        if(typeof(imgObj)=="undefined"){
          imgObj=null;
        }

        if(typeof(resize)=="undefined"){
          resize=false;
        }

        if(ptrPopupArray[currentIndex].dialogMode=="modless"){
          var zIndex=parseInt(ptrPopupArray[currentIndex].oPopup.frame.object.style.zIndex);
          for(var i=0;i<ptrPopupArray.length-1;i++){
            if(parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)>zIndex){
              zIndex=parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex);
              currentIndex=i;
              isFix=ptrPopupArray[currentIndex].isFix;
            }
          }
        }

        ptrPopupArray[currentIndex].isInitial=false;

        var sourceWindow=ptrPopupArray[currentIndex].sourceWindow;
        var iframeWindow=null;
        if(ptrPopupArray[currentIndex].oInnerPopup!=null){
          iframeWindow=ptrPopupArray[currentIndex].oInnerPopup.frame.window;
          iframeWindow.sourceWindow=sourceWindow;
        }

        if(imgObj==null && ptrPopupArray[currentIndex].oPopup.frame.object.style.display=="block" && resize==false && isFix==false){
          return iframeWindow;
        }

        ptrPopupArray[currentIndex].oPopup.frame.object.style.left="-5000px";
        ptrPopupArray[currentIndex].oPopup.frame.object.style.top="-5000px";
        ptrPopupArray[currentIndex].oPopup.frame.object.style.display="block";
        if(iframeWindow!=null){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left="-5000px";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.top="-5000px";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.display="block";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.scrolling="auto";
        }

        var left=0;
        var top=0;
        var width=0;
        var height=0;

        var windowIframePopupObj=ptrPopupArray[currentIndex].oPopup.frame.window;
        var iframePopupDivOuterFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame");
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText");
        var iframePopupDivInnerFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivInnerFrame");

        var showSrollbars=false;

        if(iframeWindow!=null){
          width=iframeWindow.document.body.scrollWidth;
        }
        else{
          width=ptrPopupArray[currentIndex].width;
        }
          
        if(ptrPopupArray[currentIndex].isFix==true){
          width=ptrPopupArray[currentIndex].width;
        }

        if(imgObj!=null && imgObj.getAttribute("mode")=="MAX"){
          width=document.body.clientWidth;
        }
        else if(imgObj!=null && imgObj.getAttribute("mode")=="MID"){
          width=ptrPopupArray[currentIndex].MIDWidth;
        }
        else if(imgObj==null){
          if(width>ptrPopupArray[currentIndex].width){
            width=ptrPopupArray[currentIndex].width;
          }
          if(width>document.body.offsetWidth-24){
            width=document.body.offsetWidth-24;
          }
          width+=4;
        }
        if(imgObj==null && ptrPopupArray[currentIndex].type.length>0){
          width+=50;
        }

        if(width>=ptrPopupArray[currentIndex].width||width>=document.body.offsetWidth-24){
          showSrollbars=true;
        }
 
        if(imgObj!=null && imgObj.getAttribute("mode")=="MAX"){
          left=document.body.scrollLeft;
        }
        else if(imgObj!=null && imgObj.getAttribute("mode")=="MID"){
          left=ptrPopupArray[currentIndex].left;
        }
        else if(imgObj==null){
          if(resize==true){
            left=ptrPopupArray[currentIndex].left;
          }
          else if(ptrPopupArray.length==1&&ptrPopupArray[currentIndex].dialogMode=="modless"){
            left=document.body.scrollLeft+10;
          }
          else if(ptrPopupArray[currentIndex].dialogMode=="modless"){
            if(document.body.offsetWidth>(ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth+width))
              left=ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth;
            else
              left=document.body.scrollLeft+10;
          }          
          else if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
            left=document.body.scrollLeft+(document.body.offsetWidth-width)/2;
            for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].isInitial==false)
                ptrPopupArray[i].left=left+(i-currentIndex)*30;
            }
          }
          else{
            left=0;
            for(var i=0;i<=currentIndex;i++){
              if(ptrPopupArray[i].dialogMode=="startModal"){
                left=ptrPopupArray[i].left;
              }
              else if(left>0){
                left+=30;
              }
            }
          }
        }

        if(imgObj==null){    
          ptrPopupArray[currentIndex].left=left;
          ptrPopupArray[currentIndex].MIDWidth=width;
        }

        ptrPopupArray[currentIndex].oPopup.size.left=left;
        ptrPopupArray[currentIndex].oPopup.size.width=width;

        ptrPopupArray[currentIndex].oPopup.frame.object.style.left=left;
        ptrPopupArray[currentIndex].oPopup.frame.object.style.width=width;

        width=width-2;

        iframePopupDivOuterFrameObj.style.width=width;
        iframePopupDivInnerFrameObj.style.width=width-4;
        iframePopupDivHeaderTextObj.style.width=width-40;
        if(iframeWindow!=null){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width=width-2;
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left=left+2;
          if(ptrPopupArray[currentIndex].type.length>0){
            ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left=parseInt(ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left)+50;
            ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width=parseInt(ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width)-50;
          }
        }

        if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
          for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].isInitial==false){
              ptrPopupArray[i].oPopup.size.left=ptrPopupArray[i].left;
              ptrPopupArray[i].oPopup.frame.object.style.left=ptrPopupArray[i].left;
              if(iframeWindow!=null){
                ptrPopupArray[i].oInnerPopup.frame.object.style.left=ptrPopupArray[i].left+2;
              }
            }
          }
        }

        if(ptrPopupArray[currentIndex].isFix==true){
          height=ptrPopupArray[currentIndex].height;
        }
        else if(iframeWindow!=null){
          height=iframeWindow.document.body.scrollHeight;
        }
        else{
          height=ptrPopupArray[currentIndex].height;
        }

        if(imgObj!=null && imgObj.getAttribute("mode")=="MAX"){
          height=document.body.clientHeight;
        }
        else if(imgObj!=null && imgObj.getAttribute("mode")=="MID"){
          height=ptrPopupArray[currentIndex].MIDHeight;
        }
        else if(imgObj==null){
          if(height>ptrPopupArray[currentIndex].height){
            height=ptrPopupArray[currentIndex].height;
          }
          if(height>document.body.offsetHeight-66){
            height=document.body.offsetHeight-66;
          }
          height+=46;
        }
        if(height>=ptrPopupArray[currentIndex].height||height>=document.body.offsetHeight-66){
          showSrollbars=true;
        }

        if(imgObj!=null && imgObj.getAttribute("mode")=="MAX"){
          top=document.body.scrollTop;
        }
        else if(imgObj!=null && imgObj.getAttribute("mode")=="MID"){
          top=ptrPopupArray[currentIndex].top;
        }
        else if(imgObj==null){          
          if(resize==true){
            top=ptrPopupArray[currentIndex].top;
          }
          else if(ptrPopupArray.length==1&&ptrPopupArray[currentIndex].dialogMode=="modless"){
            top=document.body.scrollTop+10;
          }
          else if(ptrPopupArray[currentIndex].dialogMode=="modless"){
            if(document.body.offsetWidth>(ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth+width))
              top=ptrPopupArray[currentIndex-1].top;
            else
              top=ptrPopupArray[currentIndex-1].top+ptrPopupArray[currentIndex-1].MIDHeight;
          }          
          else if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
            top=document.body.scrollTop+(document.body.offsetHeight-height)/2;
            for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].isInitial==false)
                ptrPopupArray[i].top=top+(i-currentIndex)*30;
            }
          }
          else{
            top=0;
            for(var i=0;i<=currentIndex;i++){
              if(ptrPopupArray[i].dialogMode=="startModal"){
                top=ptrPopupArray[i].top;
              }
              else if(top>0){
                top+=30;
              }
            }
          }
        }

        if(imgObj==null){
          ptrPopupArray[currentIndex].top=top;
          ptrPopupArray[currentIndex].MIDHeight=height;
        }

        ptrPopupArray[currentIndex].oPopup.size.top=top;
        ptrPopupArray[currentIndex].oPopup.size.height=height;

        ptrPopupArray[currentIndex].oPopup.frame.object.style.top=top;
        ptrPopupArray[currentIndex].oPopup.frame.object.style.height=height;

        height=height-2;

        iframePopupDivOuterFrameObj.style.height=height;
        iframePopupDivInnerFrameObj.style.height=height-42;
        if(iframeWindow!=null){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.height=height-42;
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.top=top+20;
        }

        if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
          for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].isInitial==false){
              ptrPopupArray[i].oPopup.size.top=ptrPopupArray[i].top;
              ptrPopupArray[i].oPopup.frame.object.style.top=ptrPopupArray[i].top;
              if(iframeWindow!=null){
                ptrPopupArray[i].oInnerPopup.frame.object.style.top=ptrPopupArray[i].top+20;
              }
            }
          }
        }

        if(iframeWindow!=null && showSrollbars==false){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.scrolling="no";
        }

        if(imgObj!=null){
          var div1x1MoveImageObj=document.getElementById("div1x1MoveImage");
          div1x1MoveImageObj.style.display="none";  
        }
        if(imgObj!=null && imgObj.getAttribute("mode")=="MAX"){
          imgObj.setAttribute("mode","MID");
          ptrPopupArray[currentIndex].mode="MID";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId1").style.display="none";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId2").style.display="block";
          imgObj.src=ptrPopupMimepath+"restore.gif";      
        }
        else if(imgObj!=null && imgObj.getAttribute("mode")=="MID"){
          imgObj.setAttribute("mode","MAX");
          ptrPopupArray[currentIndex].mode="MAX";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId1").style.display="block";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId2").style.display="none";
          imgObj.src=ptrPopupMimepath+"maximize.gif";
        }

        if(imgObj==null && ptrPopupArray[currentIndex].dialogMode=="startModal" && resize==false){
          ptrBlenLogoff();
        }

        if(imgObj==null && currentIndex==ptrPopupArray.length-1){
          var hasFocus=true;
          try{
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("OK").focus();
          }
          catch(e){hasFocus=false;}
          if(hasFocus==false){
            hasFocus=true;
            try{
              ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("headerCancel").focus();
            }
            catch(e){hasFocus=false;}
          }
        }
        if(imgObj==null && ptrPopupArray[currentIndex].oInnerPopup!=null){
          ptrCheckFocus(currentIndex);
        }

        return iframeWindow;
      }

      function ptrCheckFocus(currentIndex)
      { 
        var documentBody=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body;
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusStart2")==null){
          var spanFocusStart2=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusStart2.id="ptrFocusStart2";
          spanFocusStart2.tabIndex="0";
          spanFocusStart2.href='javascript:void(0);';
          documentBody.insertBefore(spanFocusStart2,documentBody.childNodes[0]);
        }
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusStart1")==null){
          var spanFocusStart1=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusStart1.id="ptrFocusStart1";
          spanFocusStart1.tabIndex="0";
          spanFocusStart1.href='javascript:void(0);';
          spanFocusStart1.addEventListener("focus",function(){try{ptrPopup.ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById('headerCancel').focus();}catch(e){}},false);
          documentBody.insertBefore(spanFocusStart1,documentBody.childNodes[0]);
        }
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusEnd")==null){
          var spanFocusEnd=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusEnd.id="ptrFocusEnd";
          spanFocusEnd.tabIndex="0";
          spanFocusEnd.href='javascript:void(0);';
          spanFocusEnd.addEventListener("focus",function(){try{ptrPopup.ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById('ptrToolbar').focus();}catch(e){}},false);
          documentBody.appendChild(spanFocusEnd);
        }
      }

      function ptrGetSourceWindow(currentIndex)
      {
        if(typeof currentIndex=="undefined")
          currentIndex=ptrPopupArray.length-1;
        var sourceWindow=ptrPopupArray[currentIndex].sourceWindow;
        return sourceWindow;
      }

      function ptrCloseModalDialog(popupId,okCode)
      {
        if(typeof(okCode)=="undefined"){
          okCode="";
        }
        var currentIndex=ptrPopupArray.length-1;
        if(typeof(popupId)!="undefined" && popupId.length>0){
          for(var i=0;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].popupId==popupId){
              currentIndex=i;
            }
          }
        }

        ptrHideModalDialog(null,okCode,currentIndex);
      }

      function ptrHideModalDialog(event,id,index)
      {
        if(typeof ptrPopupArray=="undefined"||ptrPopupArray.length==0)return;
        if(typeof index=="undefined")index=ptrPopupArray.length-1;
        var close=true;
        if(ptrPopupArray[index].oInnerPopup!=null){
          var iframeInnerPopupWindow=ptrPopupArray[index].oInnerPopup.frame.window;
          try{
            close=iframeInnerPopupWindow.ptrOnHideModalDialog(id);
          }
          catch(e){};
        }
        var sourceWindow=ptrPopupArray[index].sourceWindow; 
        try{
          close=sourceWindow.ptrOnHideModalDialog(id);
        }
        catch(e){};
        if(close==true){
          //Unblock ActiveX Controls...
          for(var i=0;i<ptrActiveXArray.length;i++){
            var item=ptrActiveXArray[i];
            if(item.isActive==true && item.enable==true){
              try{
                item.ptrFunction();
              }
              catch(e){}
            }
          }

          var div1x1ImageObj = document.getElementById("div1x1Image");
          if(ptrPopupArray[index].dialogMode=="startModal"){
            div1x1ImageObj.style.cursor="default";
            div1x1ImageObj.style.backgroundColor="";
            div1x1ImageObj.style.display="none";
            ptrPopup.document.body.style.overflow=ptrPopupArray[index].overflow;
          }
          ptrPopupArray[index].oPopup.frame.object.style.top="-5001"; 
          if (ur_system.direction=="rtl") {
            ptrPopupArray[index].oPopup.frame.object.style.right="0px";
          } else {
            ptrPopupArray[index].oPopup.frame.object.style.left="0px";
          }
          //ptrPopupArray[index].oPopup.frame.object.style.display = "none";
          if(ptrPopupArray[index].oInnerPopup!=null){
            ptrPopupArray[index].oInnerPopup.frame.object.style.top="-5001"; 
            if (ur_system.direction=="rtl") {
              ptrPopupArray[index].oInnerPopup.frame.object.style.right="0px";
            } else {
              ptrPopupArray[index].oInnerPopup.frame.object.style.left="0px";
            }
            //ptrPopupArray[index].oInnerPopup.frame.object.style.display = "none";
          }
          
          if(ptrPopupArray[index].dialogMode=="startModal"||
              ptrPopupArray[index].dialogMode=="modal"||
               (ptrPopupArray[index].dialogMode=="modless"&&index==ptrPopupArray.length-1)){
            if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null)
              sapPopupStore.pop();
            sapPopupStore.pop();
            ptrPopupArray.pop();
            while(ptrPopupArray.length>0&&ptrPopupArray[ptrPopupArray.length-1].showDialog==false){
              if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null)
                sapPopupStore.pop();
              sapPopupStore.pop();
              ptrPopupArray.pop();
            }
          }
          else if(ptrPopupArray[index].dialogMode=="modless"&&index!=ptrPopupArray.length-1){
            ptrPopupArray[index].showDialog=false;
          }
          if(ptrPopupArray.length>0 && ptrPopupArray[ptrPopupArray.length-1].dialogMode!="modless"){
            var iframePopupObj=ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.object;
            iframePopupObj.style.zIndex=4999+2*ptrPopupArray.length;
            if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
              var iframeInnerPopupObj=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.object;
              iframeInnerPopupObj.style.zIndex=parseInt(iframePopupObj.style.zIndex)+1;
            }
          }
        }
      }

      function ptrStartPopup(event,index,mode,resize)
      {
        if(ptrPopupArray[index].dialogMode=="modless" && ptrPopupArray.length>0){
          var iframePopupObj1=ptrPopupArray[index].oPopup.frame.object;
          var zIndex1=parseInt(iframePopupObj1.style.zIndex);
          var iframePopupObj2=null;
          var zIndex2=0;
          var topIndex=0;
          for(var i=0;i<ptrPopupArray.length;i++){
            if(parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)>zIndex2){
              iframePopupObj2=ptrPopupArray[i].oPopup.frame.object;
              zIndex2=parseInt(iframePopupObj2.style.zIndex);
              topIndex=i;
            }
          }
          if(index!=topIndex){
            iframePopupObj1.style.zIndex=zIndex2;
            iframePopupObj2.style.zIndex=zIndex1;

            var iframeInnerPopupObj1=ptrPopupArray[index].oInnerPopup.frame.object;
            var iframeInnerPopupObj2=ptrPopupArray[topIndex].oInnerPopup.frame.object;
            iframeInnerPopupObj1.style.zIndex=parseInt(iframePopupObj1.style.zIndex)+1;
            iframeInnerPopupObj2.style.zIndex=parseInt(iframePopupObj2.style.zIndex)+1;
          }
        }

        if(ptrPopupArray[index].mode=="MID")
          return false;

        if(typeof(mode)!="boolean"){
          mode=false;
        }
        if(typeof(resize)!="boolean"){
          resize=false;
        }

        var iframePopupObj=ptrPopupArray[index].oPopup.frame.object;
        var windowIframePopupObj=ptrPopupArray[index].oPopup.frame.window;

        var iframeInnerPopupObj=null;
        var windowIframeInnerPopupObj=null;
        if(ptrPopupArray[index].oInnerPopup!=null){
          iframeInnerPopupObj=ptrPopupArray[index].oInnerPopup.frame.object;
          windowIframeInnerPopupObj=ptrPopupArray[index].oInnerPopup.frame.window;
        }

        var target=event.target;

        var iframePopupDivOuterFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame");
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText");
        var iframePopupDivInnerFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivInnerFrame");

        var data = {
          target:target,
          startX:parseInt(iframePopupObj.style.left),
          startY:parseInt(iframePopupObj.style.top),
          startW:parseInt(iframePopupObj.style.width),
          startH:parseInt(iframePopupObj.style.height),
          x:event.screenX,
          y:event.screenY,
          iframePopupObj:iframePopupObj,
          windowIframePopupObj:windowIframePopupObj,
          windowIframeInnerPopupObj:windowIframeInnerPopupObj,
          iframeInnerPopupObj:iframeInnerPopupObj,
          event:event,
          index:index,
          mode:mode
        };
        ptrStartPopup.data=data;

        windowIframePopupObj.document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
        windowIframePopupObj.document.documentElement.addEventListener("mouseup",ptrEndPopup,true);
        if(windowIframeInnerPopupObj!=null){
          windowIframeInnerPopupObj.document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
          windowIframeInnerPopupObj.document.documentElement.addEventListener("mouseup",ptrEndPopup,true);
        }
        document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
        document.documentElement.addEventListener("mouseup",ptrEndPopup,true);

        if(resize==true){
          var dataResize = {
            windowIframePopupBody:ptrPopupArray[index].oInnerPopup!=null?ptrPopupArray[index].oInnerPopup.frame.window.document.body:null,
            iframePopupDivOuterFrameObj:iframePopupDivOuterFrameObj,
            iframePopupDivOuterFrameWidth:parseInt(iframePopupDivOuterFrameObj.style.width),
            iframePopupDivOuterFrameHeight:parseInt(iframePopupDivOuterFrameObj.style.height),

            iframePopupDivHeaderTextObj:iframePopupDivHeaderTextObj,
            iframePopupDivHeaderTextWidth:parseInt(iframePopupDivHeaderTextObj.style.width),

            iframePopupDivInnerFrameObj:iframePopupDivInnerFrameObj,
            iframePopupDivInnerFrameWidth:parseInt(iframePopupDivInnerFrameObj.style.width),
            iframePopupDivInnerFrameHeight:parseInt(iframePopupDivInnerFrameObj.style.height)
          };
          ptrStartPopup.dataResize=dataResize;
        }
      }

      function ptrMovePopup(event)
      {
        event.cancelBubble=true;

        var data=ptrStartPopup.data;
        if(typeof(data)!="object") return;

        var dataResize=ptrStartPopup.dataResize;

        if(typeof(dataResize)=="object" && dataResize!=null){
          if(data.iframeInnerPopupObj!=null)
            data.iframeInnerPopupObj.scrolling="auto";
          var width=data.startW+data.event.screenX-data.x;
          if(width>90){
            data.iframePopupObj.style.width=data.startW+data.event.screenX-data.x;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.width=data.startW+data.event.screenX-data.x-4;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.width=parseInt(data.iframePopupObj.style.width)-54;
              }
            }

            dataResize.iframePopupDivOuterFrameObj.style.width=dataResize.iframePopupDivOuterFrameWidth+data.event.screenX-data.x;
            dataResize.iframePopupDivInnerFrameObj.style.width=dataResize.iframePopupDivInnerFrameWidth+data.event.screenX-data.x;

            dataResize.iframePopupDivHeaderTextObj.style.width=dataResize.iframePopupDivHeaderTextWidth+data.event.screenX-data.x;
          }
        }
        else{
          data.iframePopupObj.style.left=data.startX+data.event.screenX-data.x;
          if(data.iframeInnerPopupObj!=null){
            data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
            if(ptrPopupArray[data.index].type.length>0){
              ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+52;
            }
          }
        }
        if(data.mode==true){
          var width=document.body.clientWidth-ptrPopupArray[data.index].MIDWidth;
          if(parseInt(data.iframePopupObj.style.left)<1){
            data.iframePopupObj.style.left=1;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+52;
              }
            }
          }
          if(data.iframePopupObj.style.left>width){
            data.iframePopupObj.style.left=width;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+52;
              }
            }
          }
        }
        ptrPopupArray[data.index].left=parseInt(data.iframePopupObj.style.left);

        if(typeof(dataResize)=="object" && dataResize!=null){
          var height=data.startH+data.event.screenY-data.y;
          if(height>90){
            data.iframePopupObj.style.height=data.startH+data.event.screenY-data.y;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.height=data.startH+data.event.screenY-data.y-44;

            dataResize.iframePopupDivOuterFrameObj.style.height=dataResize.iframePopupDivOuterFrameHeight+data.event.screenY-data.y;
            dataResize.iframePopupDivInnerFrameObj.style.height=dataResize.iframePopupDivInnerFrameHeight+data.event.screenY-data.y;
          }
        }
        else{
          data.iframePopupObj.style.top=data.startY+data.event.screenY-data.y;
          if(data.iframeInnerPopupObj!=null)
            data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+20;
        }
        if(data.mode==true){
          var height=document.body.clientHeight-30;
          if(parseInt(data.iframePopupObj.style.top)<1){
            data.iframePopupObj.style.top=1;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+20;
          }
          if(data.iframePopupObj.style.top>height){
            data.iframePopupObj.style.top=height;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+20;
          }
        }
        ptrPopupArray[data.index].top=parseInt(data.iframePopupObj.style.top);
      }

      function ptrEndPopup()
      {
        if(typeof(ptrStartPopup.data)!="object")
          return;

        var windowIframePopupObj=ptrStartPopup.data.windowIframePopupObj;
        windowIframePopupObj.document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
        windowIframePopupObj.document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);
        var windowIframeInnerPopupObj=ptrStartPopup.data.windowIframeInnerPopupObj;
        if(windowIframeInnerPopupObj!=null){
          windowIframeInnerPopupObj.document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
          windowIframeInnerPopupObj.document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);
        }
        document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
        document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);

        ptrStartPopup.data=null;
        if(typeof(ptrStartPopup.dataResize)=="object" && ptrStartPopup.dataResize!=null)
          ptrStartPopup.dataResize=null;
      }
