var styleArray = new Array();
var elementRefArray = new Array();
var impactArray = new Array();
var overlapArray = new Array();

function prepareStylesheet( styleArrayspecific, themePart ){
	if( styleArrayspecific == null ) return;

	var cascadeArray = new Array();
	var i;
	var styleArrayspecificLength = styleArrayspecific.length;
	for(i=0; i < styleArrayspecificLength; i++){
		
//		if( impactArray[i] == null ) impactArray[i] = new Array();
		if( styleArray[i] == null ) styleArray[i] = new Array();
		var styles = styleArray[i];

		var  styleString  = styleArrayspecific[i];

		if( styleString != null ){
			var ar = styleString.split(",");
			var j;
			var arLength = ar.length;
			for(j=0; j < arLength; j++ ){
				var test = ar[j];
				//isolate theme parts which have global impact
				if( themePart != null ) { 
					test = "#" + themePart + " " + test;
				}

				var k;
				var found = false;
				var stylesLength = styles.length;
				for(k=0; k < stylesLength; k++){
					var style = styles[k];
					if( style == test ) { found = true; break; }
				}
				if( !found ) {
					styles[ stylesLength ] = test;
				
					var testSplit = test.split(" ");
					if( testSplit.length > 1 )
					{
						if( testSplit[ testSplit.length - 1 ] != "*" )
						{
							var m;
							var found = false;
							for(m=0; m < cascadeArray.length; m++ )
							{
								var cascade = cascadeArray[ m ];
								if( cascade == test ){ found = true; break; }
							}
							if( !found ) cascadeArray[ cascadeArray.length ] = test;
						}
					}	
				}
			}
		}
	}
	
	for(i=0; i<cascadeArray.length; i++)
	{
		var selector = cascadeArray[ i ];
						
		var selectorPartArray = selector.split(" ");
		
		if( selectorPartArray.length == 0 ) continue;
		if( selectorPartArray.length == 1 ) continue;

		var selectorPart = selectorPartArray[ selectorPartArray.length - 1 ];
		if( overlapArray[ selectorPart ] == null ) overlapArray[ selectorPart ] = new Array();

		//trim selector
		var j = selector.length - 1;
		var trimmed = false;
		while( selector.charAt( j ) == ' ' ) { trimmed = true; j--; }
		
		if( trimmed ) selector = selector.substring( 0, j + 1 );
		
		overlapArray[ selectorPart ][ overlapArray[ selectorPart ].length ] = selector;
	}
}

function isChildOf( element, curElement )
{
	var parentElement = element.parentElement
	if( parentElement != null )
	{
		if( parentElement == curElement ) return true;
		return( parentElement, curElement );
	}
	return false;
}

function prepare(){

	removeHoverDivs();
	hoverDivs = new Array();

	elementRefArray = new Array();

	var elements = document.all;
	var i;
	for(i=0;i < elements.length;i++)
	{
		var element = elements[i];
		var className = element.className;
		
		containedClassNames = className.split(" "); //IE supports classes="class1 class2 ... "
		
		for(j=0; j<containedClassNames.length; j++)
		{
			className = containedClassNames[j];
			if( ( className != null ) && ( className != "" ) ){
				var ref = elementRefArray[className];
				if( ref == null ) {
					elementRefArray[className] = new Array();
					ref = elementRefArray[className];
				}
				ref[ref.length] = element;
				//add oncontextmenu
				if( element.currentStyle.backgroundImage != null )
				{
					if( window.showDownloadImage != null )
						element.oncontextmenu = window.showDownloadImage;
					else element.oncontextmenu = parent.showDownloadImage;
				}
			}
		}
	}
}

function isSelectorChain( selectorPartElement, selectorParts, selectorPartIndex, section )
{
	var selectorPartElementParentElement = selectorPartElement.parentElement;
	if( selectorPartElementParentElement == null ) return false;
	
	var selectorPart = selectorParts[ selectorPartIndex ];
	
	if( selectorPart.substring(0,1) == "." )
	{
		//its a class
		var className = selectorPart.substring(1,selectorPart.length);

		if( selectorPartElementParentElement.className == className )
		{
			if( selectorPartIndex == 0 ) return true;
			else return isSelectorChain( selectorPartElementParentElement, selectorParts, selectorPartIndex - 1, section );
		}
		else return isSelectorChain( selectorPartElementParentElement, selectorParts, selectorPartIndex, section );
		
	}
	if( selectorPart.substring(0,1) == "*" ) alert("not yet supported" );
	else
	{
		//its a tag
		var tagName = selectorPart;
		
		var dotIndex = tagName.indexOf(".");
		
		var match = false;
		if( dotIndex == -1 )
		{
			match = ( selectorPartElementParentElement.tagName == tagName );
		}
		else
		{
			var tagName = selectorPart.substring( 0, dotIndex );
			var className = selectorPart.substring( dotIndex + 1, selectorPart.length );
			
			match = ( ( selectorPartElementParentElement.tagName == tagName ) && ( selectorPartElementParentElement.className == className ) );
		} 
		if( match )
		{
			if( selectorPartIndex == 0 ) return true;
			else return isSelectorChain( selectorPartElementParentElement, selectorParts, selectorPartIndex - 1, section );
		}
		else return isSelectorChain( selectorPartElementParentElement, selectorParts, selectorPartIndex, section );

	}
	return false;
}

function getSelectorPartElements( selectorPart, section )
{
	if( selectorPart.substring(0,1) == "." )
	{
		//selectorPart = .class
		var className = selectorPart.substring(1,selectorPart.length);
		return elementRefArray[ className ];
	}
	if( selectorPart.substring(0,1) == "*" ) return section.all;
	
	
	
	//its a tag
	var dotIndex = selectorPart.indexOf(".");

	if( dotIndex != -1 )
	{
		//selectorPart = tag.class
		var tagName = selectorPart.substring( 0, dotIndex );
		var className = selectorPart.substring( dotIndex + 1, selectorPart.length );
		
		var tagObjects = section.tags( tagName );
		var resultArray = new Array();
		var i;
		for(i=0; i<tagObjects.length; i++)
		{
			tagObject = tagObjects[ i ];
			if( tagObject.className == className )  resultArray[ resultArray.length ] = tagObject;
			   
		}
		return resultArray;
	}
	//selectorPart = tag
	else if (section.all) {
	    return section.all.tags( selectorPart ); 
	} else if (section) {
	    return section.tags( selectorPart ); 
	} else  {
	  return null;
	}
}

function cleanSelectorPart( selectorPart )
{
	//remove pseudo classes
	var colIndex = selectorPart.indexOf(":");
	if( colIndex != -1 ) return selectorPart.substring( 0, colIndex );
	return selectorPart;
}

function getSelectorElements( selector, section )
{
	var selectorParts = selector.split(" ");
	
	if( selectorParts.length == 2 )
	{
		if( selectorParts[ 1 ] == "*" )
		{
			//selector = part1 *
			//alternative 1: select all contained element
			/*
			var resultSelectorPartElements = new Array();
			
			var selectorPartElements = getSelectorPartElements( selectorParts[ 0 ], section );
			var i;
			for(i=0; i<selectorPartElements.length; i++)
			{
				var selectorPartElement = selectorPartElements[i];
				
				var selectorPartElementAncestors = selectorPartElement.all;
				for(j=0; j<selectorPartElementAncestors.length; j++ )
				{
					resultSelectorPartElements[ resultSelectorPartElements.length ] = selectorPartElementAncestors[j];
				}
			}
			
			return resultSelectorPartElements;
			*/
			//alternative 2: select only container element
			return getSelectorPartElements( selectorParts[ 0 ], section );
		}
	}
	
	var i;
	for(i=0; i<selectorParts.length; i++)
	{
		selectorParts[i] = cleanSelectorPart( selectorParts[i] );
	}
	
	if( selectorParts.length == 0 ) return new Array();
	if( selectorParts.length == 1 ) return getSelectorPartElements( selectorParts[0], section );
	
	//selector = part1 part2 .... partn
	//get elements matching partn
	var selectorPartElements = null;
	selectorPartElements = getSelectorPartElements( selectorParts[ selectorParts.length - 1], section );
	
	var i;
	
	var resultSelectorPartElements = new Array();
	
	if( selectorPartElements == null ) return resultSelectorPartElements;
	
	for(i=0; i<selectorPartElements.length; i++)
	{
		var selectorPartElement = selectorPartElements[i];
		
		if( isSelectorChain( selectorPartElement, selectorParts, selectorParts.length - 2, section ) ) resultSelectorPartElements[ resultSelectorPartElements.length ] = selectorPartElement;
	}
	return resultSelectorPartElements;
}
function getCascade( selectorPart, section )
{
	return overlapArray[ selectorPart ];
}
function getHoveredElements( selector, section )
{
	var hoveredElements = new Array();

	var selectorElements = getSelectorElements( selector, section );
	
	if( selectorElements == null ) return hoveredElements;
	
	for(i=0; i<selectorElements.length; i++ )
	{
		var selectorElement = selectorElements[i];
		
		var cascade = getCascade( selector, section );
		if( ( cascade == null ) || ( cascade.length == 0 ) )
		{				
			hoveredElements[ hoveredElements.length ] = selectorElement;
		}
		else
		{
			var hover = true;
			var j;
			for(j=0; j<cascade.length; j++)
			{
				var cascadeElement = cascade[ j ];
				
				var selectorParts = cascadeElement.split(" ");
				
				if( isSelectorChain( selectorElement, selectorParts, selectorParts.length - 2, section ) ) hover = false;
			}
			if( hover )
			{
				hoveredElements[ hoveredElements.length ] = selectorElement;
			}	
		}
	}
	return hoveredElements;
}

function updateImpact( ari )
{
	impactArray[ari] = new Array();
	var impacts = impactArray[ari];
	var styles = styleArray[ari];

	var j;
	for(j=0; j < styles.length; j++){
		var className = styles[j];

		//determine real classname since classname = .test, a.test, a:test, or just a
		var elements = new Array();
		var firstChar = className.substring(0,1);

		if( firstChar == "#" )
		{
			var blankIndex = className.indexOf(" ");
			if( blankIndex != -1 )
			{
				var curId = className.substring( 1, blankIndex );
				if( document.getElementById( curId ) != null )
				{
					className = className.substring( blankIndex+1, className.length );
					elements = getHoveredElements( className, document.all );
				}
			}
		}
		else
		{
			elements = getHoveredElements( className, document.all );
		}
		if( elements != null ){
			var k;
			for(k=0; k < elements.length; k++){
				var element = elements[k];
				impacts[impacts.length] = element;
			}
		}
	}
}
function showParameterImpact( index ){
	index = parseInt(index);
	var elements = impactArray[index];
	if( elements == null ) return;
	var i;
	var y = 0;
	var elementsLength = elements.length;
	for(i=0; i < elementsLength; i++){
		var element = elements[i];
		element.visited = false;
	}
	var targetDocument = document;
	for(i=0; i < elementsLength; i++){
		var element = elements[i];
		if( !element.visited) {
			y = showParameterImpactElement( element, targetDocument );
			element.visited = true;
		}
	}

	if( y > 10 ) y-= 10; else y = 0;
    
	if( ( window.scrollTo != null ) && ( scrollTo != "off" ) ) targetDocument.body.scrollTop = y;
}

var hoverDivs = new Array();
function hover( index ){
    prepare();
    updateImpact( index );

	if( styleArray.length == 0 ) return;
	removeHoverDivs();

	showParameterImpact( index );
}
function getXPos( obj )
{
	var x = 0, parentElement

	parentElement = obj.offsetParent;
	if( parentElement != null ) x = getXPos( parentElement );
	else x = obj.clientLeft;
	return x + obj.offsetLeft;
}
function getYPos( obj )
{
	var y = 0, parentElement
	parentElement = obj.offsetParent;
	if( parentElement != null ) y = getYPos( parentElement );
	else y = obj.clientTop;
	return y + obj.offsetTop;
}
function showParameterImpactElement( element, doc ){
	var offsetWidth = element.offsetWidth;
	var offsetHeight = element.offsetHeight;
	if( ( offsetWidth > 0 ) && ( offsetHeight > 0 ) ){
		var hoverDiv = doc.createElement("DIV");
		hoverDiv.style.position = "absolute";
		hoverDiv.style.left = getXPos( element )-2;
		var y = getYPos( element );
		hoverDiv.style.top = y-2;
		hoverDiv.style.width = offsetWidth+4;
		hoverDiv.style.height = offsetHeight+4;
		hoverDiv.style.border = "2px solid red";
		hoverDiv.style.fontSize = "1pt";
		hoverDiv.style.zIndex = 200;
		hoverDiv.style.margin = -2;

    
		hoverDivs[ hoverDivs.length ] = hoverDiv;
		doc.body.appendChild( hoverDiv );

		return y;
	}
	return 0;
}
function removeHoverDivs(){
	var i;
	for(i=0; i < hoverDivs.length; i++){
		var hoverDiv = hoverDivs[i];
		hoverDiv.removeNode( true );
	}
}

function removeDownloadImage(){
	this.removeNode();
}
function showDownloadImage(){
	var obj = this;
	if( obj.currentStyle.backgroundImage != null ){
		var url = obj.currentStyle.backgroundImage;
		url = url.substring(5, url.length );
		url = url.substring(0, url.length - 2 );
		
		if( url != "" ){
			var img = document.createElement("IMG");
			img.src = url;

			img.style.position = "absolute";
			img.style.left = event.clientX;
			img.style.top = event.clientY;
			img.style.border = "4px solid red";

			img.onmouseout = removeDownloadImage;

			document.body.appendChild( img );
		}
		event.returnValue = false;
		event.cancelBubble = true;
	}
}