<%@page isErrorPage="false" errorPage="/jsp/internal/errorpage.jsp" %>
<%@taglib uri="/jsp/sap.ur.tld" prefix="page" %>
<%@include file="/jsp/internal/init.jsp" %>

<page:setResourceBundle name="previewtexts" />

<page:render>
      <ur:singleColumnLayout ur:id="scl1">
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c1">
          <ur:textView method="setContent" ur:design="HEADER1" ur:text="PopupMenu"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="setCells" ur:id="scl1c2">
          <ur:textView method="setContent" ur:text="The PopupMenu control is used for connecting a popup menu to, for example, a menu bar."/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells" ur:id="scl1c3">
          <ur:horizontalDivider method="setContent" ur:ruleDisplay="NONE" ur:separationHeight="LARGE"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells">
          <ur:textView method="setContent" ur:text="PopupMenu with a maximum of 8 visible items connected to a PopupTrigger control"/>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells" ur:id="scol_cell4" ur:cellSeparation="XLARGE">
          <ur:popupTrigger method="setContent" ur:hasContent="true" ur:hasPopupMenu="true" ur:id="trigger1" ur:isInteractive="true" ur:popupMenuId="theMenu" ur:triggerIndicator="HOVER">
            <ur:textView method="setContent" ur:id="txt1" ur:text="Click here to open menu"/>
          </ur:popupTrigger>
        </ur:singleColumnLayoutCell>
        <ur:singleColumnLayoutCell method="addCells" ur:id="scol_cell5">
          <ur:popupMenu method="setContent" ur:firstLevelVisible="true" ur:id="theMenu" ur:maxVisibleItems="8">
            <ur:popupMenuItem method="addItems" ur:canCheck="true" ur:checked="true" ur:text="default and checked"/>
            <ur:popupMenuItem method="addItems" ur:canCheck="true" ur:checked="true" ur:enabled="false" ur:text="checked but disabled"/>
            <ur:popupMenuItem method="addItems" ur:text="default item"/>
            <ur:popupMenuItem method="addItems" ur:hasSeparator="true" ur:text="item with separator"/>
            <ur:popupMenuItem method="addItems" ur:enabled="false" ur:text="not checked and disabled"/>
            <ur:popupMenuItem method="addItems" ur:hasSubMenu="true" ur:subMenuId="theMenu" ur:text="item with submenu"/>
            <ur:popupMenuItem method="addItems" ur:canCheck="true" ur:checked="true" ur:enabled="false" ur:isLink="true" ur:text="link-style item"/>
            <ur:popupMenuItem method="addItems" ur:canCheck="true" ur:checked="true" ur:text="Item 8"/>
            <ur:popupMenuItem method="addItems" ur:text="Item 9"/>
            <ur:popupMenuItem method="addItems" ur:enabled="false" ur:hasSubMenu="true" ur:subMenuId="theMenu" ur:text="myPopupMenuItem"/>
            <ur:popupMenuItem method="addItems" ur:hasSeparator="true" ur:hasSubMenu="true" ur:subMenuId="theMenu" ur:text="Personalize"/>
          </ur:popupMenu>
        </ur:singleColumnLayoutCell>
      </ur:singleColumnLayout>
    </page:render>

<%@include file="/jsp/internal/end.jsp" %>