<%@page isErrorPage="false" errorPage="/jsp/internal/errorpage.jsp" %>
<%@taglib uri="/jsp/sap.ur.tld" prefix="page" %>
<%@include file="/jsp/internal/init.jsp" %>

<page:setResourceBundle name="previewtexts" />

<page:render>
      <ur:singleColumnLayout ur:id="scl">
        <ur:singleColumnLayoutCell method="addCells" ur:id="sclC1"/>
        <ur:singleColumnLayoutCell method="addCells" ur:id="sclC2">
          <ur:contextualPanel method="setContent" ur:id="cp" ur:width="200">
            <ur:viewSwitch method="addItems" ur:id="vs">
              <ur:viewSwitchItem method="addItems" ur:text="Header Data"/>
              <ur:viewSwitchItem method="addItems" ur:text="Items"/>
              <ur:viewSwitchItem method="addItems" ur:selected="true" ur:text="Item Details"/>
              <ur:viewSwitchItem method="addItems" ur:text="Notes and Attachments"/>
              <ur:viewSwitchItem method="addItems" ur:text="History"/>
              <ur:viewSwitchItem method="addItems" ur:text="Preview"/>
            </ur:viewSwitch>
        <ur:freeContextualArea method="addItems" ur:design="FILL" ur:id="faSearch">
          <ur:matrixLayout method="setContent" ur:width="100%">
            <ur:matrixLayoutRow method="addRows">
              <ur:matrixLayoutCell method="addCells">
                <ur:label method="setControl" ur:design="EMPHASIZED" ur:designBar="LIGHT" ur:text="Look for"/>
              </ur:matrixLayoutCell>
              <ur:matrixLayoutCell method="addCells" ur:cellDesign="LRNOPAD">
                <ur:comboBox method="setControl" ur:containerWidthSet="true" ur:itemListBoxId="cbContent" ur:width="100%"/>
              </ur:matrixLayoutCell>
            </ur:matrixLayoutRow>
            <ur:matrixLayoutRow method="addRows">
              <ur:matrixLayoutCell method="addCells" ur:cellDesign="LRNOPAD" ur:colSpan="2">
                <ur:inputField method="setControl" ur:width="100%"/>
              </ur:matrixLayoutCell>
            </ur:matrixLayoutRow>
            <ur:matrixLayoutRow method="addRows">
              <ur:matrixLayoutCell method="addCells" ur:cellDesign="LRNOPAD" ur:colSpan="2">
                <ur:flowLayout method="setContent">
                  <ur:flowLayoutItem method="addFlowLayoutItems" ur:itemDesign="LRNOPAD">
                    <ur:button method="setControl" ur:text="Go"/>
                  </ur:flowLayoutItem>
                  <ur:flowLayoutItem method="addFlowLayoutItems" ur:itemDesign="LRNOPAD" ur:itemSeparation="SMALLWITHLINE">
                    <ur:toggleLink method="setControl" ur:text="Advanced Options"/>
                  </ur:flowLayoutItem>
                </ur:flowLayout>
              </ur:matrixLayoutCell>
            </ur:matrixLayoutRow>
          </ur:matrixLayout>
        </ur:freeContextualArea>
            <ur:navigationList method="addItems" ur:expandable="true" ur:title="You Can Also">
              <ur:navigationListGroup method="addGroups">
                <ur:navigationListItem method="addItems" ur:text="Maintain Default Parameter"/>
                <ur:navigationListItem method="addItems" ur:text="Save as Template"/>
                <ur:navigationListItem method="addItems" ur:text="Evaluate Supplier"/>
              </ur:navigationListGroup>
            </ur:navigationList>
            <ur:navigationList method="addItems" ur:title="Related Documents" ur:expandable="true">
              <ur:navigationListGroup method="addGroups">
                <ur:navigationListItem method="addItems" ur:text="Contract"/>
                <ur:navigationListItem method="addItems" ur:text="Purchase Request"/>
                <ur:navigationListItem method="addItems" ur:text="Supplier Evaluation"/>
              </ur:navigationListGroup>
            </ur:navigationList>
          </ur:contextualPanel>
        </ur:singleColumnLayoutCell>
      </ur:singleColumnLayout>
    </page:render>
    
<%@include file="/jsp/internal/end.jsp" %>